<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareCommon\Classes\RestApi;

use Shopware\Components\Api\Exception as ApiException;
use Shopware\Plugins\ViisonCommon\Classes\Util\Util as ViisonCommonUtil;

/**
 * This trait can be used in REST API controllers to upload order document files.
 */
trait OrderDocumentUploading
{
    private static function moveUploadedFile(array $uploadedFile)
    {
        $tempFileName = tempnam(ViisonCommonUtil::getTempDir(), 'temporaryUploadedDocument');
        $success = move_uploaded_file($uploadedFile['tmp_name'], $tempFileName);
        if (!$success) {
            throw new ApiException\CustomValidationException('Failed to upload file "' . $uploadedFile['name'] . '"');
        }

        return $tempFileName;
    }
}
