<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareCommon\Classes;

use Shopware\Plugins\ViisonCommon\Classes\AbstractSubscriberRegistrator;
use Shopware\Plugins\ViisonPickwareCommon\Subscribers;

/**
 * Use this registrator just befor registering your subscribers in the plugin bootstrap:
 *
 *  $viisonPickwareCommonSubscriberRegistrator = new Shopware\Plugins\ViisonPickwareCommon\Classes\SubscriberRegistrator($this);
 *  $viisonPickwareCommonSubscriberRegistrator->registerSubscribers();
 */
class SubscriberRegistrator extends AbstractSubscriberRegistrator
{
    /**
     * @inheritdoc
     */
    protected function createSubscribers()
    {
        $subscribers = [
            new Subscribers\Controllers($this->pluginBootstrap),
            new Subscribers\Api\Api($this->pluginBootstrap),
            new Subscribers\Api\Countries($this->pluginBootstrap),
            new Subscribers\Api\Orders($this->pluginBootstrap),
            new Subscribers\Api\Users($this->pluginBootstrap),
            new Subscribers\Backend\Article($this->pluginBootstrap),
            new Subscribers\Backend\Order($this->pluginBootstrap),
            new Subscribers\Backend\Search($this->pluginBootstrap),
            new Subscribers\Backend\UserManager($this->pluginBootstrap),
            new Subscribers\PickwareCommonRestApiRequestCompatibilityLayerSubscriber(
                $this->pluginBootstrap,
                'Classes/ApiRequestCompatibility/Layers',
                'Shopware\\Plugins\\ViisonPickwareCommon\\Classes\\ApiRequestCompatibility\\Layers'
            ),
            new Subscribers\ServiceDecorationSubscriber($this->pluginBootstrap),
            new Subscribers\Services($this->pluginBootstrap),
            new Subscribers\SubApplicationRegistration($this->pluginBootstrap),
            new Subscribers\ViewLoading($this->pluginBootstrap, 'ViisonPickwareCommon'),
            new Subscribers\Components\DocumentComponentSubscriber($this->pluginBootstrap),
        ];

        // Only load some REST API subscribers if the required classes provided by ViisonPickwareERP are available.
        // This check is necessary because in some update scenarios, e.g. updating a ViisonPickwareMobile to 5.8.0
        // before updating to ViisonPickwareERP 6.0.0 these classes might not be available yet.
        if (class_exists('Shopware\\Plugins\\ViisonPickwareERP\\Components\\RestApi\\RequestLogging\\AbstractRestApiRequestLogFilterSubscriber')) {
            $subscribers[] = new Subscribers\RestApiRequestLogFilterSubscriber($this->pluginBootstrap);
            $subscribers[] = new Subscribers\RestApiRouterSubscriber($this->pluginBootstrap);
        }

        return $subscribers;
    }
}
