<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareCommon\Classes\Subscribers;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;
use Shopware\Plugins\ViisonPickwareCommon\Components\PickwareResourceManager;

// phpcs:ignore VIISON.Classes.AbstractClassName -- cannot change name to keep backwards compatiblity
abstract class PickwareResources extends Base
{
    /**
     * @see \Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base::getSubscribedEvents()
     */
    public static function getSubscribedEvents()
    {
        return [
            PickwareResourceManager::EVENT_FIND_PICKWARE_RESOURCE => 'onFindPickwareResource',
        ];
    }

    /**
     * Returns an associative array containing resource names as keys and the full, namespaced
     * class name of the respective resource implementation as values, e.g.:
     *
     *  return [
     *      'Sample' => 'Shopware\Plugins\ViisonPickwareCommon\Components\Resources\Sample'
     *  ];
     *
     * @return array
     */
    abstract public function getResources();

    /**
     * Fetches all availabel resources using 'getResource()' and returns the one having the
     * 'resourceName' given in the event args.
     *
     * @param \Enlight_Event_EventArgs $args
     * @return string|null
     */
    public function onFindPickwareResource(\Enlight_Event_EventArgs $args)
    {
        $resourceName = $args->get('resourceName');
        $availableResources = $this->getResources();

        return $availableResources[$resourceName];
    }
}
