<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareCommon\Components\DeviceLicensing;

use Exception;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;

class DeviceLicensingException extends Exception implements LocalizableThrowable
{
    use MessageLocalization;

    /**
     * @inheritdoc
     */
    public function __construct($message, $code = 0, Exception $previousException = null)
    {
        parent::__construct($message, $code, $previousException);
        $this->setSnippetNamespace('components/device_licensing');
    }

    /**
     * @return self
     */
    public static function failedToLoadPluginInformation()
    {
        $exception = new self('Failed to load plugin information from Shopware Community Store.');
        $exception->setSnippetName('device_licensing_exception/failed_to_load_plugin_information');

        return $exception;
    }
}
