<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Components\Api\Exception\NotFoundException;
use Shopware\Models\Order\Document\Document;

class Shopware_Controllers_Api_ViisonPickwareCommonDocuments extends Shopware_Controllers_Api_Rest
{
    /**
     * GET /api/documents/{documentId}
     *
     * @throws NotFoundException
     */
    public function getAction()
    {
        $documentId = $this->Request()->get('id');
        $document = $this->getModelManager()->find(Document::class, $documentId);
        if (!$document) {
            throw new NotFoundException(sprintf('Document with ID "%d" does not exist.', $documentId));
        }

        $this->forward('getDocuments', 'ViisonPickwareCommonOrders', null, [
            'id' => $document->getOrderId(),
            'subId' => $documentId,
        ]);
    }

    /**
     * POST /api/documents/{documentId}/send
     *
     * @throws NotFoundException
     */
    public function postSendAction()
    {
        $documentId = $this->Request()->get('id');
        $document = $this->getModelManager()->find(Document::class, $documentId);
        if (!$document) {
            throw new NotFoundException(sprintf('Document with ID "%d" does not exist.', $documentId));
        }

        $this->forward('postDocumentsSendAction', 'orders', null, [
            'id' => $document->getOrderId(),
            'subId' => $documentId,
        ]);
    }
}
