<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareCommon\Structs;

use Shopware\Models\Document\Document;

class CustomDocumentType
{
    /**
     * @var int $id
     */
    protected $id;

    /**
     * @var string $name
     */
    protected $name;

    /**
     * @var PageSize $pageSize
     */
    protected $pageSize;

    /**
     * @param Document $documentType
     * @return CustomDocumentType
     */
    public static function createFromOrderDocumentType(Document $documentType)
    {
        return new CustomDocumentType(
            $documentType->getId(),
            $documentType->getName(),
            new PageSize(
                // Order documents always use a DIN-A4 page size
                'DIN-A4',
                210.0,
                297.0
            )
        );
    }

    /**
     * @param int $id
     * @param string $name
     * @param PageSize $pageSize
     */
    public function __construct($id, $name, PageSize $pageSize)
    {
        $this->id = $id;
        $this->name = $name;
        $this->pageSize = $pageSize;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return PageSize
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }

    /**
     * @param PageSize $pageSize
     */
    public function setPageSize(PageSize $pageSize)
    {
        $this->pageSize = $pageSize;
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'pageSize' => $this->pageSize->toArray(),
        ];
    }
}
