<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareCommon\Subscribers\Api;

use Enlight_Hook_HookArgs;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

class Users extends Base
{
    /**
     * @see \Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base::getSubscribedEvents()
     */
    public static function getSubscribedEvents()
    {
        return [
            'Shopware_Controllers_Api_Users::getAction::after' => 'onAfterGetAction',
        ];
    }

    /**
     * Filter all pickware pin keys.
     *
     * @param Enlight_Hook_HookArgs $args
     */
    public function onAfterGetAction(Enlight_Hook_HookArgs $args)
    {
        $userData = $args->getSubject()->View()->data;
        if (!isset($userData['attribute'])) {
            return;
        }

        unset($userData['attribute']['viisonPickwarePin']);
        unset($userData['attribute']['viisonPickwarePinEncoder']);
        unset($userData['attribute']['pickwareFixedLengthAppPin']);

        $args->getSubject()->View()->data = $userData;
    }
}
