<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareCommon\Subscribers;

use Enlight_Event_EventArgs;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\AbstractBaseSubscriber;
use Shopware\Plugins\ViisonPickwareCommon\Components\OrderSearcherDecorator;

class ServiceDecorationSubscriber extends AbstractBaseSubscriber
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            'Enlight_Bootstrap_AfterInitResource_shopware_es_backend.order_searcher' => 'onAfterInitBackendOrderSearcher',
        ];
    }

    /**
     *
     * @param Enlight_Event_EventArgs $args
     */
    public function onAfterInitBackendOrderSearcher(Enlight_Event_EventArgs $args)
    {
        $args->get('subject')->set(
            'shopware_attribute.order_searcher',
            new OrderSearcherDecorator(
                $args->get('subject')->get('shopware_attribute.order_searcher'),
                'Shopware\\Models\\Order\\Order',
                $this->get('models'),
                $args->get('subject')->get('shopware.model.search_builder')
            )
        );
    }
}
