<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareCommon\Subscribers;

use Shopware\Components\DependencyInjection\Container;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Services as ServicesSubscriber;
use Shopware\Plugins\ViisonPickwareCommon\Components\ApiRequestCompatibilityManager;
use Shopware\Plugins\ViisonPickwareCommon\Components\DeviceLicensing\DeviceLicensingService;
use Shopware\Plugins\ViisonPickwareCommon\Components\DocumentComponentListenerService;
use Shopware\Plugins\ViisonPickwareCommon\Components\Encryption\EncryptionService;
use Shopware\Plugins\ViisonPickwareCommon\Components\PickwareResourceManager;
use Shopware\Plugins\ViisonPickwareCommon\Components\RestApiOrdersResourceService;

class Services extends ServicesSubscriber
{
    /**
     * @inheritdoc
     */
    public static function getServices()
    {
        return [
            'viison_pickware_common.api_request_compatibility_manager' => ApiRequestCompatibilityManager::class,
            'viison_pickware_common.document_component_listener_service' => function (Container $container) {
                return new DocumentComponentListenerService(
                    $container->get('models'),
                    $container->get('events'),
                    $container->get('viison_common.document_file_storage_service')
                );
            },
            'viison_pickware_common.device_licensing' => function (Container $container) {
                return new DeviceLicensingService(
                    $container->get('models'),
                    $container->get('plugin_manager'),
                    $container->get('shopware_plugininstaller.subscription_service')
                );
            },
            'viison_pickware_common.encryption' => function () {
                return new EncryptionService();
            },
            'viison_pickware_common.pickware_resource_manager' => PickwareResourceManager::class,
            'viison_pickware_common.rest_api_orders_resource_service' => function (Container $container) {
                return new RestApiOrdersResourceService(
                    $container->get('db'),
                    $container->get('events')
                );
            },
        ];
    }

    /**
     * Overrides the default implementation to return the path to this library's root path.
     *
     * @see \Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base::getPluginPath()
     */
    public function getPluginPath()
    {
        return __DIR__ . '/../';
    }
}
