<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareCommon\Subscribers;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\SubApplicationRegistration as SubApplicationRegistrationSubscriber;

class SubApplicationRegistration extends SubApplicationRegistrationSubscriber
{
    /**
     * @see \Shopware\Plugins\ViisonCommon\Classes\Subscribers\SubApplicationRegistration::getSubApplications()
     */
    public function getSubApplications()
    {
        return [
            'ViisonPickwareCommonArticlePropertyTypes' => [
                'Article',
                [],
                [],
                null,
                true,
            ],
            'ViisonPickwareCommonArticleModelExtensions' => [
                'Article',
                [],
                [],
                null,
                true,
            ],
            'ViisonPickwareCommonDeviceManagement' => null,
            'ViisonPickwareCommonOrderItemProperties' => [
                'Order',
                [],
                [],
                null,
                true,
            ],
            'ViisonPickwareCommonUserManagerPickwarePIN' => 'UserManager',
        ];
    }

    /**
     * Overrides the default implementation to return the path to this library's root path.
     *
     * @see \Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base::getPluginPath()
     */
    public function getPluginPath()
    {
        return __DIR__ . '/../';
    }
}
