// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareCommonArticlePropertyTypes.controller.Variant', {

    override: 'Shopware.apps.Article.controller.Variant',

    /**
     * @override
     */
    init: function () {
        this.callParent(arguments);

        this.control({
            'article-variant-detail-window viison_pickware_common_article_property_types-type_selection_field': {
                editTypes: this.onViisonPickwareCommonArticlePropertyTypesEditTypes,
            },
        });
    },

    /**
     * Creates a new type editor window.
     *
     * @param Shopware.apps.ViisonPickwareCommonArticlePropertyTypes.view.TypeSelectionField field
     */
    onViisonPickwareCommonArticlePropertyTypesEditTypes: function (field) {
        var controller = this.getController('Shopware.apps.ViisonPickwareCommonArticlePropertyTypes.controller.TypeEditor');
        controller.createEditor(function () {
            field.store.load();
        });
    },

});
