// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareCommonArticlePropertyTypes.store.PropertyType', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareCommonArticlePropertyTypes.model.PropertyType',
    autoLoad: false,
    remoteFilter: true,
    remoteSort: true,
    proxy: {
        type: 'ajax',
        batchActions: true,
        api: {
            create: ViisonCommonApp.assembleBackendUrl('ViisonPickwareCommonArticlePropertyTypes/createPropertyTypes'),
            read: ViisonCommonApp.assembleBackendUrl('ViisonPickwareCommonArticlePropertyTypes/getPropertyTypeList'),
            update: ViisonCommonApp.assembleBackendUrl('ViisonPickwareCommonArticlePropertyTypes/updatePropertyTypes'),
            destroy: ViisonCommonApp.assembleBackendUrl('ViisonPickwareCommonArticlePropertyTypes/deletePropertyTypes'),
        },
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
            messageProperty: 'message',
        },
        writer: {
            type: 'json',
            root: 'data',
            allowSingle: false,
        },
    },

});
