// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareCommonArticlePropertyTypes.view.detail.Settings', {

    override: 'Shopware.apps.Article.view.detail.Settings',

    /**
     * @override
     */
    createBottomElements: function () {
        var elements = this.callParent(arguments);

        // Add combobox
        this.pickwareItemPropertyTypesField = Ext.create('Shopware.apps.ViisonPickwareCommonArticlePropertyTypes.view.TypeSelectionField', {
            name: 'mainDetail[pickwareItemProperties]',
        });
        elements.push(this.pickwareItemPropertyTypesField);

        return elements;
    },

    /**
     * @override
     */
    onStoresLoaded: function (article) {
        var showPickwareItemPropertiesField = article.raw.mainDetail && !article.raw.mainDetail.attribute.pickwareStockManagementDisabled;
        this.pickwareItemPropertyTypesField.setVisible(showPickwareItemPropertiesField);
        this.pickwareItemPropertyTypesField.setDisabled(!showPickwareItemPropertiesField);

        this.callParent(arguments);
    },
});
