// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareCommonArticlePropertyTypes.view.typeEditor.TypeCreator', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_common_article_property_types-type_editor-type_creator',
    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_common_article_property_types/main',
    layout: 'fit',
    modal: true,
    width: 300,
    height: 120,

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('type_editor/type_creator/title');

        this.items = [
            {
                xtype: 'form',
                bodyPadding: 10,
                border: false,
                defaults: {
                    labelWidth: 120,
                },
                items: this.createFormItems(),
            },
        ];
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    /**
     * @return Ext.form.Field[]
     */
    createFormItems: function () {
        return [
            {
                xtype: 'textfield',
                name: 'name',
                fieldLabel: this.getViisonSnippet('type_editor/type_creator/field/name'),
                allowBlank: false,
            },
        ];
    },

    /**
     * @return Ext.toolbar.Toolbar[]
     */
    createDockedItems: function () {
        return [
            {
                xtype: 'toolbar',
                dock: 'bottom',
                ui: 'shopware-ui',
                items: [
                    '->',
                    {
                        xtype: 'button',
                        text: this.getViisonSnippet('type_editor/type_creator/toolbar/button/cancel'),
                        cls: 'secondary',
                        scope: this,
                        handler: function () {
                            this.close();
                        },
                    }, {
                        xtype: 'button',
                        text: this.getViisonSnippet('type_editor/type_creator/toolbar/button/save'),
                        cls: 'primary',
                        scope: this,
                        handler: function () {
                            this.fireEvent('save', this);
                        },
                    },
                ],
            },
        ];
    },

});
