// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareCommonArticlePropertyTypes.view.typeEditor.TypeList', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_common_article_property_types-type_editor-type_list',
    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_common_article_property_types/main',
    split: true,
    border: true,
    autoScroll: true,
    viewConfig: {
        enableTextSelection: true,
    },

    /**
     * @override
     */
    initComponent: function () {
        this.store = Ext.create('Shopware.apps.ViisonPickwareCommonArticlePropertyTypes.store.PropertyType', {
            pageSize: 20,
            sorters: [
                { property: 'name', direction: 'ASC' },
            ],
        });
        this.store.load();
        this.columns = this.createColumns();
        this.dockedItems = this.createDockedItems();
        this.plugins = this.createPlugins();

        this.callParent(arguments);
    },

    /**
     * @return Ext.grid.column.Column[]
     */
    createColumns: function () {
        var actions = this.createActions();

        return [
            {
                dataIndex: 'name',
                header: this.getViisonSnippet('type_editor/type_list/column/name'),
                flex: 1,
                editor: {
                    xtype: 'textfield',
                },
            },
            {
                xtype: 'actioncolumn',
                width: (actions.length * 25),
                items: actions,
            },
        ];
    },

    /**
     * @return Object[]
     */
    createActions: function () {
        return [
            {
                iconCls: 'sprite-minus-circle-frame',
                tooltip: this.getViisonSnippet('type_editor/type_list/action/delete'),
                scope: this,
                handler: function (grid, rowIndex) {
                    this.fireEvent('deletePropertyType', this, grid.getStore().getAt(rowIndex));
                },
            },
        ];
    },

    /**
     * @return Ext.toolbar.Toolbar[]
     */
    createDockedItems: function () {
        return [
            {
                xtype: 'toolbar',
                dock: 'top',
                ui: 'shopware-ui',
                items: [
                    {
                        xtype: 'button',
                        text: this.getViisonSnippet('type_editor/type_list/toolbar/button/create'),
                        iconCls: 'sprite-plus-circle-frame',
                        scope: this,
                        handler: function () {
                            this.fireEvent('createPropertyType', this);
                        },
                    },
                ],
            },
            {
                xtype: 'pagingtoolbar',
                dock: 'bottom',
                store: this.store,
                displayInfo: false,
            },
        ];
    },

    /**
     * @return Ext.AbstractPlugin[]
     */
    createPlugins: function () {
        return [
            {
                ptype: 'rowediting',
                clicksToEdit: 2,
                listeners: {
                    scope: this,
                    edit: function (plugin, event) {
                        this.fireEvent('savePropertyType', this, event.record);
                    },
                },
            },
        ];
    },

});
