// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareCommonArticlePropertyTypes.view.variant.Detail', {

    override: 'Shopware.apps.Article.view.variant.Detail',

    /**
     * @override
     */
    createSettingsFieldSet: function () {
        var fieldSet = this.callParent(arguments);

        if (this.record.get('pickwareStockManagementDisabled')) {
            return fieldSet;
        }

        // Add combobox wrapped in a container
        var propertyTypesField = Ext.create('Shopware.apps.ViisonPickwareCommonArticlePropertyTypes.view.TypeSelectionField', {
            name: 'pickwareItemProperties',
        });
        var bottomContainer = Ext.create('Ext.container.Container', {
            columnWidth: 1,
            layout: 'anchor',
            border: false,
            defaults: {
                anchor: '100%',
            },
            items: [
                propertyTypesField,
            ],
        });
        fieldSet.add(bottomContainer);

        return fieldSet;
    },

});
