// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareCommonDeviceManagement.store.PickwareDevice', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareCommonDeviceManagement.model.PickwareDevice',
    storeId: 'viison_pickware_common_device_management-store-pickware_device',
    autoLoad: false,
    remoteFilter: true,
    remoteSort: true,
    groupField: 'appName',
    proxy: {
        type: 'ajax',
        batchActions: true,
        api: {
            read: '{url controller=ViisonPickwareCommonDeviceManagement action=getDeviceList}',
            update: '{url controller=ViisonPickwareCommonDeviceManagement action=updateDevices}',
            destroy: '{url controller=ViisonPickwareCommonDeviceManagement action=deleteDevices}',
        },
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
        writer: {
            type: 'json',
            root: 'data',
            allowSingle: false,
        },
    },

});
