// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareCommonOrderItemProperties.controller.Main', {

    extend: 'Enlight.app.Controller',

    /**
     * Initialize the controller and listen to the events
     */
    init: function () {
        this.control({
            'order-position-panel': {
                clickOpenStockEntryItemPropertiesWindow: this.onClickOpenStockEntryItemPropertiesWindow,
            },
            'order-position-grid': {
                clickOpenStockEntryItemPropertiesWindow: this.onClickOpenStockEntryItemPropertiesWindow,
            },
            'viison_pickware_common_order_item_properties-list': {
                saveStockEntryItemProperty: this.onSaveStockEntryItemProperty,
                clickEditStockEntryItemProperty: this.onClickEditStockEntryItemProperty,
            },
        });

        this.callParent(arguments);
    },

    /**
     * Open the window that shows the stockItemProperties
     *
     * @param {Shopware.apps.Order.model.Position} orderDetailRecord
     */
    onClickOpenStockEntryItemPropertiesWindow: function (orderDetailRecord) {
        Ext.create('Shopware.apps.ViisonPickwareCommonOrderItemProperties.view.Window', {
            subApplication: this.subApplication,
            orderDetailRecord: orderDetailRecord,
        });
    },

    /**
     * Save and sync the store of the grid with the server when a value was edited
     *
     * @param {Shopware.apps.ViisonPickwareCommonOrderItemProperties.view.List} view
     */
    onSaveStockEntryItemProperty: function (view) {
        var store = view.getStore();
        store.sync();
    },

    /**
     * Start the editing when the pencil in the action column is clicked
     *
     * @param {Shopware.apps.ViisonPickwareCommonOrderItemProperties.view.List} grid
     * @param {Shopware.apps.ViisonPickwareCommonOrderItemProperties.model.ItemProperty} record
     */
    onClickEditStockEntryItemProperty: function (grid, record) {
        grid.cellEditingPlugin.startEdit(record, 1);
    },

});
