// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareCommonOrderItemProperties.store.ItemProperty', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareCommonOrderItemProperties.model.ItemProperty',
    autoLoad: true,
    remoteFilter: true,
    remoteSort: true,
    proxy: {
        type: 'ajax',
        batchActions: true,
        api: {
            read: ViisonCommonApp.assembleBackendUrl('ViisonPickwareCommonOrderItemProperties/getStockItemPropertyValues'),
            update: ViisonCommonApp.assembleBackendUrl('ViisonPickwareCommonOrderItemProperties/updateStockItemPropertyValues'),
        },
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
        writer: {
            type: 'json',
            root: 'data',
            allowSingle: false,
        },
    },

});
