// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareCommonOrderItemProperties.view.List', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_common_order_item_properties-list',
    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_common_order_item_properties/main',

    /**
     * Constructor variables
     */
    orderDetailRecord: null,

    /**
     * @Override
     */
    initComponent: function () {
        this.columns = this.createColumns();

        // Create the grouped store
        this.store = Ext.create('Shopware.apps.ViisonPickwareCommonOrderItemProperties.store.ItemProperty', {
            groupField: 'stockItem.id',
            filters: [
                {
                    property: 'stockLedgerEntry.orderDetailId',
                    value: this.orderDetailRecord.get('id'),
                },
            ],
        });

        this.groupingFeature = Ext.create('ViisonPickwareERP.Ext.grid.feature.Grouping', {
            groupHeaderTpl: this.createGroupHeaderTpl(),
        });

        this.features = [
            this.groupingFeature,
        ];

        this.cellEditingPlugin = Ext.create('Ext.grid.plugin.CellEditing', {
            clicksToEdit: 1,
            listeners: {
                edit: function (editor, e) {
                    this.fireEvent('saveStockEntryItemProperty', this, e.record);
                },
                scope: this,
            },
        });
        this.plugins = [this.cellEditingPlugin];

        this.callParent(arguments);
    },

    /**
     * Create the columns for the list
     *
     * @return {Object[]}
     */
    createColumns: function () {
        return [
            {
                dataIndex: 'itemProperty',
                header: this.getViisonSnippet('list/columns/property_name'),
                flex: 1,
                renderer: function (value) {
                    return value.name;
                },
            },
            {
                dataIndex: 'value',
                header: this.getViisonSnippet('list/columns/value'),
                flex: 1,
                editor: {
                    xtype: 'textfield',
                    allowBlank: true,
                },
            },
            {
                xtype: 'actioncolumn',
                width: 40,
                items: this.createActionItems(),
            },
        ];
    },

    /**
     * Create the action column buttons
     *
     * @return {Object[]}
     */
    createActionItems: function () {
        return [
            {
                iconCls: 'sprite-pencil',
                action: 'edit',
                tooltip: this.getViisonSnippet('list/columns/actions/edit/tooltip'),
                scope: this,
                handler: function (view, rowIndex, columnIndex, item, e, record) {
                    this.fireEvent('clickEditStockEntryItemProperty', this, record);
                },
            },
        ];
    },

    /**
     * Creates the template for the group headers
     *
     * @return {Array}
     */
    createGroupHeaderTpl: function () {
        return [
            this.getViisonSnippet('list/grouping/header_tpl'),
            {
                i: 0,
                itemNumber: function () {
                    this.i += 1;

                    return this.i;
                },
            },
        ];
    },
});
