// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareCommonOrderItemProperties.view.list.Position', {

    override: 'Shopware.apps.Order.view.list.Position',

    /**
     * @Override
     *
     * Add an action column to the table to view the StockItemProperties
     *
     * @return {Object[]}
     */
    getColumns: function () {
        var columns = this.callParent(arguments);

        // Try to find the action column
        var actionColumn;
        Ext.Array.each(columns, function (column) {
            if (column.xtype === 'actioncolumn') {
                actionColumn = column;
            }
        });

        // Add an action for opening the stock entry item properties
        actionColumn.width += 15;
        actionColumn.items.push({
            iconCls: 'sprite-blue-document--pencil',
            tooltip: ViisonCommonApp.getSnippet(
                'order_positions_list/actions/open_stock_entry_item_properties/tooltip',
                'backend/viison_pickware_common_order_item_properties/main'
            ),
            getClass: function (value, meta, record) {
                if (record.get('mode') !== 0 || record.get('viisonNumberOfStockEntryItemProperties') === 0) {
                    return 'x-hide-display';
                }

                return '';
            },
            scope: this,
            handler: function (view, rowIndex, colIndex, item, opts, record) {
                this.fireEvent('clickOpenStockEntryItemPropertiesWindow', record);
            },
        });

        return columns;
    },

});
