// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareCommonOrderItemProperties.view.Window', {

    extend: 'Enlight.app.Window',
    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_common_order_item_properties/main',
    layout: 'border',
    autoShow: true,
    width: 650,
    height: 650,
    border: false,
    maximizable: false,
    minimizable: false,

    /**
     * Constructor variables
     */
    orderDetailRecord: null,

    /**
     * Initialize the component
     */
    initComponent: function () {
        this.items = this.getItems();
        this.title = Ext.String.format(
            this.getViisonSnippet('window/title'),
            this.orderDetailRecord.get('articleName'),
            this.orderDetailRecord.get('articleNumber')
        );

        this.callParent(arguments);
    },

    /**
     * Create the items of the window
     *
     * @return {Object[]}
     */
    getItems: function () {
        return [
            {
                xtype: 'viison_pickware_common_order_item_properties-list',
                region: 'center',
                orderDetailRecord: this.orderDetailRecord,
            },
        ];
    },

});
