// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

// {namespace name=backend/viison_pickware_common_user_manager_pickware_pin/main}

Ext.define('Shopware.apps.ViisonPickwareCommonUserManagerPickwarePIN.view.user.Create', {

    override: 'Shopware.apps.UserManager.view.user.Create',

    /**
     * Creates a new field set, which contains a password style field for the
     * Pickware app PIN. Finally the created field set is inserted into the form.
     *
     * @return The main form including the new Pickware field set.
     */
    getUserForm: function () {
        var form = this.callParent(arguments);

        // Create a Pickware field set containing a PIN field
        var pickwareFieldSet = Ext.create('Ext.form.FieldSet', {
            title: '{s name="user/create/pickware_field_set/title"}{/s}',
            bodyPadding: 10,
            items: [{
                xtype: 'textfield',
                name: 'viisonPickwarePin',
                inputType: 'password',
                fieldLabel: '{s name="user/create/pickware_field_set/pin/label"}{/s}',
                minLength: 4,
                allowBlank: true,
                helpText: '{s name="user/create/pickware_field_set/pin/help_text"}{/s}',
                maskRe: new RegExp('\\d'),
            }],
        });

        // Insert the item after the API field set
        form.insert(2, pickwareFieldSet);

        return form;
    },

});
