<?php
	/**
	 * Shopware 5 Plugin
	 * 
	 * Copyright @ 
	 * Sebastian Schreier 
	 * Update: nico anders
	 * http://www.scharfe-media.de
	 */
	class Shopware_Plugins_Frontend_scha1CheckAge_Bootstrap extends Shopware_Components_Plugin_Bootstrap{
		public function getCapabilities() {
			return array('install' => true, 'update' => true, 'enable' => true);
		}
		
		/**
		 * Returns all necessary information about the plugin.
		 *
		 * @return array
		 */
		public function getInfo(){
			return array(
				'version'     => $this->getVersion(),
				'label'       => $this->getLabel(),
				'supplier'    => 'scharfe media GmbH',
				'author'      => 'Sebastian Schreier|nico anders',
				'description' => 'Mit diesem Plugin können nur Kunden mit dem ausgewählten Mindestalter Artikel im Shop bestellen. 
				Berücksichtigen Sie bitte hierbei, das alle Artikel, bei denen eine Altersbegrenzung festgelegt wurde, eine Kennzeichnung mit der Altersbegrenzung im Beschreinungstext enthalten müssen und der Versand mit einer Altersidentifikation (z.B. DHL PostIdent-Comfort) stattfinden muss. 
				
				Die folgenden Einstellungsmöglichkeiten sollten Sie zusätzlich innerhalb Shopware noch festlegen: 
				
				erstellen Sie ein neues Artikel-Freitextfeld unter "Einstellungen" -> "Grundeinstellungen" -> "Artikel" -> "Artikel-Freitextfelder" beispielsweise mit dem Namen "attr4" vom Typ "Checkbox" und der Feldbezeichnung "Artikel mit Altersbegrenzung". 

				Ergänzen Sie anschließend unter "Einstellungen" -> "Grundeinstellungen" -> "Storefront" -> "Versandkosten-Modul" die "Erweiterte SQL-Abfrage" um den Inhalt ", MAX(at.attr4="true") as artikelMitAltersbegrenzung" und wählen Sie die Option "Ja" bei "Bestellung bei keiner verfügbaren Versandart blocken" aus.
				
				Legen Sie im Anschluss eine neue Versandart unter "Einstellungen" -> "Versandkosten" an und hinterlegen Sie beim Reiter "Erweitere Einstellungen" bei "Eigene Bedingungen" den Wert "artikelMitAltersbegrenzung". Bei allen anderen Versandarten müssen Sie in das gleiche Feld den Wert "!artikelMitAltersbegrenzung" hinterlegen oder ergänzen.
				
				Ebenso müssen Sie, damit innerhalb der Registrierung das Geburtsdatum angezeigt und als Pflichtfeld behandelt wird, unter "Einstellungen" -> "Grundeinstellungen" -> "Storefront" -> "Anmeldung / Registrierung" die Option "Ja" sowohl bei "Geburtstag anzeigen" als auch bei "Geburtstag als Pflichtfeld behandeln" auswählen.',
				'support'     => 'Shopware Forum',
				'link'        => 'http://www.scharfe-media.de'
			);
		}
		
		/**
		 * Get name for plugin manager list
		 * @return string
		 */
		public function getLabel(){
			return 'Altersprüfung bei Einkäufen von Gast- und Bestandskunden';
		}
		
		/**
		 * Returns the current version of the plugin
		 * @return string
		 */
		public function getVersion(){
			return '1.0.8';
		}

		/**
		 * Standard plugin install method to register all required components
		 * @throws \Exception
		 * @return bool success
		 */
		public function install(){
			$this->subscribeEvents();
			
			$this->createConfigForm();

			return array('success' => true, 'invalidateCache' => array('backend','frontend'));
		}

		/**
		 * @return bool
		 */
		public function uninstall(){
			return array('success' => true, 'invalidateCache' => array('backend','frontend'));
		}
		
		/**
		 * @return bool
		 */
		public function update($version) {
			$form = $this->Form();
			
			switch($version) {
				case '1.0.0':
					/* select if the plugin is enabled or disabled */
					$form->setElement('select', 'plugin_active',
						array('label' => 'Plugin aktiv',
							'store' => array(
								array(0, 'Ja'),
								array(1, 'Nein')
							),
							'value' => 0,
							'description' => 'Diese Auswahl ermöglicht es Ihnen, das Plugin zu aktivieren oder zu deaktivieren',
							'scope' => Shopware\Models\Config\Element::SCOPE_SHOP
						)
					);
					
				case '1.0.1': 
				
				case '1.0.2': 
				
				case '1.0.3': 
				
				case '1.0.4': 
				
				case '1.0.5': 
					$this->subscribeEvent(
						'Theme_Compiler_Collect_Plugin_Less',
						'addLessFiles'
					);
					
				case '1.0.6':
				case '1.0.7':
				case '1.0.8':
					break;
				default:
					return false;
			}
			
			return array('success' => true, 'invalidateCache' => array('backend','frontend'));
		}

		/**
		 * Creates the configuration form for the plugin
		 *
		 * @return void
		 */
		protected function createConfigForm(){
			$form = $this->Form();
			
			/* Begin Version 1.0.1 */
			/* select if the plugin is enabled or disabled */
			$form->setElement('select', 'plugin_active',
				array('label' => 'Plugin aktiv',
					'store' => array(
						array(0, 'Ja'),
						array(1, 'Nein')
					),
					'value' => 0,
					'description' => 'Diese Auswahl ermöglicht es Ihnen, das Plugin zu aktivieren oder zu deaktivieren',
					'scope' => Shopware\Models\Config\Element::SCOPE_SHOP
				)
			);
			/* End Version 1.0.1 */
			
			$form->setElement('number', 'minAge', array(
				'label' => 'Mindestalter',
				'minValue' => 1,
				'maxValue' => 140,
				'required' => true,
				'value' => 18,
				'scope' => Shopware\Models\Config\Element::SCOPE_SHOP
			));
		}

		/**
		 * Registers all necessary events and hooks
		 */
		private function subscribeEvents(){
			$this->subscribeEvent(
				'Enlight_Controller_Action_PreDispatch_Frontend_Checkout',
				'onPreDispatchCheckout'
			);
			
			$this->subscribeEvent(
				'Enlight_Controller_Action_PostDispatch_Frontend_Checkout',
				'onPostDispatchCheckout'
			);
			
			$this->subscribeEvent(
				'Enlight_Controller_Action_PreDispatch_Frontend_Register',
				'onPreDispatchRegister'
			);
			
			$this->subscribeEvent(
				'Enlight_Controller_Action_PreDispatch_Frontend_Account',
				'onPreDispatchAccount'
			);
			
			$this->subscribeEvent(
				'Enlight_Controller_Action_Frontend_Account_saveAccountBirthday', 
				'onSaveAccountBirthday'
			);
			
			$this->subscribeEvent(
				'Theme_Compiler_Collect_Plugin_Less',
				'addLessFiles'
			);
		}

		/**
		 * Event listener function which called over the Enlight_Controller_Action_PreDispatch_Frontend_Checkout event
		 * The event fired when the customer is about to finish his checkout, before the actual dispatch
		 */
		public function onPreDispatchCheckout(Enlight_Event_EventArgs $arguments){
			/* get the config parameters */
			$config        = $this->Config();
			
			$plugin_active = $config->get('plugin_active');
			
			if($plugin_active == 1){
				return;
			}
			
			/* Shopware_Controllers_Frontend_Index */
			$subject = $arguments->getSubject();
			
			/* Zend_Controller_Request_Http */
			$request = $subject->Request();
			
			/* $response Zend_Controller_Response_Http */
			$response = $subject->Response();
			
			$action = $request->getActionName();
			
			/* $view Enlight_View_Default */
			$view = $subject->View();

			if(!$request->isDispatched() || $response->isException() || !$view->hasTemplate()){
				return;
			}

			$customerId = Shopware()->Session()->sUserId;
			
			if($action !== "finish" || $customerId === null){
				return;
			}

			/* Get customer by Id */
			$customer = Shopware()->Models()->find('Shopware\Models\Customer\Customer', $customerId);
			
			if(!$customer){
				return;
			}

			$message = $this->checkCustomerAge($customer);

			/* forward to confirmAction and pass the message */
			if($message !== true){
				$subject->forward('confirm', 'checkout', 'frontend', array('sCheckAgeInfo' => $message));
			}
		}

		/**
		 * Helper function which checks if a user is old enough
		 * Returns true if he is or an error message if he is not
		 */
		private function checkCustomerAge($customer){
			$namespace = Shopware()->Snippets()->getNamespace('frontend/checkout/check_age');
			$config  = $this->Config();
			$minAge = $config->get('minAge');
			$plugin_active = $config->get('plugin_active');
			
			if($plugin_active == 1){
				return;
			}
			
			/* Get birthday DateTime and create current DateTime */
			$today = new DateTime("now");
			
			if ($this->assertMinimumVersion('5.2')) {
				$birthday = $customer->getBirthday();
			}else{
				$birthday = $customer->getBilling()->getBirthday();
			}

			if(!$birthday){
				return $namespace->get(
					'age_required',
					'Für Ihr Benutzerkonto wurde keine Altersangabe hinterlegt.',
					true
				);
			}

			/* Get customers age in years */
			$years = $birthday->diff($today)->y;
			
			/* Return message if the user is not old enough */
			if($years < $minAge){
				$snippet = $namespace->get(
					'too_young',
					"Sie müssen mindestens %d Jahre alt sein, um hier zu kaufen.",
					true
				);
				
				return sprintf($snippet, $minAge);
			}

			return true;
		}

		/**
		 * Event listener function which called over the Enlight_Controller_Action_PostDispatch_Frontend_Checkout event
		 * The event fired when the customer is about to finish his checkout, after the actual dispatch
		 */
		public function onPostDispatchCheckout(Enlight_Event_EventArgs $arguments){
			/* get the config parameters */
			$config        = $this->Config();
			
			$plugin_active = $config->get('plugin_active');
			
			if($plugin_active == 1){
				return;
			}
			
			/* Shopware_Controllers_Frontend_Index */
			$subject = $arguments->getSubject();
			
			/* Zend_Controller_Request_Http */
			$request = $subject->Request();
			
			/* $response Zend_Controller_Response_Http */
			$response = $subject->Response();
			
			$action = $request->getActionName();
			
			/* $view Enlight_View_Default */
			$view = $subject->View();

			if($action !== 'confirm' || !$request->isDispatched() || $response->isException() || !$view->hasTemplate()){
				return;
			}

			/* check if the param sCheckAgeInfo was set by our preDispatch method, if this is the case, set sBasketInfo */
			if($request->has('sCheckAgeInfo')){
				$view->assign('sBasketInfo', $request->getParam('sCheckAgeInfo'));
			}
		}
		
		public function onPreDispatchRegister(Enlight_Event_EventArgs $arguments){
			/* get the config parameters */
			$config        = $this->Config();
			
			$plugin_active = $config->get('plugin_active');
			$minAge        = $config->get('minAge');
			
			if($plugin_active == 1){
				return;
			}
			
			/* Shopware_Controllers_Frontend_Index */
			$controller = $arguments->getSubject();

			/* Zend_Controller_Request_Http */
			$request = $controller->Request();

			/* $response Zend_Controller_Response_Http */
			$response = $controller->Response();

			/* $view Enlight_View_Default */
			$view = $controller->View();

			/* Add our plugin template directory to load our checkAge extension. */
			$view->addTemplateDir($this->Path() . 'Views/');			
			$view->assign('minAge', $minAge);
			
//			$compatibilitymode = 0;
			
//			if ($this->assertMinimumVersion('5.2')) {
				$compatibilitymode = 1;
//			}
			
			$view->assign('compatibilitymode', $compatibilitymode);
		}
		
		public function onPreDispatchAccount(Enlight_Event_EventArgs $arguments){
			/* get the config parameters */
			$config        = $this->Config();
			
			$plugin_active = $config->get('plugin_active');
			$minAge        = $config->get('minAge');
			
			if($plugin_active == 1){
				return;
			}
			
			/* Shopware_Controllers_Frontend_Index */
			$controller = $arguments->getSubject();

			/* Zend_Controller_Request_Http */
			$request = $controller->Request();

			/* $response Zend_Controller_Response_Http */
			$response = $controller->Response();

			/* $view Enlight_View_Default */
			$view = $controller->View();

			/* Add our plugin template directory to load our checkAge extension */
			$view->addTemplateDir($this->Path() . 'Views/');
			$view->assign('minAge', $minAge);
			
//			$compatibilitymode = 0;
			
			if ($this->assertMinimumVersion('5.2')) {
				$compatibilitymode = 1;
			}
			
			$view->assign('compatibilitymode', $compatibilitymode);
		}
		
		public function onSaveAccountBirthday(Enlight_Event_EventArgs $args){
			if ($this->assertMinimumVersion('5.2')) {}else{
				/* get the config parameters */
				$config        = $this->Config();
				
				$plugin_active = $config->get('plugin_active');

				if($plugin_active == 1){
					return;
				}
				
				/* $view Enlight_View_Default */
				$view = $args->getSubject()->View();
				
				$view->addTemplateDir($this->Path() . 'Views/');
				
				/* get the user id from the logged-on user */
				$userId = Shopware()->Session()->sUserId;

				/* get the selected birthday */
				$postData = $args->getSubject()->Request()->getPost();
				$birthday = $postData["accountbirthday"];
				$birthmonth = $postData["accountbirthmonth"];
				$birthyear = $postData["accountbirthyear"];

				$birthdate = $birthyear."-".$birthmonth."-".$birthday;
				
				/* update the birthday from the user */
				if ($this->assertMinimumVersion('5.2')) {
					$sqlAccount = 'UPDATE s_user SET birthday = ? WHERE id = ?';
				}else{
					$sqlAccount = 'UPDATE s_user_billingaddress SET birthday = ? WHERE userID = ?';
				}	
				
				Shopware()->db()->query($sqlAccount,array($birthdate, $userId));
				
				/* redirect to the account site */
				$args->getSubject()->redirect('account');
				
				return true;
			}
		}
		
		public function addLessFiles(Enlight_Event_EventArgs $args) {
		   $less = new \Shopware\Components\Theme\LessDefinition(
			  array(),
			  array(
				 __DIR__ . '/Views/frontend/_public/src/less/all.less'
			  ),
			  __DIR__
		   );
		   return new Doctrine\Common\Collections\ArrayCollection(array($less));
		}
	}