<?php
/**
 * premsoft
 * Copyright © 2016 Premsoft - Sven Mittreiter
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License, supplemented by an additional
 * permission, and of our proprietary license can be found
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, titles and interests in the
 * above trademarks remain entirely with the trademark owners.
 *
 * @copyright  Copyright (c) 2016, premsoft - Sven Mittreiter (http://www.premsoft.de)
 * @author     Sven Mittreiter <info@premsoft.de>
 */
use Doctrine\Common\Collections\ArrayCollection;

class Shopware_Plugins_Frontend_PremsOnePageCheckout_Bootstrap extends Shopware_Components_Plugin_Bootstrap
{
  public function getInfo()
  {
    return array(
      'version' => $this->getVersion(),
      'label' => $this->getLabel(),
      'autor' => 'PremSoft',
      'description' => 'One Page Checkout',
      'support' => 'Herstellerseite',
      'link' => 'http://www.premsoft.de'
    );
  }

  /**
   * Returns the current version of the plugin.
   * @return string
   * 1.1.0: Lokalisierung eingebaut
   * 1.2.0: Responsive Features eingebaut
   * 1.3.0: Logout eingebaut
   * 1.6.0: Rechnungsadresse/ Lieferadresse ändern eingebaut
   * Es wurde ein Problem bei der Auswahl der Versandart und Zahlweise behoben
   * 1.7.0: Plugin ist pro Subshop aktivierbar
   * 1.7.1: Es wurde ein Problem bei der der Artikelmenge behoben
   * 1.8.0: Merkzettel im leeren Warenkorb anzeigen
   * 2.2.0: Anfangsbuchstaben von Rechnungs- und Lieferadresse werden in Großbuchstaben korrigiert
   * 2.2.1: Es wurde ein Problem behoben beim Aufruf des OPC
   * 2.4.2: Die Optik des OPC wurde für responsive optimiert; Neue Option für vertikale Darstellung eingebaut; Es wurde ein Problem behoben welches beim Login auftreten konnte; Es wurde ein Problem bei Rechnung-/ Lieferadresse ändern behoben welches in Zusammenhang mit Änderungen von Versand oder Zahlweise auftreten konnte
   * 2.5.0: Unterstützung für Shopware Statistik abgebrochene Bestellungen eingebaut
   * 2.6.0: Andere Rechnungs-/ Lieferadresse wählen eingebaut
   * 2.7.0: Unterstützung für weitere Zahlarten eingebaut (PayPal Plus, Heidelpay)
   * 2.7.1: Anzeigeproblem gefixt wenn der OPC ohne Artikel im Warenkorb aufgerufen wird
   * 2.7.2: Anzeigeproblem behoben welches in Verbindung mit einer Neuregistrierung auftreten konnte
   * 2.7.3: Es wurde ein Problem behoben wenn bei der Rechnungsadresse das Telefonfeld pflicht ist.
   * 2.7.4: Es wurde ein überflüssiger und fehlerhafter Javascript Schnippsel aus den Templates entfernt
   * 3.0.0: Neuer Release für Unterstützung von Shopware ab Version 5.2;
   *        Überarbeitung der Rechnungs-/Lieferadressen Funktion
   * 3.0.1: Es wurde ein Problem mit der Gastkontobestellung bei Shopware ab Version 5.2 behoben
   * 3.3.2: Billpay CSS Optimierungen eingebaut
   * 3.3.3: Es ist nun immer ein Land bei der Registrierung ausgewählt
   * 3.4.0: Das Plugin Rechnung und Ratenkauf von Klarna wird jetzt für Shopware Version 5.1. unterstützt
   * 3.4.1: Anpassung für altes DHL Integration Plugin eingebaut
   * 3.4.2: Es wurde ein Problem Behoben bei dem im Einsatz mit PHP 7 ein Fehler im OPC auftreten konnte
   * 3.4.3: Für Shopware 5.1.x wurde ein Problem bei PayPal Plus behoben
   * 3.5.0: Für Autocomplete über google places wurde eine Optimierung im Länder Dropdown eingebaut
   * 3.5.1: Der Testbaustein ConfirmErrorStock wurde um den fehlenden Namespace ergänzt so das nun auf den Shopware Standard Textbaustein Text zugegriffen wird
   * 3.5.2: Es wurde ein Problem behoben bei dem durch Ladezeitverzögerungen es in manchen Fällen zu Problemen mit PayPal Plus kommen konnte
   * 3.6.0: Es wurde die Möglichkeit eingebaut die Prämien Produktauswahl auch im OPC zur Verfügung zu stellen
   * 3.6.1: Für Shopware 5.2.x wurde ein Problem mit der Ust-ID bei der Unternehmensregistrierung behoben
   * 3.6.2: Es wurde ein Problem mit dem Plugin shop master ultimate und der gemeinsamen Nutzung des Footer behoben
   * 3.6.3: Es wurde ein Problem mit der Formatierung bei der Registrierung auf dem iPhone behoben
   * 3.6.4: Es wurde ein Problem beim Nachladen von Zahlarten behoben
   * 3.6.5: Es wurde ein Problem mit Shopware 5.2.15 welches mit PHP 7 auftreten konnte behoben
   * 3.6.6: Für Shopware 5.0.1 wurde ein Javascript Fix eingebaut
   * 3.6.7: Ein Problem mit dem Textbaustein ConfirmHeadlineAdditionalOptions wurde behoben
   * 3.6.8: Es wurde ein Problem mit PHP 7 behoben
   * 3.6.9: Darstellungsprobleme auf dem Galaxy S5 wurden behoben
   * 3.7.0: AGB Checkbox kann nun wahlweise auch oberhalb des Bestellprozesses eingebunden werden (Abmahnsicherheit)
   * 3.7.1: Anzeige der AGB Box über Bestellprozess nur wenn Nutzer eingeloggt ist.
   * 3.7.2: Es wurde eine Anpassung der AGB Anzeige eingebaut
   * 3.8.0: Unterstützung für PayOne Kreditkarte wurde eingebaut
   * 3.9.0: SwagBonussystem wird jetzt korrekt im OPC dargestellt
   * 3.9.1: Abstand Checkbox AGB Text korrigiert
   * 3.9.2: Es wurde ein CSRF Token Problem behoben bei dem manchmal der Payment Bereich nicht korrekt geladen wurde
   * 3.10.0: Option eingebaut die es ermöglicht die separate Lieferadresse im Checkout zu deaktivieren.
   * 3.10.1: Es wurde ein Problem mit Lastschrift bei Shopware 5.2.x behoben
   * 4.0.0: Jetzt werden noch mehr Zahlarten unterstützt: Stripe; PayOne; Amazon Pay; Shopware Lastschrift
   * 4.1.0: Es wurde eine Option eingebaut mit der ein Nutzer bei PayPal Zahlabbruch oder Fehler direkt auf den One Page Checkout weitergeleitet werden kann
   * 4.1.1: Ein Problem wurde behoben welches je nach Konfiguration in Verbindung mit PayOne oder Stripe auftreten konnte
   * 4.2.0: Die Kompabilität mit dem Plugin "Warenkorb Geschenke / Prämienartikel Advanced" wurde hergestellt
   * 4.2.1: Es wurde ein Problem bei der Länderauswahl behoben
   * 4.2.2: Sind unterschiedliche Steuerregeln je Land hinterlegt so wird die Steuer nun nach dem Login direkt korrekt aktualisiert
   * 4.2.3: Unterstützung für "SEPA Lastschrift Erweiterung SW5" Plugin eingebaut
   * 4.2.4: Es wurde ein Problem mit dem PayOne Zahlungsart Dropdown behoben
   * 4.2.5: Bei Amazon Pay wurde die "Versandart wählen" Dopplung entfernt
   * 4.2.6: Anpassungen für Änderungen beim PayPalPlus Plugin wurden eingebaut
   * 4.2.7: Kompabilitätsupdate für Theme: "ThemeWare Modern"
   * 4.2.8: Es wurde eine Korrektur für die Option eingebaut mit der ein Nutzer bei PayPal Zahlabbruch oder Fehler direkt auf den One Page Checkout weitergeleitet werden kann
   * 4.2.9: Bei Shopware 5.0.x konnte es zu einem Problem bei Zahlung mit PayPal kommen. Dieses wurde behoben
   * 4.3.0: Option: Weiterleitung zu Paymentseite für einzelne Zahloptionen eingebaut.
   * Eine Neuinstallation des Plugins ist notwendig um diese Option in den Plugineinstellungen nutzen zu können.
   * 4.4.0: Es wurden Styling Anpassungen durchgeführt
   * 4.4.1: Eine ausgewählte Zahlart mit vorhandenen Formularfeldern wird jetzt optisch hervorgehoben bzw. kann auch wieder editiert werden
   * 4.4.2: Die Kompabilität zur neusten Amazon Pay Version wurde hergestellt
   * 4.4.3: Der Amazon Pay Text wurde unter dem Login integriert.
   * 4.4.4: Für Shopware 5.2.x wurde ein Problem beim Adresszusatzfeld Naming behoben
   * 4.5.0: Kompabilitätsupdate für Theme: "ThemeWare Modern"; Es wurde eine Option eingebaut mit der der Bestellungseinführungstext oberhalb des One Page Checkout aktiviert und deaktiviert werden kann.
   * 4.5.1: Es wurde ein Problem behoben, das bei Cronjob Ausführung der One Page Checkout ein PHP Notice generiert
   * 4.5.2: Bei Nutzung des Stripe Plugins werden jetzt die Logos im Checkout korrekt angezeigt
   * 5.0.0: Einbau einer Option um einzustellen, ob die Artikeleigenschaften im Checkout mit angezeigt werden.
   *        Es wurden Layout Probleme behoben.
   *        Ab Shopware 5.2.x gibt es jetzt den Kompabilitätsmodus, der aktiviert werden kann. Dieser kann bei Zahlartenplugins helfen, die zwingend einen Login erfordern, und zuvor eine weiße Seite im Checkout erzeugt haben.
   *        Payolution ist ab sofort mit dem One Page Checkout kompatibel.
   *        Unterstützung von BillSafe mit neuem Kompabilitätsmodus (ab Shopware 5.2.x).
   *        Unterstützung von CustomWeb Zahlartenplugins mit neuem Kompabilitätsmodus (ab Shopware 5.2.x).
   * 5.0.1: Im Kompabilitätsmodus wird jetzt die Bestellübersicht angezeigt.
   * 5.0.2: Unter manchen Umständen wurde der Shop-Header auf der ShippingPayment Seite nicht gezeigt. Dies wurde korrigiert.
   * 5.0.4: Der Kompabilitätsmodus wurde verbessert da dieser bei manchen Zahlartenplugins nicht gegriffen hat.
   *        Ein Anzeigefehler in der mobile Ansicht wurde behoben
   * 5.1.0: Es wurde die neue Option "Registrierungsbereich initial geöffnet" eingebaut.
   * 5.1.1: Die Loginfehlermeldung wurde in den ausklappbaren Loginbereich verschoben, so das diese nun beim Zuklappen nicht mehr sichtbar ist.
   * 5.1.2: Bei Verwendung von Bundesländern wurden diese nicht initial mit angezeigt. Das Problem wurde behoben.
   * 5.2.0: Eine Option "Anmeldung als Firma" wurde eingebaut. Hiermit ist es möglich die Privatkundenregistrierung zu deaktivieren
   * 5.3.0: Es wurden Anpassungen an den Templates zur Unterstützung neuer Shopware Versionen vorgenommen.
   * 5.3.1: Ein Problem mit Ingenico (fehlender Detail Link) wurde behoben.
   * 5.3.2: Ein Kompabilitätsupdate für 5.3.x wurde durchgeführt.
   * 5.3.3: Es wurde ein Problem behoben bei der Validierung der "Email Adressenwiederholung".
   * 5.3.4: Ein Kompabilitätsupdate für 5.3.x wurde durchgeführt.
   * 5.3.5: Anpassung Template im ausgeloggten Zustand (Div um Shipping Block, zur Unterstützung von Drittanbieter Themes)
   * 5.3.6: Für SW 5.3.x wurde ein Problem behoben bei dem die Bundeslandauswahl nicht angezeigt wurde.
   * 5.3.7: Im Plugin-Kompabilitätsmodus wurde ein Problem mit den Plugineinstellungen behoben.
   * 5.3.8: Es wurde ein Seitenreload Problem beim Hinzufügen der abweichenden Lieferadresse behoben.
   * 5.4.0: Es wurde ein Block "frontend_opc_personal_fieldset" eingebaut um den "personal fieldset" Bereich zu überschreiben
   * 5.5.0: Die Blöcke "frontend_opc_login", "frontend_opc_billing_fieldset" und "frontend_opc_shipping_fieldset" wurden hinzugefügt.
   * 5.6.0: Blöcke um die Passwortfelder wurden ergänzt
   * 5.6.1: In manchen Fällen gab es Schwierigkeiten mit dem PayPal Plus Javascript mit anderen Zahlarten. Dieses Problem wurde behoben.
   * 5.6.2: Es wurde ein Ladeproblem von PayPalPlus behoben welches im Zusammenhang mit Shopware 5.1. und dem Firefox auftreten konnte.
   * 5.6.3: Ein Stripe Problem wurde behoben, welches in Verbindung mit Darstellung der AGBs oberhalb des Checkouts auftreten konnte.
   * 5.6.4: Im nicht-eingeloggten Kompabilitätsmodus wurde der Formular Verweis für das Gutscheinformular korrigiert.
   * 5.6.5: Es wurde ein Problem behoben das der OPC in Subshops nicht korrekt deaktiviert werden konnte.
   * 5.6.6: Es wurde ein Styling Problem beim Geburtsdatum behoben.
   * 5.6.7: Ein Problem mit der AGB Darstellung bei Verwendung des ThemeWareModern Themes wurde behoben
   * 5.6.8: Ein Problem mit der "Adressdaten unvollständig" Meldung bei Verwendung des ThemeWareModern Themes wurde behoben
   * 5.7.0: Kompabilität mit DHL Wunschpaket Plugin hergestellt.
   * 5.8.0: Kompabilität mit Post NL Plugin hergestellt.
   * 5.8.1: Eine Sicherheitslücke, mit der es möglich war die Heidelpay Rechnungskauf Überprüfung zu umgehen, wurde behoben.
   * 5.8.2: Kompabilitätsupdate für neue AmazonPay Plugin Version.
   * 5.9.0: Eine Option wurde eingebaut mit der ein "Nach Login/Registrierung verfügbar" Hinweistext für Schritt 2 und 3 gezeigt wird.
   * 5.9.1: Unter Shopware 5.2.x wurde ein Problem bei Verwendung von Adresszusatz 1 in der abweichenden Lieferanschrift behoben.
   * 6.0.0: Unterstützung für Shopware 5.3.x Captcha eingebaut.
   * 6.1.0: Anpassung für Post NL Plugin hinzugefügt.
   * 6.1.1: Der ESD Textbaustein Namespace wurde korrigiert.
   * 6.1.2: Es wurde ein Problem behoben, wenn die ESD Checkbox nicht angehackt wurde.
   * 6.1.3: Ein Problem mit dem DHL Wunschpaket Plugin wurde behoben.
   * 6.1.4: Ein Problem mit dem DHL Wunschpaket Plugin wurde behoben.
   * 6.2.0: Es wurde ein Problem mit "Rechnung und Ratenkauf von Klarna" behoben.
   * 6.2.1: Anpassung Kompabilitätsmodus: Weiterleitung bei leerem Warenkorb.
   * 6.2.2: Es wurde ein Redirect Problem auf der Kompabilitätsmodus Seite bei Nutzung eines falschen Gutscheincodes im nicht eingeloggten Zustand behoben.
   * 6.3.0: Die Kompabilität mit der Concardis Payengine wurde hergestellt.
   * 6.3.1: Ein Problem mit dem Abstand des PLZ Fehlers in Verbindung mit unserem Plugin "Auto-Complete" wurde behoben.
   * 6.4.0: Kompabilitätsupdate für Shopware 5.4.x
   * 6.4.1: Es wurde ein Problem mit dem DHL-Wunschpaket Plugin behoben, wenn dieses aktiviert aber für einen Subshop deaktiviert ist.
   * 6.4.2: Kompabilitätsupdate ab Shopware 5.3.7 für die korrekte Anzeige von Dropdown Fehlern.
   * 6.4.3: Es wurde ein Warenkorb Problem behoben welches in bestimmten Shopware Versionen auftreten konnte.
   * 6.4.4: Das Strassenfeld wurde auf 30 Zeichen begrenzt da dies bei anderen Plugins wie der DHL Schnittstelle sonst zu Problemen führt.
   * 6.4.5: Nach Loginfehler wird das Feld E-Mail jetzt vorausgefüllt.
   * 6.4.6: Es wurde ein Problem mit "Rechnungen und Ratenkauf von Klarna" behoben bei dem sich teilweise mit jeden Reload die Klarna Links verdoppelt haben.
   * 6.4.7: Die Variable useOnePageCheckout wurde jetzt auch in den Templates veröffentlicht (interessant für andere Pluginanbieter wegen Kompabilität)
   * 6.5.0: Einbau Fehlermeldung Textbaustein bei Auswahl Versand-/ Zahlart, wenn keine Versandart zur Verfügung steht aber als Pflicht eingestellt ist. Der Textbaustein lautet "PremsOnePageCheckoutNoShippingAvailable"
   * 6.5.1: Less Anpassungen zur grafischen Optimierung der Darstellung beim One-Click-Upsell
   * 6.6.0: Auf Mobilgeräten wird für die bessere Übersichtlichkeit jetzt nur noch Schritt 2 auf der shippingPayment Seite gezeigt.
   * 6.7.0: Eine Option wurde eingebaut, mit der standardmäßig die Gastregistrierung aktiviert ist.
   * 6.7.1: Die Kompabilität mit dem Plugin "DSGVO Toolbox" von netzperfekt wurde hergestellt.
   * 6.7.2: Ein Problem bei Verwendung meherer Zahlweisen mit DHL Wunschpaket wurde behoben.
   * 6.7.3: Im shipping_payment Template wurden Korrekturen an den Blöcken durchgeführt.
   * 6.8.0: Anpassung an die in Shopware 5.4.3 eingeführten neuen Datenschutz Optionen.
   * 6.8.1: Die DHL Wunschpaket Versandkostenneuberechnung bei Wechsel von Wunschtag und Wunschzeit wurde eingebaut.
   * 6.9.0: Eine neue Option zur Bestimmung der Position der Felder: E-Mail Adresse, Passwort, Gastkonto wurde für die Registrierung im OnePageCheckout eingebaut (ab SW.5.2.)
   * 6.9.1: Ein Problem bei Registrierung mit DHL Wunschpaket in der abweichenden Lieferadresse wurde behoben.
   * 6.9.2: Probleme bei der Mobil Darstellung wurden behoben.
   * 6.9.3: Ein Problem mit der PayPalExpress Button Darstellung wurde behoben.
   * 6.9.4: Es wurde ein Problem mit Klarna Rechnungskauf behoben wenn die Datenübermittlungs-Checkbox nicht angehackt wurde.
   * 6.9.5: Ein doppelter Text bei Verwendung von DHL Wunschpaket wurde entfernt.
   * 6.9.6: Styling Anpassungen für Payolution Plugin
   * 6.9.7: Kleine Style Korrekturen Desktop/ Mobile
   * 6.10.0: Die Kompabilität mit dem neuen PayPal Plugin wurde hergestellt.
   * 6.10.1: Es wurde ein Problem behoben bei dem es möglich war die Payolution Auth zu umgehen.
   * 6.11.0: Rückleitung zum OPC von shippingPayment Seite bei Standard Zahlungsarten eingebaut.
   * 6.11.1: Es wurde ein Problem mit dem PayPal Unified Plugin in Verbindung mit der ExpressCheckout Rückführung behoben.
   * 6.11.2: Ein Anzeigeproblem mit dem PayPal Unified Plugin unter Shopware 5.2. wurde behoben.
   * 6.11.3: Es wurde ein Problem mit dem PayPal Express Checkout bei Nutzung des PayPal Unified Plugins behoben.
   * 6.11.4: Anpassungen für das PayPal Unified responsive Verhalten wurden vorgenommen.
   * 6.11.5: Ein Problem mit neueren Stripe Versionen wurde behoben.
   * 6.11.6: Ein Problem mit neueren Stripe Versionen wurde behoben.
   * 6.12.0: PayPalUnified Update für Express und Plus.
   * 6.12.2: Ein Update Problem von 6.12.0 wurde behoben.
   * 6.12.3: Es wurde ein Problem behoben, wenn PayPal installiert, für den aktuellen Shop aber nicht aktiviert wurde.
   * 6.12.4: Ein Problem mit der Klick-Sektion für das RestylePaymentArea von PayPal Unified wurde behoben.
   * 6.12.5: Die Weiterleitung von PayPal Express wurde korrigiert.
   * 6.13.0: Die Pluginoption "AGB Status speichern" wurde eingebaut. Diese sorgt dafür, das eine einmal angehackte AGB Checkbox, angehackt bleibt, auch wenn die Seite neu geladen wird.
   * 6.14.0: Es wurde eine Option eingebaut mit der die maximal erlaubte Zeichenanzahl des Strassenfeldes bei Registrierung festgelegt werden kann (Default: 30)
   * 6.15.0: Option "Länder Dropdown keine Vorauswahl" wurde hinzugefügt. Wenn aktiviert, wird für die OPC Registrierung nicht das erste Land des Dropdowns vorausgewählt
   * 7.0.0: - Gutschein und Kommentarfeld können jetzt oberhalb des Checkouts dargestellt werden (ab Shopware 5.2)
   *        - Das Kommentarfeld kann optional ausgeblendet werden, so das nur das Gutscheinfeld sichtbar ist (ab Shopware 5.2)
   *        - Kompabilität mit WalleePayment Plugin wurde hergestellt.
   *        - Der Shopware Bugfix (ab Shopware 5.5.4) für die AGB Sprungmarke auf iPhones wurde eingebaut
   *        - Anpassungen für die neueste Version von Stripe Payment wurden eingebaut (Bitte zuvor das Stripe Plugin updaten)
   * 7.0.1: Die Optik des PayPal iFrames wurde angepasst an die restlichen Zahlarten.
   * 7.0.2: Es wurde ein Anzeigeproblem behoben, wenn die AGBs oben dargestellt werden sollen, aber das Gutscheinfeld nicht.
   * 7.1.0: Eine Anpassung für "DHL Wunschpaket" wurde eingebaut. Bitte vor dem Update auf die neueste "DHL Wunschpaket" Pluginversion aktualisieren.
   * 7.1.1: Der PayPal Express Button wird nun korrekt im OPC ausgeblendet wenn bei PayPal die Option "'Direkt zu PayPal' auf Loginseite" abgewählt wurde.
   * 7.1.2: Die fehlende Lokalisierung für die Pluginoptionen wurde eingebaut.
   * 7.2.2: Einbau der Session Variable "premsOnePageCheckoutActive". Diese zeigt an, das unser OnePageCheckout aktiv ist und kann von anderen Pluginherstellern genutzt werden.
   * 7.3.0: Umbau der Template Registrierung um SmartySecurityError vorzubeugen.
   * 7.4.0: Unterstützung für Niederländisch und Französisch eingebaut.
   * 7.4.1: Es wurde ein Problem mit dem neuen PayPal Plugin behoben, welches auf der shippingPayment Seite zu Mehrfach-Reloads führen konnte.
   * 7.5.0: Die optionale Anzeige der Artikel Eigenschaften wurde für Shopware 5.5. angepasst.
   * 7.6.0: Unterstützung für CrefoPay wurde hergestellt.
   * 7.7.0: Anpassung der Anrede bei Registrierung im OPC: Anweichende Werte von mr,ms sind jetzt möglich.
   * 7.8.0: Kompabilitätsupdate für Shopware 5.5.8
   * 7.8.1: Das Problem fehlender Meldungen bei Nutzung des Registrierungs-Double-Optin Verfahrens wurde behoben
   * 7.8.2: Ein Problem wurde behoben das bei Shopware 5.5. nach Eingabe eines Gutscheins die Zahlart nicht mehr vorausgewählt ist.
   * 7.9.0: Es wurde die Möglichkeit eingebaut den URL Pfad zu ändern, der bei Aufruf des Kompabilitätsmodus gezeigt wird.
   * 7.10.0: - Die Pluginoption "Kommentar speichern" wurde eingebaut. Diese sorgt dafür, das ein ausgefülltes Kommentarfeld befüllt bleibt, auch wenn die Seite neu geladen wird.
   *         - Es wurden mehr Blöcke in die Template eingebaut, so das eine Anpassung einfacher ist
   * 7.10.1: Anpassung der Anrede bei Registrierung im OPC: Anweichende Werte von mr,ms sind jetzt bei der Lieferadresse möglich.
   * 7.10.2: Kompabilitätsanpassung für SW 5.5.9 für geändertes "Ich bin" Feld
   * 7.11.0: Einbau Sprungmarke bei Zahlungsartwechsel (ab SW 5.5.0).
   * 7.11.1: Wichtiges Update: Ein Fehler mit PayPal Plus im Firefox wurde behoben.
   * 7.11.2: Braintree Support hinzugefügt (ab SW 5.5.0)
   * 8.0.0: Anpassungen für SW 5.6 wurden umgesetzt.
   * 8.1.0: Einbau Customweb Sripe Kompabilität
   * 8.1.1: Styling Anpassungen für mobile.
   * 8.1.2: Einbau "Lieferung in dieses Land nicht möglich" Funktionalität vom Shopware Standard.
   * 8.1.3: Anpassung Bestellbutton bei "Lieferung in dieses Land nicht möglich"
   * 8.1.4: Ein Problem mit der Anzeige der Navigation im Checkout bei Shopware 5.6.x wurde behoben.
   * 8.1.5: Ein Übersetzungsproblem mit dem PayPal Button wurde behoben.
   * 8.1.6: Es wurden Kompabilitätsanpassungen für CrefoPay vorgenommen.
   * 8.1.7. Ein Problem bei ungültiger Lieferadresse in SW 5.5 zu bestellen wurde behoben.
   * 8.1.8. Kompabilitätsanpassungen für das SocialLogin Plugin von NetInventors wurden vorgenommen.
   * 8.2.1. Styling Anpassungen für PayPal Ratenzahlung.
   * 8.2.2. Die Kompabilität zum neuen Heidelpay Plugin für Shopware 5.6.x wurde hergestellt.
   * 8.3.0. Ein Kompabilitätsproblem mit Shopware Custom Products wurde behoben
   *        Die Shopware Option zum Ausblenden des Gutscheinfeldes wird jetzt für Shopware 5.6.x berücksichtigt
   * 8.3.1. Ein Problem mit der Formatierung des Kommentartfeldes unter Shopware 5.6.x in Verbindung mit Custom Products wurde behoben.
   * 8.3.2. Ein Problem mit der Anzeige von Skonto unter Shopware 5.6.x in Verbindung mit Custom Products wurde behoben.
   * 8.3.3. Das fehlende Titel Feld bei der Registrierung mit Shopware 5.6.x wurde eingebaut.
   * 8.3.4. Kompatibilitätsanpassungen für Crefopay.
   * 8.3.6. Option zum Reload des BuyPanel eingebaut.
   * 8.3.7. Anpassung des validateUsingAjax Javascripts um ein Problem zu beheben, wenn mehrere Formulare in der Checkout Registrierung vorhanden sind.
   * 8.4.0. Die Kompabilität mit PayOne Klarna wurde hergestellt
   * 8.5.0. Option eingebaut mit der das automatische Scrollen zu Schritt 2 im vertikalen Modus aktiviert/ deaktiviert werden kann.
   * 8.6.0. Es wurde die Möglichkeit für Shopware 5.6.x eingebaut eine zusätzliche Checkbox im Checkout anzuzeigen.
   * 8.6.2. Kompabilitätsanpassung für das neue Heidelpay Plugin.
   * 8.6.3. Es wurde das Problem behoben, das bei ESD Downloads eine Gastkontoregistrierung möglich war.
   * 8.6.4. Es wurden Kompatibilitätsanpassungen für PostFinanz Checkout Payment durchgeführt.
   * 8.6.5. Der Logout Text ist jetzt per Snippet übersetzbar.
   * 8.7.0. Die Kompabilität mit dem Plugin CwbPayEngine3CwCheckout wurde hergestellt.
   * 8.8.0. Einbau Kompabilität für StorePickup Plugin.
   * 8.8.1: Die Anzeige von Ländern bei Registrierung mit einer abweichenden Liederadresse wurde korrigiert.
   * 8.8.2: Es wurden Anpassungen für das Crefopay Plugin vorgenommen.
   * 8.8.3: Einbau eines Buttons um zurück zu kommen, falls keine gültige Versandart verfügbar ist.
   * 8.8.4: Abhängig von der Shopware Einstellung "Zahlungsart bei Bestellung immer auswählen" wird jetzt bei Login/Registrierung zu Schritt 2 weitergeleitet.
   * 8.8.5: Die Kompatibilität mit Unzer Payment für Shopware 5 wurde hergestellt.
   * 8.8.6: - Der Login Button für das Amazon Pay Plugin wurde eingebaut.
   *        - Es wurden Kompatibilitätsanpassungen für Crefopay durchgeführt.
   * 8.8.7: - Es wurden Anpassungen für PHP 8 vorgenommen.
   * 8.8.8: - Es wurde ein Problem mit der Lieferadressse unter PHP 8 behoben.
   * 8.8.9: - Eine Anpassung für das PayPalUnified Plugin ab Version 4.0.0 wurde vorgenommen. Wichtig: Bitte führen Sie unser Pluginupdate nur aus, wenn Sie PayPalUnified mindestens in der Version 4.0.0 einsetzen oder PayPalUnified nicht einsetzen.
   * 8.8.10: - Wenn bei PayPal der Express Button nicht aktiviert ist, so konnte dies im Loginbereich vom OnePageCheckout zu einem Problem führen. Dies wurde behoben.
   * 8.8.11: - Für PayPal ab 4.0.0 wurde eine Anpassung eingebaut, das man nicht zweimal seinen PayPal Login eingeben muss.
   * 8.8.12: - Korrektur der Anzeige des AGB Textes bei Darstellung über Bestellen Button.
   * 8.8.13: - Ein Problem mit PayPal 4.0.0, im Zusammenhang mit Zahlart Kreditkarte, wurde behoben
   * 8.8.14: - Ein Problem mit PayPal 4.1.3, im Zusammenhang mit "Kauf auf Rechnung", wurde behoben.
   * 8.8.15: - Für PayPal 4.2.3  wurde ein Problem mit Zahlung per Kreditkarte behoben.
   * 8.8.16: - Es wurde eine Anpassung für Adyen Payment vorgenommen.
   * 8.8.17: - Es wurde ein Problem mit dem Bestellkommentar für Shopware Versionen ab 5.7.0 behoben
   *         - Ein Problem mit PayPal 6.0.0 wurde behoben.
   * 8.8.19: - Ein Problem mit PayOne Kreditkarte wurde behoben.
   * 8.8.20: - Korrektur der PayPal Button Größe auf mobilen Endgeräten.
   * 8.9.1: - Die Anrede ist ab Shopware 5.7.17 kein Pflichtfeld mehr, wenn konfiguriert.
   * 8.9.2: - Ein Problem mit der Shopware Version 5.7.0-5.7.16 wurde behoben.
   * 8.9.3: - Das Problem von fehlenden Ländern im Dropdown wurde behoben.
   * 8.9.5: - Es wurden Anpassungen für das "DHL Wunschzustellung" Plugin vorgenommen.
   * 8.9.6: - Es wurden Anpassungen für Shopware 5.7 vorgenommen.
  */
  public function getVersion()
  {
    return '8.9.6';
  }

  /**
   * Get (nice) name for plugin manager list
   * @return string
   */
  public function getLabel()
  {
    return 'One Page Checkout';
  }

  public function getCapabilities()
  {
    return array(
      'install' => true,
      'update' => true,
      'enable' => true
    );
  }

  public function afterInit() {
    $this->Application()->Loader()->registerNamespace('Shopware\PremsOnePageCheckout', __DIR__ . DIRECTORY_SEPARATOR);
    $this->Application()->Loader()->registerNamespace('Shopware\Components', $this->Path() . 'Components/');
  }

  public function update($version) {
    $update = new \Shopware\PremsOnePageCheckout\Config\Update($this);
    $update->execute($version);
    return array('success' => true, 'invalidateCache' => array('frontend', 'backend', 'config', 'proxy'));
  }

  /**
   * Registrieren der Subscriber
   * @param \Enlight_Event_EventArgs $args
   */
  public function onRegisterSubscriber(\Enlight_Event_EventArgs $args) {
    $container = $this->collection->Application()->Container();

    $subscribers = array(
      new \Shopware\PremsOnePageCheckout\Subscriber\Resource($this),
      new \Shopware\PremsOnePageCheckout\Subscriber\Checkout($container, $this),
      new \Shopware\PremsOnePageCheckout\Subscriber\Register($this),
      new \Shopware\PremsOnePageCheckout\Subscriber\ControllerPath($this),
    );

    if (!$this->isShopware52()) {
      // Subscriber für Rechnungs-/ Lieferadresse wird nur für Shopware < 5.2 benötigt. Dannach wird der
      // neue Shopware eigene ajaxEditor Layer benutzt
      $subscribers[] = new \Shopware\PremsOnePageCheckout\Subscriber\Admin($this);
    }

    foreach ($subscribers as $subscriber) {
      $this->Application()->Events()->addSubscriber($subscriber);
    }
  }

  public function install()
  {
    $this->subscribeEvent('Enlight_Controller_Front_StartDispatch', 'onRegisterSubscriber');
    $this->subscribeEvent('Shopware_Console_Add_Command', 'onRegisterSubscriber');

    if ($this->isShopware52()) {
        (new \Shopware\PremsOnePageCheckout\Config\Attribute(
            Shopware()->Container()->get('shopware_attribute.crud_service'))
        )->install();

      $this->subscribeEvent(
        'Enlight_Bootstrap_AfterInitResource_shopware_account.address_validator',
        'replaceAddressValidatorService',
        200
      );
    }

    $this->subscribeEvent(
      'Theme_Compiler_Collect_Plugin_Less',
      'onCollectLessFiles'
    );

    $this->subscribeEvent(
      'Theme_Compiler_Collect_Plugin_Javascript',
      'onCollectJavascriptFiles'
    );

    $this->updateSchema();

    $form = new \Shopware\PremsOnePageCheckout\Config\Form($this);
    $form->setForm();

    return true;
  }

  public function replaceAddressValidatorService() {
    $coreService = Shopware()->Container()->get('shopware_account.address_validator');
    $addressValidatorService = new Shopware\PremsOnePageCheckout\Service\AddressValidator($coreService);
    Shopware()->Container()->set('shopware_account.address_validator', $addressValidatorService);
  }

  public function disable() {
    return array('success' => true, 'invalidateCache' => array('config', 'frontend', 'backend', 'router', 'search', 'proxy'));
  }

  public function enable() {
    return array('success' => true, 'invalidateCache' => array('config', 'frontend', 'backend', 'router', 'search', 'proxy'));
  }

  /**
   * @return ArrayCollection
   */
  public function onCollectLessFiles() {
    if ($this->isShopware57()) {
      $lessDir = __DIR__ . '/Views/shopware57/frontend/_resources/src/less/';
    } elseif ($this->isShopware56()) {
        $lessDir = __DIR__ . '/Views/shopware56/frontend/_resources/src/less/';
    } elseif ($this->isShopware55()) {
      $lessDir = __DIR__ . '/Views/shopware55/frontend/_resources/src/less/';
    } elseif ($this->isShopware53()) {
      $lessDir = __DIR__ . '/Views/shopware53/frontend/_resources/src/less/';
    } elseif ($this->isShopware52()) {
      $lessDir = __DIR__ . '/Views/shopware52/frontend/_resources/src/less/';
    } else {
      $lessDir = __DIR__ . '/Views/shopware5/frontend/_resources/src/less/';
    }

    $less = new \Shopware\Components\Theme\LessDefinition(
      array(),
      array(
        $lessDir . 'opc.less'
      )
    );

    return new ArrayCollection(array($less));
  }

  /**
   * @return ArrayCollection
   */
  public function onCollectJavascriptFiles()
  {
    if ($this->isShopware57()) {
        $jsDir = __DIR__ . '/Views/shopware57/frontend/_resources/src/js/';
        $jsLibs = array(
            $jsDir . 'jquery.opc.js'
        );
    } elseif ($this->isShopware56()) {
      $jsDir = __DIR__ . '/Views/shopware56/frontend/_resources/src/js/';
      $jsLibs = array(
        $jsDir . 'jquery.opc.js'
      );
    } elseif ($this->isShopware55()) {
      $jsDir = __DIR__ . '/Views/shopware55/frontend/_resources/src/js/';
      $jsLibs = array(
        $jsDir . 'jquery.opc.js'
      );
    } elseif ($this->isShopware53()) {
      $jsDir = __DIR__ . '/Views/shopware53/frontend/_resources/src/js/';
      $jsLibs = array(
        $jsDir . 'jquery.opc.js'
      );
    } elseif ($this->isShopware52()) {
      $jsDir = __DIR__ . '/Views/shopware52/frontend/_resources/src/js/';
      $jsLibs = array(
        $jsDir . 'jquery.opc.js'
      );
    } else {
      $jsDir = __DIR__ . '/Views/shopware5/frontend/_resources/src/js/';

      if ($this->assertMinimumVersion("5.1.0")) {
        $jsLibs = array(
          $jsDir . 'jquery.opc.js',
        );
      } else {
        // Shopware 5.0.x benötigt eine andere JS Datei da sich die Namen der Shopware JS Libs ab 5.1.0 ändern
        $jsLibs = array(
          $jsDir . 'jquery.opc.50.js',
        );
      }
    }

    return new ArrayCollection($jsLibs);
  }

  public function uninstall()
  {
    return array('success' => true, 'invalidateCache' => array('config', 'frontend', 'backend', 'router', 'search', 'proxy'));
  }

  protected function updateSchema()
  {
  }

  /**
   * Prüft ob mindestes Shopware Version 5.5.9 vorliegt
   * @return bool
   */
  public function isShopware559() {
    return $this->assertMinimumVersion("5.5.9");
  }

  /**
   * Prüft ob mindestes Shopware Version 5.4.3 vorliegt
   * @return bool
   */
  public function isShopware543() {
    return $this->assertMinimumVersion("5.4.3");
  }

  /**
   * Prüft ob mindestes Shopware Version 5.5.8 vorliegt
   * @return bool
   */
  public function isShopware558() {
    return $this->assertMinimumVersion("5.5.8");
  }

  /**
   * Prüft ob mindestes Shopware Version 5.7 vorliegt
   * @return bool
   */
  public function isShopware57() {
      return $this->assertMinimumVersion("5.7.0");
  }

  /**
   * Prüft ob mindestes Shopware Version 5.7.17 vorliegt
   * @return bool
   */
  public function isShopware5717() {
    return $this->assertMinimumVersion("5.7.17");
  }

  /**
   * Prüft ob mindestes Shopware Version 5.6 vorliegt
   * @return bool
   */
  public function isShopware56() {
    return $this->assertMinimumVersion("5.6.0");
  }

  /**
   * Prüft ob mindestes Shopware Version 5.5 vorliegt
   * @return bool
   */
  public function isShopware55() {
    return $this->assertMinimumVersion("5.5.0");
  }

  /**
   * Prüft ob mindestes Shopware Version 5.3 vorliegt
   * @return bool
   */
  public function isShopware53() {
    return $this->assertMinimumVersion("5.3.0");
  }

  /**
   * Prüft ob mindestes Shopware Version 5.2 vorliegt
   * @return bool
   */
  public function isShopware52() {
    return $this->assertMinimumVersion("5.2.0");
  }
}