<?php
/**
 * premsoft
 * Copyright © 2018 Premsoft - Sven Mittreiter
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License, supplemented by an additional
 * permission, and of our proprietary license can be found
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, titles and interests in the
 * above trademarks remain entirely with the trademark owners.
 *
 * @copyright  Copyright (c) 2018, premsoft - Sven Mittreiter (http://www.premsoft.de)
 * @author     Sven Mittreiter <info@premsoft.de>
 */
namespace Shopware\PremsOnePageCheckout\Config;

use Shopware\Bundle\AttributeBundle\Service\CrudService;

class Attribute
{

  /** @var CrudService */
  protected $crudService;

  /**
   * Attribute constructor.
   * @param CrudService $crudService
   */
  public function __construct(CrudService $crudService)
  {
    $this->crudService = $crudService;
  }

  public function uninstall() {
    try {
      $this->crudService->delete('s_order_attributes', 'prems_opc_additional_checkbox');
    } catch(\Exception $e) {

    }
  }

  public function install()
  {
    $this->crudService->update('s_order_attributes', 'prems_opc_additional_checkbox', 'boolean', [
      'label' => 'OPC Checkout Checkbox',
      'custom' => false,
      'displayInBackend' => true,
      'position' => 200,
    ]);

    $metaDataCache = Shopware()->Models()->getConfiguration()->getMetadataCacheImpl();
    $metaDataCache->deleteAll();
    Shopware()->Models()->generateAttributeModels(['s_order_attributes']);
  }
}
