<?php
/**
 * premsoft
 * Copyright © 2019 Premsoft - Sven Mittreiter
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License, supplemented by an additional
 * permission, and of our proprietary license can be found
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, titles and interests in the
 * above trademarks remain entirely with the trademark owners.
 *
 * @copyright  Copyright (c) 2019, premsoft - Sven Mittreiter (http://www.premsoft.de)
 * @author     Sven Mittreiter <info@premsoft.de>
 */
namespace Shopware\PremsOnePageCheckout\Config;

use Shopware_Plugins_Frontend_PremsOnePageCheckout_Bootstrap as Bootstrap;

class Form {
    /**
     * @var Bootstrap $bootstrap
     */
    protected $bootstrap;

    /**
     * @param Bootstrap $bootstrap
     */
    public function __construct(Bootstrap $bootstrap) {
        $this->bootstrap = $bootstrap;
    }

    /**
     * Eingabefelder für Backend (Plugin-Einstellungen) setzen
     */
    public function setForm() {
        $form = $this->bootstrap->Form();

        $form->setElement('checkbox', 'useOnePageCheckout', array(
            'label' => 'Plugin für diesen Shop nutzen',
            'value' => 1,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));
        $form->setElement('checkbox', 'useStepsOnlyVertical', array(
            'label' => 'Schritte immer vertikal darstellen',
            'description' => 'Normalerweise werden die Checkout Schritte bei ausreichend Platz nebeneinander dargestellt und brechen erst bei kleineren Auflösungen um. Ist diese Option aktiviert, so werden die Schritte immer untereinander dargestellt.',
            'value' => false,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));

        $form->setElement('checkbox', 'premsShowPremiumProductArea', array(
            'label' => 'Prämien Produktauswahl nutzen',
            'value' => 0,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));

        $form->setElement('checkbox', 'premsAgbOnTop', array(
            'label' => 'AGBs oben darstellen',
            'description' => 'Laut https://de.shopware.com/news/die-wichtigsten-antworten-zur-button-loesung-fachanwalt-thomas-feil-im-interview/ ist es sicherer die AGBs direkt sichtbar oben im OPC darzustellen. Bitte beachten: Bei einigen Shop Themes können die AGBs nur oberhalb dargestellt werden.',
            'value' => 1,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));

        $form->setElement('checkbox', 'premsOnePageCheckoutVoucherOnTop', array(
            'label' => 'Gutscheinbox oben darstellen (ab SW 5.2)',
            'description' => 'Stellt die Gutscheinbox oberhalb des OnePageCheckouts dar. Bitte beachten Sie, das im Shopware Backend unter "Einstellungen->Grundeinstellungen->Storefront->Bestellabschluss->Zeige weitere Optionen an" aktiviert sein muss.',
            'value' => 0,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));

        $form->setElement('checkbox', 'premsOnePageCheckoutNoCommentArea', array(
            'label' => 'Kommentarfeld ausblenden (ab SW 5.2)',
            'description' => 'Blendet das Kommentarfeld aus. Bitte beachten Sie, das im Shopware Backend unter "Einstellungen->Grundeinstellungen->Storefront->Bestellabschluss->Zeige weitere Optionen an" aktiviert sein muss, da ansonsten das Kommentarfeld nicht verfügbar ist',
            'value' => 0,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));

        $form->setElement('checkbox', 'premsOnePageCheckoutSaveAgbStatus', array(
            'label' => 'AGB Status speichern',
            'description' => 'Speichert den Status der AGB Checkbox. Wurden die AGB angehackt und wird dann der Checkout neu geladen, sind die AGB weiter angehackt solange die Session des Nutzers besteht.',
            'value' => 0,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));

        $form->setElement('checkbox', 'premsOnePageCheckoutSaveComment', array(
            'label' => 'Kommentar speichern',
            'description' => 'Speichert den Inhalt des Kommentar Feldes. Wurde das Kommentar Feld ausgefüllt und wird dann der Checkout neu geladen, ist das Kommentar weiterhin ausgefüllt solange die Session des Nutzers besteht.',
            'value' => 0,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));

        $form->setElement('checkbox', 'premsShowArticleProperties', array(
            'label' => 'Artikel Eigenschaften anzeigen',
            'description' => 'Bei aktiver Option werden im Checkout die Artikeleigenschaften der Artikel (insofern gepflegt) dargestellt.',
            'value' => false,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));

        $form->setElement('checkbox', 'premsShowOrderText', array(
            'label' => 'Einführungstext auf Bestellseite anzeigen',
            'description' => 'Bei aktiver Option wird oberhalb des One Page Checkouts der Text -Bestellung: Bitte füllen Sie die nachfolgenden Felder aus, um die Bestellung abzuschließen- angezeigt.',
            'value' => 0,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));

        $form->setElement('checkbox', 'premsAdditionalShippingDisable', array(
            'label' => 'Separate Lieferadresse hinzufügen deaktivieren',
            'description' => 'Entfernt die Möglichkeit im Checkout eine abweichende Lieferadresse zu wählen',
            'value' => 0,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));

        $form->setElement('checkbox', 'premsOnePageCheckoutReloadBuyboy', array(
            'label' => 'Kaufen Box reloaden',
            'description' => 'Lädt die Kaufen Box nach dem Laden der Zahlarten neu. Normalerweise wird diese Option nicht 
      benötigt. Bitte nur aktivieren, wenn von unserem Support empfohlen.',
            'value' => 0,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));

        $form->setElement('checkbox', 'premsOnePageCheckoutScrollToStep2', array(
            'label' => 'Zu Schritt 2 springen',
            'description' => 'Ist der vertikale Modus aktiv und der Nutzer eingeloggt/ registriert, dann wird automatisch zu Schritt 2 gescrollt.',
            'value' => 1,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));

        $form->setElement(
            'button',
            'premsOpcThirdVendorProps',
            array(
                'label' => '<strong>Einstellungen Drittanbieter Plugins</strong>',
            )
        );
        $form->setElement('text', 'premsOpcPaymentsRedirectToPaymentPage',
            array(
                'label' => 'Zahlarten IDs zur Weiterleitung',
                'description' => 'Kommaseparierte Liste von Zahlarten IDs bei denen eine Weiterleitung zur Payment Page erfolgen soll.
        Diese Option hilft beispielsweise Klarna Zahlung auf Rechnung zu unterstützen. Bitte IDs in der Form 1,5,20 hinterlegen
        ',
                'value' => NULL
            )
        );
        $form->setElement('checkbox', 'premsOpcCompabilityMode', array(
            'label' => 'Kompabilitätsmodus aktivieren (ab SW 5.2)',
            'description' => 'Aktivieren Sie diese Option wenn statt dem Checkout eine weiße Seite gezeigt wird. Manche Payment Plugins setzen zwingend einen Login vorraus und können mit dieser Option dann genutzt werden.',
            'value' => 1,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));
        $form->setElement('text', 'premsOpcCompabilityModeUrl',
            array(
                'label' => 'Alternativer URL Pfad Kompabilitätsmodus',
                'value' => 'checkout_login',
                'description' => 'Bei aktiviertem Kompabilitätsmodus, wird der Nutzer im Checkout auf die URL PremsOnePageCheckout weitergeleitet. Hier haben Sie die Möglichkeit eine alternative URL zu definieren wie z.B.: checkout_login',
            )
        );

        $form->setElement(
            'button',
            'premsOpcRegister',
            array(
                'label' => '<strong>Einstellungen Registrierung</strong>',
            )
        );
        $form->setElement('checkbox', 'premsOpcDefaultRegisterAsGuest', array(
            'label' => 'Gastregistrierung per Default aktiviert',
            'description' => 'Wenn aktiviert, wird standardmäßig immer die Gastregistrierung Checkbox angehackt.',
            'value' => false,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));
        $form->setElement('checkbox', 'registerBeforeLogin', array(
            'label' => 'Registrierung vor Login',
            'description' => 'Wenn aktiviert, wird die Registrierung vor dem Login gezeigt.',
            'value' => false,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));
        $form->setElement('checkbox', 'loginInitiallyOpen', array(
            'label' => 'Loginbereich initial geöffnet',
            'description' => 'Wenn aktiviert, wird der Loginbereich initial offen gezeigt.',
            'value' => true,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));
        $form->setElement('checkbox', 'premsRegisterInitiallyOpen', array(
            'label' => 'Registrierungsbereich initial geöffnet',
            'description' => 'Wenn aktiviert, wird der Registrierungsbereich initial offen gezeigt.',
            'value' => false,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));
        $form->setElement('checkbox', 'zipBeforeStreet', array(
            'label' => 'PLZ vor Straße',
            'description' => 'Wenn aktiviert, wird die die PLZ vor der Straße gezeigt. Dies kann sinnvoll sein wenn Sie einen Autocomplete nutzen',
            'value' => false,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));
        $form->setElement('checkbox', 'premsRegisterOnlyAsCompany', array(
            'label' => 'Anmeldung als Firma (bis SW 5.5.8)',
            'description' => 'Wenn aktiviert, können sich Kunden nur als Firma registrieren. Ab SW 5.5.9 ist die Einstellung hinfällig, da Shopware diese von Haus aus bietet.',
            'value' => false,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));
        $form->setElement('checkbox', 'premsOpcShowAfterLoginRegistrationAvailableText', array(
            'label' => 'Zeige Hinweistext vor Login/ Registrierung',
            'description' => 'Wenn aktiviert, wird den Kunden ein Hinweistext gezeigt, das Schritt 2 und 3 nach dem Login/ Registrierung verfügbar sind.',
            'value' => false,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));
        $form->setElement('select', 'premsOnePageCheckoutEmailPassPosition', array(
            'label' => 'E-Mail und Passwortabfrage Position (ab SW 5.2)',
            'description' => 'Zeigt das E-Mail, Passwort und Gastkonto Formularfeld bei der Registrierung als erstes, an der Standard Shopware Position, oder als letztes an.',
            'store' => array(
                array(0, 'Shopware Default'),
                array(1, 'Top'),
                array(2, 'Bottom')
            ),
            'value' => 0,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));

        $form->setElement('number', 'premsOnePageCheckoutStreetMaxLength', array(
            'label' => 'Maximal erlaubte Zeichenanzahl Straße',
            'description' => 'Legt fest, wieviele Zeichen maximal beim Feld Straße in der Registrierung des OnePageCheckout eingegeben werden dürfen (ab Shopware 5.2.x)',
            'min' => 30,
            'max' => 255,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));
        $form->setElement('checkbox', 'premsOnePageCheckoutShowCountryDisabledDefault', array(
            'label' => 'Länder Dropdown keine Vorauswahl',
            'description' => 'Wenn aktiviert, wird für die OPC Registrierung nicht das erste Land des Dropdowns vorausgewählt',
            'value' => 0,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));
        $form->setElement('checkbox', 'premsNoConfirmFooterBeforeLogin', array(
            'label' => 'Summe bevor Login nicht anzeigen',
            'description' => 'Der Bereich für Gesamtsumme, Versandkosten, MwSt. wird erst nach Login/ Registrierung angezeigt',
            'value' => 0,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));

        $form->setElement(
            'button',
            'premsOpcAdditionalCheckbox',
            array(
                'label' => '<strong>Zusätzliche Checkbox</strong>',
            )
        );
        $form->setElement('checkbox', 'premsOnePageCheckoutShowAdditionalCheckbox', array(
            'label' => 'Zusätzliche Checkbox anzeigen',
            'description' => 'Zeigt eine zusätzliche Checkbox im Checkout an',
            'value' => 0,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));
        $form->setElement('checkbox', 'premsOnePageCheckoutAdditionalCheckboxIsRequired', array(
            'label' => 'Pflichtfeld',
            'value' => 0,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));
        $form->setElement('checkbox', 'premsOnePageCheckoutAdditionalCheckboxIsChecked', array(
            'label' => 'Vorausgefüllt',
            'value' => 0,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));
        $form->setElement('checkbox', 'premsOnePageCheckoutAdditionalCheckboxAfterAgb', array(
            'label' => 'Checkbox nach AGB Checkbox anzeigen',
            'description' => 'Standardmäßig wird die Checkbox vor den AGBs gezeigt',
            'value' => 0,
            'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
        ));

        $this->bootstrap->addFormTranslations($this->getFormTranslations());
    }

    /**
     * Returns all translations for the plugin configuration
     *
     * @return array
     */
    private function getFormTranslations() {
        return array(
            'en_GB' => array(
                'useOnePageCheckout' => array(
                    'label' => 'Enable plugin for this store',
                ),
                'useStepsOnlyVertical' => array(
                    'label' => 'Steps always vertical',
                    'description' => 'Normally, the checkout steps are displayed side by side with sufficient space and only break at smaller resolutions. If this option is activated, the steps are always displayed one below the other.',
                ),
                'premsShowPremiumProductArea' => array(
                    'label' => 'Enable bonus product selection',
                ),
                'premsAgbOnTop' => array(
                    'label' => 'Terms and conditions above',
                    'description' => 'Please note: For some shop themes, the terms and conditions can only be displayed above.',
                ),
                'premsOnePageCheckoutVoucherOnTop' => array(
                    'label' => 'Show coupon box above (since SW 5.2)',
                    'description' => 'Shows the voucher box above the OnePageCheckout. Please note that in Shopware backend under "Configuration -> Basic settings-> Frontend -> Checkout -> Display further options" must be activated.',
                ),
                'premsOnePageCheckoutNoCommentArea' => array(
                    'label' => 'Hide comment field (since SW 5.2)',
                    'description' => 'Hides the comment field. Please note that in the Shopware backend under "Configuration -> Basic settings-> Frontend -> Checkout -> Display further options" must be activated, otherwise the comment field is not available.',
                ),
                'premsOnePageCheckoutSaveAgbStatus' => array(
                    'label' => 'Save terms and conditions status',
                    'description' => 'Saves the status of the AGB Checkbox. If the terms and conditions have been checked and then the checkout is reloaded, the terms and conditions continue to be checked as long as the session for the user exists.',
                ),
                'premsOnePageCheckoutSaveComment' => array(
                    'label' => 'Save comment text',
                    'description' => 'Saves the text of the comment field. If the comment field has beend filled and then the checkout is reloaded, the comment text is available as long as the session for the user exists.',
                ),

                'premsShowArticleProperties' => array(
                    'label' => 'Show article properties',
                    'description' => 'If this option is active, the article properties of the articles (if maintained) are displayed in the checkout.',
                ),
                'premsShowOrderText' => array(
                    'label' => 'Show introduction text on order page',
                    'description' => 'If this option is active, the text "Order: Please fill in the following fields to complete the order" is displayed above the One Page Checkout.',
                ),
                'premsAdditionalShippingDisable' => array(
                    'label' => 'Disable separate delivery address',
                    'description' => 'Removes the possibility to choose a different delivery address in the checkout',
                ),
                'premsOnePageCheckoutReloadBuyboy' => array(
                    'label' => 'Reload buybox (since SW 5.5)',
                    'description' => 'Reload buybox after loading payment methods. Please only activate if suggested by our support.',
                ),
                'premsOnePageCheckoutScrollToStep2' => array(
                    'label' => 'Scroll to step 2',
                    'description' => 'Srolls automaticly to step 2 if vertical modus is active and user is registered.',
                ),
                'premsOpcThirdVendorProps' => array(
                    'label' => '<strong>Third party plugin settings</strong>',
                ),
                'premsOpcPaymentsRedirectToPaymentPage' => array(
                    'label' => 'Payment IDs for forwarding',
                    'description' => 'Comma-separated list of payment methods IDs that should be redirected to the payment page. For example, this option helps Klarna to support payment on account. Please deposit IDs in the form 1,5,20',
                ),
                'premsOpcCompabilityMode' => array(
                    'label' => 'Enable compatibility mode (since SW 5.2)',
                    'description' => 'This option should always be active. Otherwise, depending on the plugins used, error pages may appear in the checkout or incorrect delivery addresses may be assigned. ',
                ),
                'premsOpcCompabilityModeUrl' => array(
                    'label' => 'Alternative URL path compatibility mode',
                    'description' => 'If the compatibility mode is activated, the user is forwarded to the URL PremsOnePageCheckout in the checkout. Here you have the option to define an alternative URL such as: checkout_login.',
                ),

                'premsOpcRegister' => array(
                    'label' => '<strong>Registration settings</strong>',
                ),
                'premsOpcDefaultRegisterAsGuest' => array(
                    'label' => 'Guest registration activated by default',
                    'description' => 'If activated, the guest registration checkbox is always checked by default.',
                ),
                'registerBeforeLogin' => array(
                    'label' => 'Registration before login',
                    'description' => 'If activated, the registration will be shown before login.',
                ),
                'loginInitiallyOpen' => array(
                    'label' => 'Login area initially opened',
                    'description' => 'If activated, the login area is initially displayed open.',
                ),
                'premsRegisterInitiallyOpen' => array(
                    'label' => 'Registration area initially opened',
                    'description' => 'If activated, the registration area is initially displayed open.',
                ),
                'zipBeforeStreet' => array(
                    'label' => 'Zip before street',
                    'description' => 'If activated, the zip will be shown before the street. This can be useful if you use an autocomplete',
                ),
                'premsRegisterOnlyAsCompany' => array(
                    'label' => 'Registration as a company (until SW 5.5.8)',
                    'description' => 'When activated, customers can only register as a company. Since SW 5.5.9 shopware is shipped with an own option.',
                ),
                'premsOpcShowAfterLoginRegistrationAvailableText' => array(
                    'label' => 'Show note text before login / registration',
                    'description' => 'If activated customer will see a notice that step 2 and 3 are available after login/ registration',
                ),
                'premsOnePageCheckoutEmailPassPosition' => array(
                    'label' => 'Position of E-mail and password form field (since SW 5.2)',
                    'description' => 'Positon of E-mail and password form field.',
                    'store' => array(
                        array(0, 'Shopware Default'),
                        array(1, 'Top'),
                        array(2, 'Bottom')
                    ),
                ),
                'premsOnePageCheckoutStreetMaxLength' => array(
                    'label' => 'Maximum allowed number of chars for street',
                    'description' => 'Define number of max chars for street field (since Shopware 5.2.x)',
                ),
                'premsOnePageCheckoutShowCountryDisabledDefault' => array(
                    'label' => 'Countries dropdown no preselection',
                    'description' => 'If enabled, OPC registration will not pre-select the first country of the dropdown',
                ),
                'premsNoConfirmFooterBeforeLogin' => array(
                    'label' => 'Do not show total before login',
                    'description' => 'The area for total amount, shipping costs, VAT is only displayed after login / registration',
                ),

                'premsOpcAdditionalCheckbox' => array(
                    'label' => '<strong>Additional checkbox (since SW 5.6)</strong>',
                ),
                'premsOnePageCheckoutShowAdditionalCheckbox' => array(
                    'label' => 'Show additional checkbox',
                    'description' => 'Shows an additional checkbox in checkout',
                ),
                'premsOnePageCheckoutAdditionalCheckboxIsRequired' => array(
                    'label' => 'Required',
                ),
                'premsOnePageCheckoutAdditionalCheckboxIsChecked' => array(
                    'label' => 'Checked',
                ),
                'premsOnePageCheckoutAdditionalCheckboxAfterAgb' => array(
                    'label' => 'Show checkbox after terms checkbox',
                    'description' => 'Default: Before terms checkbox'
                ),
            ),
            'de_DE' => array(
                'useOnePageCheckout' => array(
                    'label' => 'Plugin für diesen Shop nutzen',
                ),
                'useStepsOnlyVertical' => array(
                    'label' => 'Schritte immer vertikal darstellen',
                    'description' => 'Normalerweise werden die Checkout Schritte bei ausreichend Platz nebeneinander dargestellt und brechen erst bei kleineren Auflösungen um. Ist diese Option aktiviert, so werden die Schritte immer untereinander dargestellt.',
                ),
                'premsShowPremiumProductArea' => array(
                    'label' => 'Prämien Produktauswahl nutzen',
                ),
                'premsAgbOnTop' => array(
                    'label' => 'AGBs oben darstellen',
                    'description' => 'Laut https://de.shopware.com/news/die-wichtigsten-antworten-zur-button-loesung-fachanwalt-thomas-feil-im-interview/ ist es sicherer die AGBs direkt sichtbar oben im OPC darzustellen. Bitte beachten: Bei einigen Shop Themes können die AGBs nur oberhalb dargestellt werden.',
                ),
                'premsOnePageCheckoutVoucherOnTop' => array(
                    'label' => 'Gutscheinbox oben darstellen (ab SW 5.2)',
                    'description' => 'Stellt die Gutscheinbox oberhalb des OnePageCheckouts dar. Bitte beachten Sie, das im Shopware Backend unter "Einstellungen->Grundeinstellungen->Storefront->Bestellabschluss->Zeige weitere Optionen an" aktiviert sein muss.',
                ),
                'premsOnePageCheckoutNoCommentArea' => array(
                    'label' => 'Kommentarfeld ausblenden (ab SW 5.2)',
                    'description' => 'Blendet das Kommentarfeld aus. Bitte beachten Sie, das im Shopware Backend unter "Einstellungen->Grundeinstellungen->Storefront->Bestellabschluss->Zeige weitere Optionen an" aktiviert sein muss, da ansonsten das Kommentarfeld nicht verfügbar ist',
                ),
                'premsOnePageCheckoutSaveAgbStatus' => array(
                    'label' => 'AGB Status speichern',
                    'description' => 'Speichert den Status der AGB Checkbox. Wurden die AGB angehackt und wird dann der Checkout neu geladen, sind die AGB weiter angehackt solange die Session des Nutzers besteht.',
                ),
                'premsOnePageCheckoutSaveComment' => array(
                    'label' => 'Kommentar speichern',
                    'description' => 'Speichert den Inhalt des Kommentar Feldes. Wurde das Kommentar Feld ausgefüllt und wird dann der Checkout neu geladen, ist das Kommentar weiterhin ausgefüllt solange die Session des Nutzers besteht.',
                ),
                'premsShowArticleProperties' => array(
                    'label' => 'Artikel Eigenschaften anzeigen',
                    'description' => 'Bei aktiver Option werden im Checkout die Artikeleigenschaften der Artikel (insofern gepflegt) dargestellt.',
                ),
                'premsShowOrderText' => array(
                    'label' => 'Einführungstext auf Bestellseite anzeigen',
                    'description' => 'Bei aktiver Option wird oberhalb des One Page Checkouts der Text -Bestellung: Bitte füllen Sie die nachfolgenden Felder aus, um die Bestellung abzuschließen- angezeigt.',
                ),
                'premsAdditionalShippingDisable' => array(
                    'label' => 'Separate Lieferadresse hinzufügen deaktivieren',
                    'description' => 'Entfernt die Möglichkeit im Checkout eine abweichende Lieferadresse zu wählen',
                ),
                'premsOnePageCheckoutReloadBuyboy' => array(
                    'label' => 'Kaufen Box reloaden (seit SW 5.5)',
                    'description' => 'Lädt die Kaufen Box nach dem Laden der Zahlarten neu. Normalerweise wird diese Option nicht benötigt. Bitte nur aktivieren, wenn von unserem Support empfohlen.',
                ),
                'premsOnePageCheckoutScrollToStep2' => array(
                    'label' => 'Zu Schritt 2 springen',
                    'description' => 'Ist der vertikale Modus aktiv und der Nutzer eingeloggt/ registriert, dann wird automatisch zu Schritt 2 gescrollt.',
                ),
                'premsOpcThirdVendorProps' => array(
                    'label' => '<strong>Einstellungen Drittanbieter Plugins</strong>',
                ),
                'premsOpcPaymentsRedirectToPaymentPage' => array(
                    'label' => 'Zahlarten IDs zur Weiterleitung',
                    'description' => 'Kommaseparierte Liste von Zahlarten IDs bei denen eine Weiterleitung zur Payment Page erfolgen soll. Diese Option hilft beispielsweise Klarna Zahlung auf Rechnung zu unterstützen. Bitte IDs in der Form 1,5,20 hinterlegen',
                ),
                'premsOpcCompabilityMode' => array(
                    'label' => 'Kompabilitätsmodus aktivieren (ab SW 5.2)',
                    'description' => 'Diese Option sollte immer aktiv sein. Ansonsten können, je nach verwendeter Plugins, im Checkout Fehlerseiten auftauchen oder falsche Lieferadressen zugewiesen werden.',
                ),
                'premsOpcCompabilityModeUrl' => array(
                    'label' => 'Alternativer URL Pfad Kompabilitätsmodus',
                    'description' => 'Bei aktiviertem Kompabilitätsmodus, wird der Nutzer im Checkout auf die URL PremsOnePageCheckout weitergeleitet. Hier haben Sie die Möglichkeit eine alternative URL zu definieren wie z.B.: checkout_login.',
                ),
                'premsOpcRegister' => array(
                    'label' => '<strong>Einstellungen Registrierung</strong>',
                ),
                'premsOpcDefaultRegisterAsGuest' => array(
                    'label' => 'Gastregistrierung per Default aktiviert',
                    'description' => 'Wenn aktiviert, wird standardmäßig immer die Gastregistrierung Checkbox angehackt.',
                ),
                'registerBeforeLogin' => array(
                    'label' => 'Registrierung vor Login',
                    'description' => 'Wenn aktiviert, wird die Registrierung vor dem Login gezeigt.',
                ),
                'loginInitiallyOpen' => array(
                    'label' => 'Loginbereich initial geöffnet',
                    'description' => 'Wenn aktiviert, wird der Loginbereich initial offen gezeigt.',
                ),
                'premsRegisterInitiallyOpen' => array(
                    'label' => 'Registrierungsbereich initial geöffnet',
                    'description' => 'Wenn aktiviert, wird der Registrierungsbereich initial offen gezeigt.',
                ),
                'zipBeforeStreet' => array(
                    'label' => 'PLZ vor Straße',
                    'description' => 'Wenn aktiviert, wird die die PLZ vor der Straße gezeigt. Dies kann sinnvoll sein wenn Sie einen Autocomplete nutzen',
                ),
                'premsRegisterOnlyAsCompany' => array(
                    'label' => 'Anmeldung als Firma',
                    'description' => 'Wenn aktiviert, können sich Kunden nur als Firma registrieren. ',
                ),
                'premsOpcShowAfterLoginRegistrationAvailableText' => array(
                    'label' => 'Zeige Hinweistext vor Login/ Registrierung',
                    'description' => 'Wenn aktiviert, wird den Kunden ein Hinweistext gezeigt, das Schritt 2 und 3 nach dem Login/ Registrierung verfügbar sind.',
                ),
                'premsOnePageCheckoutEmailPassPosition' => array(
                    'label' => 'E-Mail und Passwortabfrage Position (ab SW 5.2)',
                    'description' => 'Zeigt das E-Mail, Passwort und Gastkonto Formularfeld bei der Registrierung als erstes, an der Standard Shopware Position, oder als letztes an.',
                    'store' => array(
                        array(0, 'Shopware Default'),
                        array(1, 'Top'),
                        array(2, 'Bottom')
                    ),
                ),
                'premsOnePageCheckoutStreetMaxLength' => array(
                    'label' => 'Maximal erlaubte Zeichenanzahl Straße',
                    'description' => 'Legt fest, wieviele Zeichen maximal beim Feld Straße in der Registrierung des OnePageCheckout eingegeben werden dürfen (ab Shopware 5.2.x)',
                ),
                'premsOnePageCheckoutShowCountryDisabledDefault' => array(
                    'label' => 'Länder Dropdown keine Vorauswahl',
                    'description' => 'Wenn aktiviert, wird für die OPC Registrierung nicht das erste Land des Dropdowns vorausgewählt',
                ),
                'premsNoConfirmFooterBeforeLogin' => array(
                    'label' => 'Summe bevor Login nicht anzeigen',
                    'description' => 'Der Bereich für Gesamtsumme, Versandkosten, MwSt. wird erst nach Login/ Registrierung angezeigt',
                ),

                'premsOpcAdditionalCheckbox' => array(
                    'label' => '<strong>Zusätzliche Checkbox (ab SW 5.6)</strong>',
                ),
                'premsOnePageCheckoutShowAdditionalCheckbox' => array(
                    'label' => 'Zusätzliche Checkbox anzeigen',
                    'description' => 'Zeigt eine zusätzliche Checkbox im Checkout an',
                ),
                'premsOnePageCheckoutAdditionalCheckboxIsRequired' => array(
                    'label' => 'Pflichtfeld',
                ),
                'premsOnePageCheckoutAdditionalCheckboxIsChecked' => array(
                    'label' => 'Vorausgefüllt',
                ),
                'premsOnePageCheckoutAdditionalCheckboxAfterAgb' => array(
                    'label' => 'Checkbox nach AGB Checkbox anzeigen',
                    'description' => 'Standardmäßig wird die Checkbox vor den AGBs gezeigt'
                ),
            )
        );
    }
}