<?php
/**
 * premsoft
 * Copyright © 2019 Premsoft - Sven Mittreiter
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License, supplemented by an additional
 * permission, and of our proprietary license can be found
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, titles and interests in the
 * above trademarks remain entirely with the trademark owners.
 *
 * @copyright  Copyright (c) 2019, premsoft - Sven Mittreiter (http://www.premsoft.de)
 * @author     Sven Mittreiter <info@premsoft.de>
 */
namespace Shopware\PremsOnePageCheckout\Config;

use Shopware_Plugins_Frontend_PremsOnePageCheckout_Bootstrap as Bootstrap;

class Update {
    /**
     * @var Bootstrap $bootstrap
     */
    protected $bootstrap;

    /**
     * @param Bootstrap $bootstrap
     */
    public function __construct(Bootstrap $bootstrap) {
        $this->bootstrap = $bootstrap;
    }

    public function execute($version) {
        if (version_compare($version, '8.6.1', '<')) {
            if ($this->bootstrap->isShopware52()) {
                (new Attribute(
                    Shopware()->Container()->get('shopware_attribute.crud_service'))
                )->install();
            }

            if (!$this->hasFormElement('premsOpcAdditionalCheckbox')) {
                $form = $this->bootstrap->Form();
                $form->setElement(
                    'button',
                    'premsOpcAdditionalCheckbox',
                    array(
                        'label' => '<strong>Zusätzliche Checkbox (ab SW 5.6)</strong>',
                    )
                );
                $form->setElement('checkbox', 'premsOnePageCheckoutShowAdditionalCheckbox', array(
                    'label' => 'Zusätzliche Checkbox anzeigen',
                    'description' => 'Zeigt eine zusätzliche Checkbox im Checkout an',
                    'value' => 0,
                    'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
                ));
                $form->setElement('checkbox', 'premsOnePageCheckoutAdditionalCheckboxIsRequired', array(
                    'label' => 'Pflichtfeld',
                    'value' => 0,
                    'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
                ));
                $form->setElement('checkbox', 'premsOnePageCheckoutAdditionalCheckboxIsChecked', array(
                    'label' => 'Vorausgefüllt',
                    'value' => 0,
                    'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
                ));
                $form->setElement('checkbox', 'premsOnePageCheckoutAdditionalCheckboxAfterAgb', array(
                    'label' => 'Checkbox nach AGB Checkbox anzeigen',
                    'description' => 'Standardmäßig wird die Checkbox vor den AGBs gezeigt',
                    'value' => 0,
                    'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
                ));
            }
        }

        if (version_compare($version, '8.5.0', '<')) {
            if (!$this->hasFormElement('premsOnePageCheckoutScrollToStep2')) {
                $form = $this->bootstrap->Form();
                $form->setElement('checkbox', 'premsOnePageCheckoutScrollToStep2', array(
                    'label' => 'Zu Schritt 2 springen',
                    'description' => 'Ist der vertikale Modus aktiv und der Nutzer eingeloggt/ registriert, dann wird automatisch zu Schritt 2 gescrollt.',
                    'value' => 1,
                    'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
                ));
            }
        }
        if (version_compare($version, '8.3.6', '<')) {
            if (!$this->hasFormElement('premsOnePageCheckoutReloadBuyboy')) {
                $form = $this->bootstrap->Form();
                $form->setElement('checkbox', 'premsOnePageCheckoutReloadBuyboy', array(
                    'label' => 'Kaufen Box reloaden (seit SW 5.5)',
                    'description' => 'Lädt die Kaufen Box nach dem Laden der Zahlarten neu. Normalerweise wird diese Option nicht 
          benötigt. Bitte nur aktivieren, wenn von unserem Support empfohlen.',
                    'value' => 0,
                    'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
                ));
            }
        }

        if (version_compare($version, '8.2.0', '<')) {
            if (!$this->hasFormElement('premsNoConfirmFooterBeforeLogin')) {
                $form = $this->bootstrap->Form();
                $form->setElement('checkbox', 'premsNoConfirmFooterBeforeLogin', array(
                    'label' => 'Summe bevor Login nicht anzeigen',
                    'description' => 'Der Bereich für Gesamtsumme, Versandkosten, MwSt. wird erst nach Login/ Registrierung angezeigt',
                    'value' => 0,
                    'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
                ));
            }
        }
        if (version_compare($version, '7.10.0', '<')) {
            if (!$this->hasFormElement('premsOnePageCheckoutSaveComment')) {
                $form = $this->bootstrap->Form();
                $form->setElement('checkbox', 'premsOnePageCheckoutSaveComment', array(
                    'label' => 'Kommentar speichern',
                    'description' => 'Speichert den Inhalt des Kommentar Feldes. Wurde das Kommentar Feld ausgefüllt und wird dann der Checkout neu geladen, ist das Kommentar weiterhin ausgefüllt solange die Session des Nutzers besteht.',
                    'value' => 0,
                    'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
                ));
            }
        }

        if (version_compare($version, '7.9.0', '<')) {
            $form = $this->bootstrap->Form();
            $form->setElement('text', 'premsOpcCompabilityModeUrl',
                array(
                    'label' => 'Alternativer URL Pfad Kompabilitätsmodus',
                    'value' => 'checkout_login',
                    'description' => 'Bei aktiviertem Kompabilitätsmodus, wird der Nutzer im Checkout auf die URL PremsOnePageCheckout weitergeleitet. Hier haben Sie die Möglichkeit eine alternative URL zu definieren wie z.B.: checkout_login',
                )
            );
        }
        if (version_compare($version, '7.0.0', '<')) {
            if (!$this->hasFormElement('premsOnePageCheckoutVoucherOnTop')) {
                $form = $this->bootstrap->Form();
                $form->setElement('checkbox', 'premsOnePageCheckoutVoucherOnTop', array(
                    'label' => 'Gutscheinbox oben darstellen (ab SW 5.2)',
                    'description' => 'Stellt die Gutscheinbox oberhalb des OnePageCheckouts dar. Bitte beachten Sie, das im Shopware Backend unter "Einstellungen->Grundeinstellungen->Storefront->Bestellabschluss->Zeige weitere Optionen an" aktiviert sein muss.',
                    'value' => 0,
                    'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
                ));
            }
            if (!$this->hasFormElement('premsOnePageCheckoutNoCommentArea')) {
                $form = $this->bootstrap->Form();
                $form->setElement('checkbox', 'premsOnePageCheckoutNoCommentArea', array(
                    'label' => 'Kommentarfeld ausblenden (ab SW 5.2)',
                    'description' => 'Blendet das Kommentarfeld aus. Bitte beachten Sie, das im Shopware Backend unter "Einstellungen->Grundeinstellungen->Storefront->Bestellabschluss->Zeige weitere Optionen an" aktiviert sein muss, da ansonsten das Kommentarfeld nicht verfügbar ist',
                    'value' => 0,
                    'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
                ));
            }
        }

        if (version_compare($version, '6.15.0', '<')) {
            if (!$this->hasFormElement('premsOnePageCheckoutShowCountryDisabledDefault')) {
                $form = $this->bootstrap->Form();
                $form->setElement('checkbox', 'premsOnePageCheckoutShowCountryDisabledDefault', array(
                    'label' => 'Länder Dropdown keine Vorauswahl',
                    'description' => 'Wenn aktiviert, wird für die OPC Registrierung nicht das erste Land des Dropdowns vorausgewählt',
                    'value' => 0,
                    'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
                ));
            }
        }

        if (version_compare($version, '6.14.0', '<')) {
            if (!$this->hasFormElement('premsOnePageCheckoutStreetMaxLength')) {
                $form = $this->bootstrap->Form();
                $form->setElement('number', 'premsOnePageCheckoutStreetMaxLength', array(
                    'label' => 'Maximal erlaubte Zeichenanzahl Straße',
                    'description' => 'Legt fest, wieviele Zeichen maximal beim Feld Straße in der Registrierung des OnePageCheckout eingegeben werden dürfen (ab Shopware 5.2.x)',
                    'min' => 30,
                    'max' => 255,
                    'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
                ));
            }
        }

        if (version_compare($version, '6.13.0', '<')) {
            if (!$this->hasFormElement('premsOnePageCheckoutSaveAgbStatus')) {
                $form = $this->bootstrap->Form();
                $form->setElement('checkbox', 'premsOnePageCheckoutSaveAgbStatus', array(
                    'label' => 'AGB Status speichern',
                    'description' => 'Speichert den Status der AGB Checkbox. Wurden die AGB angehackt und wird dann der Checkout neu geladen, sind die AGB weiter angehackt solange die Session des Nutzers besteht.',
                    'value' => 0,
                    'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
                ));
            }
        }

        if (version_compare($version, '5.9.0', '<')) {
            $form = $this->bootstrap->Form();
            if (!$this->hasFormElement('premsOpcShowAfterLoginRegistrationAvailableText')) {
                $form->setElement('checkbox', 'premsOpcShowAfterLoginRegistrationAvailableText', array(
                    'label' => 'Zeige Hinweistext vor Login/ Registrierung',
                    'description' => 'Wenn aktiviert, wird den Kunden ein Hinweistext gezeigt, das Schritt 2 und 3 nach dem Login/ Registrierung verfügbar sind.',
                    'value' => false,
                    'scope' => \Shopware\Models\Config\Element::SCOPE_SHOP
                ));
            }
        }
    }

    /**
     * Prüft ob ein Formularelement bereits in s_core_config_elements existiert
     * @param $element
     * @return string
     */
    protected function hasFormElement($element) {
        return Shopware()->Db()->fetchOne('
      SELECT
        id
      FROM
        s_core_config_elements
      WHERE
        name LIKE ?
    ', array($element));
    }
}