<?php
/**
 * premsoft
 * Copyright © 2016 Premsoft - Sven Mittreiter
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License, supplemented by an additional
 * permission, and of our proprietary license can be found
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, titles and interests in the
 * above trademarks remain entirely with the trademark owners.
 *
 * @copyright  Copyright (c) 2016, premsoft - Sven Mittreiter (http://www.premsoft.de)
 * @author     Sven Mittreiter <info@premsoft.de>
 */

class Shopware_Controllers_Frontend_PremsOnePageCheckout extends Shopware_Controllers_Frontend_Checkout {
  /**
   * Init controller method
   */
 /** public function init()
  {
    parent::init();
  }

  public function preDispatch()
  {
    $this->View()->setScope(Enlight_Template_Manager::SCOPE_PARENT);
    $this->View()->sUserLoggedIn = $this->admin->sCheckUser();
    $this->View()->sUserData = $this->getUserData();
  }*/

  public function afterInit() {
    $this->Application()->Loader()->registerNamespace('Shopware\PremsOnePageCheckout', __DIR__ . DIRECTORY_SEPARATOR);
  }

  /**
   * Action to simultaneously save shipping and payment details
   */
  public function saveShippingPaymentAction()
  {
    if (!$this->Request()->isPost()) {
      return $this->forward('shippingPayment');
    }

    return parent::saveShippingPaymentAction();

    /**
    // Load data from request
    $dispatch = $this->Request()->getPost('sDispatch');
    $payment = $this->Request()->getPost('payment');

    // If request is ajax, we skip the validation, because the user is still editing
    if ($this->Request()->getParam('isXHR')) {
      // Save payment and shipping method data.
      $this->admin->sUpdatePayment($payment);
      $this->setDispatch($dispatch, $payment);

      return $this->forward('index');
    }*/
  }

  /**
  protected function loadAndAssignShippingPaymentData() {
    // Load payment options, select option and details
    $this->View()->sPayments = $this->getPayments();
    $this->View()->sFormData = array('payment' => $this->View()->sUserData['additional']['user']['paymentID']);
    $getPaymentDetails = $this->admin->sGetPaymentMeanById($this->View()->sFormData['payment']);

    $paymentClass = $this->admin->sInitiatePaymentClass($getPaymentDetails);
    if ($paymentClass instanceof \ShopwarePlugin\PaymentMethods\Components\BasePaymentMethod) {
      $data = $paymentClass->getCurrentPaymentDataAsArray(Shopware()->Session()->sUserId);
      if (!empty($data)) {
        $this->View()->sFormData += $data;
      }
    }
    if ($this->Request()->isPost()) {
      $values = $this->Request()->getPost();
      $values['payment'] = $this->Request()->getPost('payment');
      $values['isPost'] = true;
      $this->View()->sFormData = $values;
    }

    // Load current and all shipping methods
    $this->View()->sDispatch = $this->getSelectedDispatch();
    $this->View()->sDispatches = $this->getDispatches($this->View()->sFormData['payment']);

    $this->View()->sBasket = $this->getBasket();

    $this->View()->sLaststock = $this->basket->sCheckBasketQuantities();
    $this->View()->sShippingcosts = $this->View()->sBasket['sShippingcosts'];
    $this->View()->sShippingcostsDifference = $this->View()->sBasket['sShippingcostsDifference'];
    $this->View()->sAmount = $this->View()->sBasket['sAmount'];
    $this->View()->sAmountWithTax = $this->View()->sBasket['sAmountWithTax'];
    $this->View()->sAmountTax = $this->View()->sBasket['sAmountTax'];
    $this->View()->sAmountNet = $this->View()->sBasket['AmountNetNumeric'];
    $this->View()->sRegisterFinished = !empty($this->session['sRegisterFinished']);
    $this->View()->sTargetAction = 'shippingPayment';


    // Payment aus Account.php -> paymentAction()
    $this->View()->sPaymentMeans = $this->admin->sGetPaymentMeans();
    $this->View()->sFormData = array('payment'=>$this->View()->sUserData['additional']['user']['paymentID']);
    $this->View()->sTarget = $this->Request()->getParam('sTarget', $this->Request()->getControllerName());
    $this->View()->sTargetAction = $this->Request()->getParam('sTargetAction', 'index');

    $getPaymentDetails = $this->admin->sGetPaymentMeanById($this->View()->sFormData['payment']);

    $paymentClass = $this->admin->sInitiatePaymentClass($getPaymentDetails);
    if ($paymentClass instanceof \ShopwarePlugin\PaymentMethods\Components\BasePaymentMethod) {
      $data = $paymentClass->getCurrentPaymentDataAsArray(Shopware()->Session()->sUserId);
      if (!empty($data)) {
        $this->View()->sFormData += $data;
      }
    }
  }*/

  public function saveBillingChangesAction()
  {
    if (!$this->admin->sCheckUser()) {
      return $this->redirect(array(
        'action' => 'confirm',
        'controller' => 'checkout',
      ));
    }

    if ($this->Request()->isPost()) {
      $countryData = $this->admin->sGetCountryList();
      $countryIds = array();

      foreach ($countryData as $key => $country) {
        $countryIds[$key] = $country['id'];
      }

      $requirePhone = (bool) (Shopware()->Config()->get('showPhoneNumberField')
        && Shopware()->Config()->get('requirePhoneField'));

      $rules = array(
        'salutation'    => array('required' => 1),
        'company'       => array('required' => 0),
        'firstname'     => array('required' => 1),
        'lastname'      => array('required' => 1),
        'street'        => array('required' => 1),
        'zipcode'       => array('required' => 1),
        'city'          => array('required' => 1),
        'phone'         => array('required' => $requirePhone),
        'fax'           => array('required' => 0),
        'country'       => array(
          'required' => 1,
          'in' => $countryIds
        ),
        'department'    => array('required' => 0),
        'shippingAddress'=>array('required' => 0),
        'text1'         => array('required' => 0),
        'text2'         => array('required' => 0),
        'text3'         => array('required' => 0),
        'text4'         => array('required' => 0),
        'text5'         => array('required' => 0),
        'text6'         => array('required' => 0),
        'birthyear'     => array('required' => 0, 'date' => ['d' => 'birthday', 'm' => 'birthmonth', 'y' => 'birthyear']),
        'birthmonth'    => array('required' => 0, 'date' => ['d' => 'birthday', 'm' => 'birthmonth', 'y' => 'birthyear']),
        'birthday'      => array('required' => 0, 'date' => ['d' => 'birthday', 'm' => 'birthmonth', 'y' => 'birthyear']),
        'additional_address_line1' => array(
          'required' => (Shopware()->Config()->requireAdditionAddressLine1 && Shopware()->Config()->showAdditionAddressLine1) ? 1 : 0
        ),
        'additional_address_line2' => array(
          'required' => (Shopware()->Config()->requireAdditionAddressLine2 && Shopware()->Config()->showAdditionAddressLine2) ? 1 : 0
        )
      );

      $values = $this->Request()->getPost('register');

      // Erste Buchstaben immer groß schreiben
      $fields = array(
        'company',
        'department',
        'street',
        'city',
        'additional_address_line1',
        'additional_address_line2'
      );
      //$data = array();
      foreach ($fields as $key => $field) {
        if (isset($values["billing"][$field])) {
          $values["billing"][$field] = ucfirst($values["billing"][$field]);
        }
      }
      $fields = array(
        'firstname',
        'lastname',
      );
      //$data = array();
      foreach ($fields as $key => $field) {
        if (isset($values["personal"][$field])) {
          $values["personal"][$field] = ucfirst($values["personal"][$field]);
        }
      }


      // State selection
      if (!empty($values["billing"]["country"])) {
        $stateSelectionRequired = Shopware()->Db()->fetchRow(
          "SELECT display_state_in_registration, force_state_in_registration
          FROM s_core_countries WHERE id = ?",
          array($values["billing"]["country"]))
        ;

        if ($stateSelectionRequired["display_state_in_registration"]) {
          $countryDataIndex = array_search($values["billing"]["country"], $countryIds);
          $statesIds = array_column($countryData[$countryDataIndex]['states'], 'id');

          // if not required, allow empty values
          if (!$stateSelectionRequired["force_state_in_registration"]) {
            $statesIds[] = "";
          }

          $rules["stateID"] = array(
            "required" => $stateSelectionRequired["force_state_in_registration"],
            'in' => $statesIds
          );
        }

        if (
          $stateSelectionRequired["display_state_in_registration"] != true
          && $stateSelectionRequired["force_state_in_registration"] != true
        ) {
          $this->admin->sSYSTEM->_POST["register"]["billing"]["stateID"] = $values["billing"]["stateID"] = 0;
        } else {
          $this->admin->sSYSTEM->_POST["register"]["billing"]["stateID"] = $values["billing"]["stateID"] = $values["billing"]["country_state_".$values["billing"]["country"]];
        }

        unset($values["billing"]["country_state_".$values["billing"]["country"]]);
      }

      if ($this->Request()->getParam('billingSelect')) {
        $address = $this->admin->sGetPreviousAddresses('billing', $this->Request()->getParam('billingSelect'));
        if (!empty($address['hash'])) {
          $address = array_merge($this->View()->sUserData['billingaddress'], $address);
          $this->admin->sSYSTEM->_POST = $address;
        }
      }

      if (!empty($values['personal']['customer_type'])) {
        if ($values['personal']['customer_type'] === 'private') {
          $values['billing']['company'] = '';
          $values['billing']['department'] = '';
          $values['billing']['ustid'] = '';
        } else {
          $rules['company'] = array('required' => 1);
          $rules['ustid'] = array('required' => 0);
        }
      }

      if (!empty($values)) {
        $this->admin->sSYSTEM->_POST = array_merge($values['personal'], $values['billing'], $this->admin->sSYSTEM->_POST->toArray());
      }


      $checkData = $this->admin->sValidateStep2($rules, true);

      if (!empty($checkData['sErrorMessages'])) {
        Shopware()->Session()->sErrorFlag = $checkData['sErrorFlag'];
        Shopware()->Session()->sErrorMessages = $checkData['sErrorMessages'];
        /**print_R($checkData['sErrorFlag']);
        print_R($checkData['sErrorMessages']);
        die("update");*/
        return $this->redirect(array(
          'action' => 'confirm',
          'controller' => 'checkout',
        ));
      } else {
        $this->admin->sUpdateBilling();
        return $this->redirect(array(
          'action' => 'confirm',
          'controller' => 'checkout',
        ));
      }
    }
    return $this->redirect(array(
      'action' => 'confirm',
      'controller' => 'checkout',
    ));

  }

  /**
   * Save shipping action
   *
   * Save shipping address data
   */
  public function saveShippingChangesAction($onlyValidate = false)
  {
    if (!$this->admin->sCheckUser()) {
      $this->forward('index');
    }

    if ($this->Request()->isPost()) {
      $countryData = $this->admin->sGetCountryList();
      $countryIds = array();

      foreach ($countryData as $key => $country) {
        $countryIds[$key] = $country['id'];
      }

      $rules = array(
        'salutation'        => array('required' => 1),
        'company'           => array('required' => 0),
        'firstname'         => array('required' => 1),
        'lastname'          => array('required' => 1),
        'street'            => array('required' => 1),
        'zipcode'           => array('required' => 1),
        'city'              => array('required' => 1),
        'department'        => array('required' => 0),
        'text1'             => array('required' => 0),
        'text2'             => array('required' => 0),
        'text3'             => array('required' => 0),
        'text4'             => array('required' => 0),
        'text5'             => array('required' => 0),
        'text6'             => array('required' => 0),
        'additional_address_line1' => array('required' => (Shopware()->Config()->requireAdditionAddressLine1 && Shopware()->Config()->showAdditionAddressLine1) ? 1 : 0),
        'additional_address_line2' => array('required' => (Shopware()->Config()->requireAdditionAddressLine2 && Shopware()->Config()->showAdditionAddressLine2) ? 1 : 0)
      );

      if (Shopware()->Config()->get('sCOUNTRYSHIPPING')) {
        $rules['country'] = array('required'=>1);
      } else {
        $rules['country'] = array('required'=>0);
      }

      if ($this->Request()->getParam('shippingSelect')) {
        $address = $this->admin->sGetPreviousAddresses('shipping', $this->Request()->getParam('shippingSelect'));
        if (!empty($address['hash'])) {
          $address = array_merge($this->View()->sUserData['shippingaddress'], $address);
          $this->admin->sSYSTEM->_POST = $address;
        }
      } else {
        $this->admin->sSYSTEM->_POST =  $this->Request()->getPost();
      }

      $values = $this->Request()->getPost('register');


      // Erste Buchstaben immer groß schreiben
      $fields = array(
        'company',
        'department',
        'firstname',
        'lastname',
        'street',
        'city',
        'additional_address_line1',
        'additional_address_line2'
      );
      foreach ($fields as $key => $field) {
        if (isset($values["shipping"][$field])) {
          $values["shipping"][$field] = ucfirst($values["shipping"][$field]);
        }
      }

      if (Shopware()->Config()->get('sCOUNTRYSHIPPING')) {
        $rules['country'] = array(
          'required' => 1,
          'in' => $countryIds
        );

        // State selection
        if (!empty($values["shipping"]["country"])) {
          $stateSelectionRequired = Shopware()->Db()->fetchRow("
                    SELECT display_state_in_registration, force_state_in_registration
                    FROM s_core_countries WHERE id = ?",
            array($values["shipping"]["country"])
          );

          if ($stateSelectionRequired["display_state_in_registration"]) {
            $countryDataIndex = array_search($values["shipping"]["country"], $countryIds);
            $statesIds = array_column($countryData[$countryDataIndex]['states'], 'id');

            // if not required, allow empty values
            if (!$stateSelectionRequired["force_state_in_registration"]) {
              $statesIds[] = "";
            }

            $rules["stateID"] = array(
              "required" => $stateSelectionRequired["force_state_in_registration"],
              'in' => $statesIds
            );
          }

          if (
            $stateSelectionRequired["display_state_in_registration"] == false
            && $stateSelectionRequired["force_state_in_registration"] == false
          ) {
            $this->admin->sSYSTEM->_POST["register"]["shipping"]["stateID"] = $values["shipping"]["stateID"] = 0;
          } else {
            $this->admin->sSYSTEM->_POST["register"]["shipping"]["stateID"] = $values["shipping"]["stateID"] = $values["shipping"]["country_shipping_state_".$values["shipping"]["country"]];
          }

          unset($values["shipping"]["country_shipping_state_".$values["shipping"]["country"]]);
        }
      }

      if (!empty($values)) {
        unset($this->admin->sSYSTEM->_POST['salutation']);
        unset($this->admin->sSYSTEM->_POST['firstname']);
        unset($this->admin->sSYSTEM->_POST['lastname']);
        unset($this->admin->sSYSTEM->_POST['company']);
        unset($this->admin->sSYSTEM->_POST['department']);
        unset($this->admin->sSYSTEM->_POST['street']);
        unset($this->admin->sSYSTEM->_POST['zipcode']);
        unset($this->admin->sSYSTEM->_POST['city']);
        unset($this->admin->sSYSTEM->_POST['country']);
        unset($this->admin->sSYSTEM->_POST['stateID']);

        $this->admin->sSYSTEM->_POST = array_merge($values['shipping'], $this->admin->sSYSTEM->_POST->toArray());
      }

      $checkData = $this->admin->sValidateStep2ShippingAddress($rules, true);
      if (!empty($checkData['sErrorMessages'])) {
        Shopware()->Session()->sErrorFlag = $checkData['sErrorFlag'];
        Shopware()->Session()->sErrorMessages = $checkData['sErrorMessages'];
        return $this->redirect(array(
          'action' => 'confirm',
          'controller' => 'checkout',
        ));
      } else {
        if (!$onlyValidate) {
          $this->admin->sUpdateShipping();
          return $this->redirect(array(
            'action' => 'confirm',
            'controller' => 'checkout',
          ));
        }
      }
    }
    return $this->redirect(array(
      'action' => 'confirm',
      'controller' => 'checkout',
    ));
  }

  public function loginAction() {
    if ($this->Request()->isPost()) {
      $checkUser = $this->admin->sLogin();
      if (!empty($checkUser['sErrorMessages'])) {
        $this->View()->sFormDataLogin = $this->Request()->getPost();
        $this->View()->sErrorFlag = $checkUser['sErrorFlag'];
        Shopware()->Session()->loginDataError = $checkUser['sErrorMessages'];
        $this->View()->loginDataError = $checkUser['sErrorMessages'];
      } else {
        Shopware()->Modules()->Basket()->sRefreshBasket();
      }
    }

    return $this->redirect(array(
      'action' => 'confirm',
      'controller' => 'checkout',
    ));
  }
}