<?php

namespace Shopware\PremsOnePageCheckout\Subscriber;

use Shopware_Plugins_Frontend_PremsOnePageCheckout_Bootstrap as Bootstrap;

class Admin implements \Enlight\Event\SubscriberInterface {
  /**
   * @var Bootstrap $bootstrap
   */
  protected $bootstrap;

  /**
   * @param Bootstrap $bootstrap
   */
  public function __construct(Bootstrap $bootstrap) {
    $this->bootstrap = $bootstrap;
  }

  public static function getSubscribedEvents() {
    return array(
      'sAdmin::sSaveRegisterBilling::before' => 'onSaveRegisterBillingBefore',
      'sAdmin::sSaveRegisterShipping::before' => 'onSaveRegisterShippingBefore',
      //'Shopware_Modules_Admin_GetPaymentMeans_DataFilter' => 'onGetPaymentMeansDataFilter'
    );
  }

  public function onGetPaymentMeansDataFilter(\Enlight_Event_EventArgs $arguments) {
    if (!Shopware()->Config()->get('useOnePageCheckout')) {
      return;
    }
    $getPaymentMeans = $arguments->getReturn();

    foreach($getPaymentMeans as $key => $payment) {
      if ($payment['name'] == 'amazon_payments_advanced') {
        unset($getPaymentMeans[$key]);
      }
    }

    return $getPaymentMeans;
  }

  /**
   * Setzt Anfangsbuchstaben für Billing Felder groß
   * @param Enlight_Event_EventArgs $arguments
   */
  public function onSaveRegisterBillingBefore(\Enlight_Event_EventArgs $arguments) {
    if (!Shopware()->Config()->get('useOnePageCheckout')) {
      return;
    }

    $postData = $arguments->get('userObject');

    $fields = array(
      'company',
      'department',
      'firstname',
      'lastname',
      'street',
      'city',
      'additional_address_line1',
      'additional_address_line2'
    );

    //$data = array();
    foreach ($fields as $field) {
      if (isset($postData['billing'][$field])) {
        $postData['billing'][$field] = ucfirst($postData['billing'][$field]);
      }
    }

    $arguments->set('userObject', $postData);
  }

  /**
   * Setzt Anfangsbuchstaben für Shipping Felder groß
   * @param Enlight_Event_EventArgs $arguments
   */
  public function onSaveRegisterShippingBefore(\Enlight_Event_EventArgs $arguments) {
    if (!Shopware()->Config()->get('useOnePageCheckout')) {
      return;
    }

    $postData = $arguments->get('userObject');

    $fields = array(
      'company',
      'department',
      'firstname',
      'lastname',
      'street',
      'city',
      'additional_address_line1',
      'additional_address_line2'
    );

    //$data = array();
    foreach ($fields as $field) {
      if (isset($postData['shipping'][$field])) {
        $postData['shipping'][$field] = ucfirst($postData['shipping'][$field]);
      }
    }

    $arguments->set('userObject', $postData);
  }
}