<?php

namespace Shopware\PremsOnePageCheckout\Subscriber;

use Shopware_Plugins_Frontend_PremsOnePageCheckout_Bootstrap as Bootstrap;

class Checkout implements \Enlight\Event\SubscriberInterface {
    /**
     * @var Bootstrap $bootstrap
     */
    protected $bootstrap;

    /**
     * @param \Shopware\Components\DependencyInjection\Container $container
     * @param \Shopware_Plugins_Frontend_PremsOnePageCheckout_Bootstrap $bootstrap
     */
    public function __construct(\Shopware\Components\DependencyInjection\Container $container, Bootstrap $bootstrap) {
        $this->container = $container;
        $this->bootstrap = $bootstrap;
    }

    public static function getSubscribedEvents() {
        return array(
            'Enlight_Controller_Action_PreDispatch_Frontend_Checkout' => 'onPreDispatchCheckout',
            'Enlight_Controller_Action_PostDispatchSecure_Frontend_Checkout' => 'onPostDispatchCheckout',
            'sAdmin::sCheckUser::after' => 'afterCheckUser',
            'Shopware_Controllers_Frontend_Checkout::saveTemporaryOrder::replace' => 'replaceSaveTemporaryOrder',
            'Enlight_Controller_Action_PostDispatchSecure_Frontend_PaymentPaypal' => 'onPostDispatchPaymentPaypalCancelAction',
            'Enlight_Controller_Front_RouteShutdown' => 'onControllerRouteShutdown',
            'Shopware_Modules_Order_SaveOrder_FilterParams' => 'onSaveOrderFilterParams',
        );
    }

    public function onControllerRouteShutdown(\Enlight_Controller_EventArgs $args)
    {
        $controller = $args->getSubject();
        $request = $controller->Request();
        $controllerName = strtolower($request->getControllerName());

        if (!Shopware()->Config()->get('useOnePageCheckout')) {
            return;
        }
        if ($request->getModuleName() == 'backend') {
            return;
        }
        if (!Shopware()->Config()->get('premsOpcCompabilityModeUrl')) {
            return;
        }

        if (strtolower(Shopware()->Config()->get('premsOpcCompabilityModeUrl')) == $controllerName) {
            $request->setControllerName('PremsOnePageCheckout');
        }
    }

    public function onPostDispatchPaymentPaypalCancelAction(\Enlight_Event_EventArgs $args) {
        if (!Shopware()->Config()->get('useOnePageCheckout')) {
            return;
        }
        $controller = $args->getSubject();
        $request = $controller->Request();
        $action = $request->getActionName();

        if ($action != 'cancel') {
            return;
        }

        if (Shopware()->Config()->get('premsPayPalRedirect')) {
            $args->getSubject()->forward('confirm', 'checkout');
        }
    }

    /**
     * @param \Enlight_Hook_HookArgs $args
     */
    public function afterCheckUser(\Enlight_Hook_HookArgs $args) {
        if (!Shopware()->Config()->get('useOnePageCheckout')) {
            return;
        }
        if (!isset($this->request)) {
            return;
        }
        if ($this->request->getActionName() === 'confirm') {
            $args->setReturn(true);
        }
    }

    /**
     * @param \Enlight_Hook_HookArgs $args
     */
    public function replaceSaveTemporaryOrder(\Enlight_Hook_HookArgs $args) {
        if (!Shopware()->Config()->get('useOnePageCheckout')) {
            return;
        }
        $controller = $args->getSubject();
        $this->request = $controller->Request();
        $this->view = $controller->View();

        if (Shopware()->Session()->sUserId) {
            $args->getSubject()->executeParent('saveTemporaryOrder');
        }
    }

    /**
     * @param \Enlight_Event_EventArgs $args
     */
    public function onPreDispatchCheckout(\Enlight_Event_EventArgs $args) {
        if (!Shopware()->Config()->get('useOnePageCheckout')) {
            return;
        }
        $controller = $args->getSubject();
        $this->request = $controller->Request();
        $action = $this->request->getActionName();
        $this->view = $controller->View();
        $session = Shopware()->Session();

        // Wert muß gesetzt werden für PayPalPlus Plugin um Auswahl auf Payment Seite zu emulieren
        $session->offsetSet('PayPalPlusCameFromStep2', 'step2');

        if ($action == 'confirm') {
            // Wert muß entfernt werden da PayPalUnified Auswahl sonst nicht auf der /confirm Seite möglich ist.
            $session->offsetUnset('paypalUnifiedCameFromPaymentSelection');
        }

        if (!Shopware()->Config()->get('premsOpcCompabilityMode') && !$session->offsetGet('checkoutBillingAddressId') && !$session->offsetGet('checkoutShippingAddressId')) {
            $session->offsetSet('checkoutBillingAddressId', 1);
            $session->offsetSet('checkoutShippingAddressId', 1);
        }
        $session->offsetSet('premsOnePageCheckoutActive', 1);

        $redirectController = 'PremsOnePageCheckout';
        if (Shopware()->Config()->get('premsOpcCompabilityModeUrl')) {
            $redirectController = Shopware()->Config()->get('premsOpcCompabilityModeUrl');
        }

        // Zusätzliche Checkbox OPC Form Wert in Session speichern
        if ($this->request->getParam('sOpcAdditionalCheckbox')) {
            $session->offsetSet('sOpcAdditionalCheckbox', true);
        } else {
            $session->offsetUnset('sOpcAdditionalCheckbox');
        }

        // Nicht eingeloggt und Kompabilitätsmodus aktiviert? Dann Weiterleitung zu OPC Controller Seite
        if ($this->bootstrap->isShopware52() && Shopware()->Config()->get('premsOpcCompabilityMode') && ($action == 'confirm' || $action == 'shippingPayment') && !Shopware()->Session()->sUserId) {
            $url = Shopware()->Front()->Router()->assemble(array(
                'action' => 'confirm',
                'controller' => $redirectController,
            ));

            // Voucher Fehler in Session ablegen, da sonst durch header-Redirect die Meludng verloren geht falls man im
            // Kompabilitätsmodus arbeitet, nicht eingeloggt ist und beim Gutschein Formular ein Target auf "confirm" setzt.
            if ($this->view->sVoucherError) {
                $_SESSION['sVoucherError'] = $this->view->sVoucherError;
            }

            // Mit header() gelöst da Forward/Redirect immer noch den postDispatch des alten Controllers Checkout:confirm aufruft
            //header('Location: '.$url);
            //return true;
            return $controller->forward(
                'confirm',
                'PremsOnePageCheckout',
                null
            );
        }

        if ($action == 'shippingPayment' && !Shopware()->Session()->sUserId) {
            return $controller->forward(
                'confirm',
                'checkout',
                null
            );
        }

        if ($action != 'confirm' && $action != 'shippingPayment') {
            return;
        }

        $getCountryList =  Shopware()->Modules()->Admin()->sGetCountryList();
        $this->view->country_list = $getCountryList;
        $this->view->register = new \ArrayObject(array(), \ArrayObject::ARRAY_AS_PROPS);
        $this->view->register->billing = new \ArrayObject(array(), \ArrayObject::ARRAY_AS_PROPS);
        $this->view->register->billing->country_list = $getCountryList;
        $this->view->register->shipping = new \ArrayObject(array(), \ArrayObject::ARRAY_AS_PROPS);
        $this->view->register->shipping->country_list = $getCountryList;

        if ($this->request->get('sPayment')) {
            $this->request->setParam('payment', $this->request->get('sPayment'));
        }
    }

    /**
     * @param \Enlight_View_Default $view
     */
    private function payPalHandleIntegratingThirdPartyMethods(\Enlight_View_Default $view)
    {
        $paymentMethods = $view->getAssign('sPayments');
        $paymentMethodsForPaymentWall = array();
        foreach ($paymentMethods as $key => $paymentMethod) {
            if ($paymentMethod['name'] === \SwagPaymentPayPalUnified\Components\PaymentMethodProvider::PAYPAL_UNIFIED_PAYMENT_METHOD_NAME) {
                continue;
            }

            if (!array_key_exists('swag_paypal_unified_display_in_plus_iframe', $paymentMethod)) {
                continue;
            }

            if ($paymentMethod['swag_paypal_unified_display_in_plus_iframe']) {
                $paymentMethodsForPaymentWall[] = array(
                    'redirectUrl' => 'http://' . $paymentMethod['id'],
                    // 25 is the max length for payment name
                    // cut here, because the name is needed for a check in jQuery plugin
                    'methodName' => substr($paymentMethod['description'], 0, 25),
                    'description' => $paymentMethod['additionaldescription'],
                    'imageUrl' => $paymentMethod['swag_paypal_unified_plus_iframe_payment_logo'],
                );
            }
        }

        $view->assign('paypalUnifiedPlusPaymentMethodsPaymentWall', json_encode($paymentMethodsForPaymentWall));
    }

    protected function loadAndAssignShippingPaymentData($args) {
        $controller = $args->getSubject();
        $request = $controller->Request();
        $action = $request->getActionName();
        $view = $controller->View();
        $admin = Shopware()->Modules()->Admin();
        $session = Shopware()->Session();

        // Load payment options, select option and details
        $view->sFormData = array('payment' => $view->sUserData['additional']['user']['paymentID']);
        $getPaymentDetails = $admin->sGetPaymentMeanById($view->sFormData['payment']);

        $paymentClass = $admin->sInitiatePaymentClass($getPaymentDetails);
        if ($paymentClass instanceof \ShopwarePlugin\PaymentMethods\Components\BasePaymentMethod) {
            $data = $paymentClass->getCurrentPaymentDataAsArray(Shopware()->Session()->sUserId);
            if (!empty($data)) {
                $view->sFormData += $data;
            }
        }
        if ($request->isPost()) {
            $values = $request->getPost();
            $values['payment'] = $request->getPost('payment');
            $values['isPost'] = true;
            $view->sFormData += $values;
        }

        if ($this->assertPluginsPresent(array('SwagPaymentPayPalUnified'))) {
            try {
                /** @var \SwagPaymentPayPalUnified\Models\Settings\Plus $payPalUnifiedSettings */
                $payPalUnifiedSettings = Shopware()->Models()->getRepository('SwagPaymentPayPalUnified\Models\Settings\Plus')->findOneBy(array('shopId' => Shopware()->Shop()->getId()));
                if ($payPalUnifiedSettings) {
                    $restylePaymentSelection = (bool)$payPalUnifiedSettings->getRestyle();
                    $integrateThirdPartyMethods = (bool)$payPalUnifiedSettings->getIntegrateThirdPartyMethods();
                }
            } catch (\Exception $e) {
                echo $e->getMessage();
            }
            $view->assign('paypalUnifiedRestylePaymentSelection', $restylePaymentSelection);

            if (!$integrateThirdPartyMethods) {
                return;
            }
            $this->payPalHandleIntegratingThirdPartyMethods($view);
        }

        // Load current and all shipping methods
        $view->sDispatches = $controller->getDispatches($view->sFormData['payment']);

        $view->sShippingcosts = $view->sBasket['sShippingcosts'];
        $view->sShippingcostsDifference = $view->sBasket['sShippingcostsDifference'];
        $view->sAmount = $view->sBasket['sAmount'];
        $view->sAmountWithTax = $view->sBasket['sAmountWithTax'];
        $view->sAmountTax = $view->sBasket['sAmountTax'];
        $view->sAmountNet = $view->sBasket['AmountNetNumeric'];
        $view->sRegisterFinished = !empty($session['sRegisterFinished']);
        $view->sTargetAction = 'shippingPayment';


        // Payment aus Account.php -> paymentAction()
        $view->sPaymentMeans = $admin->sGetPaymentMeans();
        $view->sFormData = array('payment'=>$view->sUserData['additional']['user']['paymentID']);
        $view->sTarget = $request->getParam('sTarget', $request->getControllerName());
        $view->sTargetAction = $request->getParam('sTargetAction', 'index');

        $getPaymentDetails = $admin->sGetPaymentMeanById($view->sFormData['payment']);

        $paymentClass = $admin->sInitiatePaymentClass($getPaymentDetails);
        if ($paymentClass instanceof \ShopwarePlugin\PaymentMethods\Components\BasePaymentMethod) {
            $data = $paymentClass->getCurrentPaymentDataAsArray(Shopware()->Session()->sUserId);
            if (!empty($data)) {
                $view->sFormData += $data;
            }
        }
    }

    protected function assertPluginsPresent(array $plugins) {
        foreach ($plugins as $plugin) {
            $sql = 'SELECT 1 FROM s_core_plugins WHERE name = ? AND active = 1';
            $test = Shopware()->Container()->get('dbal_connection')->fetchColumn($sql, [$plugin]);
            if (!$test) {
                return false;
            }
        }

        return true;
    }

    /**
     * @param \Enlight_Event_EventArgs $args
     */
    public function onPostDispatchCheckout(\Enlight_Event_EventArgs $args) {
        if (!Shopware()->Config()->get('useOnePageCheckout')) {
            return;
        }

        $this->bootstrap->Application()->Snippets()->addConfigDir($this->bootstrap->Path() . 'Snippets/');

        /** @var \Enlight_Controller_Action $controller */
        $controller = $args->getSubject();
        $request = $controller->Request();
        $action = $request->getActionName();
        $view = $controller->View();
        $admin = Shopware()->Modules()->Admin();

        /**if ($this->bootstrap->isShopware52()) {
        $this->bootstrap->Application()->Template()->addTemplateDir(
        $this->bootstrap->Path() . 'Views/shopware52/'
        );
        } else {
        $this->bootstrap->Application()->Template()->addTemplateDir(
        $this->bootstrap->Path() . 'Views/shopware5/'
        );
        }*/

        // Wenn mindestens SW Version 5.5.9 dann Variable setzen
        if ($this->bootstrap->isShopware559()) {
            $view->assign('isMinSw559', 1);
        }
        // Wenn mindestens SW Version 5.4.3 dann Variable setzen, die die erweiterten Datenschutzfunktionalitäten aktiviert.
        if ($this->bootstrap->isShopware543()) {
            $view->assign('isGreaterSw542', 1);
        }
        // Wenn mindestens SW Version 5.5.8 dann Variable setzen, die für die neue Gastkonto-Checkbox benötigt wird
        if ($this->bootstrap->isShopware558()) {
            $view->assign('isGreaterSw558', 1);
        }

        // Wenn mindestens SW Version 5.7.17 dann Variable setzen
        if ($this->bootstrap->isShopware5717("5.7.17")) {
            $view->assign('isMinSw5717', 1);
        }

        // Bestimmte Themes können AGBs nur oberhalb des Checkout darstellen.
        /**if ($this->assertPluginsPresent(array('TcinnModernTheme'))) {
        $view->assign('themeNeedsAgbOnTop', 1);
        }*/

        // Legt die maximal erlaubte Zeichenlänge für das Strasse Feld bei der Registrierung fest
        $maxLengthStreet = 30;
        if (Shopware()->Config()->get('premsOnePageCheckoutStreetMaxLength')) {
            $maxLengthStreet = Shopware()->Config()->get('premsOnePageCheckoutStreetMaxLength');
        }
        $view->assign('premsOnePageCheckoutStreetMaxLength', $maxLengthStreet);

        // DHL Wunschpaket Plugin installiert?
        if ($this->assertPluginsPresent(array('DHLPaWunschpaket'))) {
            /** @var \DHLPaWunschpaket\Adapter\WunschpaketSDKAdapter $adapter */
            $adapter = Shopware()->Container()->get('mopt_wunschpaket.adapter');
            if ((bool)$adapter->getPluginConfig(\DHLPaWunschpaket\Bootstrap\PluginConfigInterface::ENABLED_FIELD)) {
                $view->assign('dhlWunschpaketPlugin', 1);
            }
        }
        // DHL Wunschpaket Plugin (neue Version dhlxxWunschzustellung) installiert?
        if ($this->assertPluginsPresent(array('dhlxxWunschzustellung'))) {
            /** @var \dhlxxWunschzustellung\Adapter\WunschpaketSDKAdapter $adapter */
            $adapter = Shopware()->Container()->get('mopt_wunschpaket.adapter');
            if ((bool)$adapter->getPluginConfig(\dhlxxWunschzustellung\Bootstrap\PluginConfigInterface::ENABLED_FIELD)){
                $view->assign('dhlWunschpaketPlugin', 1);
            }
        }

        // Endereco Adressprüfung Plugin installiert (Download oder Store Version)?
        if ($this->assertPluginsPresent(['EnderecoAMS'])) {
            $config = $this->container->get('shopware.plugin.cached_config_reader')->getByPluginName('EnderecoAMS', Shopware()->Shop());
            $view->assign('enderecoAMSClient', $config['isPluginActive']);
            $view->assign('enderecoAMSClientSplitStreet', $config['splitStreet']);
            $view->assign('enderecoAMSDownloadVersion', 0);
        } else if ($this->assertPluginsPresent(['EnderecoShopware5Client'])) {
            $config = $this->container->get('shopware.plugin.cached_config_reader')->getByPluginName('EnderecoShopware5Client', Shopware()->Shop());
            $view->assign('enderecoAMSClient', $config['isPluginActive']);
            $view->assign('enderecoAMSClientSplitStreet', $config['splitStreet']);
            $view->assign('enderecoAMSDownloadVersion', 1);
        }

        if ($this->assertPluginsPresent(array('SwagCustomProducts'))) {
            $view->assign('CustomProductsActive', 1);
        }

        if ($action != 'confirm' && $action != 'shippingPayment') {
            return;
        }

        // Formularwerte für Registrierung bereits gesetzt? Dann an Template übergeben und Session Wert leeren
        if (Shopware()->Session()->register) {
            $view->registerData = Shopware()->Session()->register;
            Shopware()->Session()->register = false;
        }

        // Login Fehlermeldung aus Session auslesen
        if (Shopware()->Session()->loginDataError) {
            $view->loginDataError = Shopware()->Session()->loginDataError;
            Shopware()->Session()->loginDataError = false;
        }
        // Email aus Session auslesen
        if (Shopware()->Session()->email) {
            $view->sFormDataLogin['email'] = Shopware()->Session()->email;
            Shopware()->Session()->email = '';
        }

        // Mögliche Fehlermeldung aus Session auslesen
        if (Shopware()->Session()->sErrorFlag || Shopware()->Session()->sErrorMessages) {
            $view->sErrorFlag = Shopware()->Session()->sErrorFlag;
            $view->sErrorMessages = Shopware()->Session()->sErrorMessages;
            Shopware()->Session()->sErrorFlag = false;
            Shopware()->Session()->sErrorMessages = false;
        }

        // AGB innerhalb einer Session immer aktiviert wenn einmal ausgewählt
        if(Shopware()->Config()->get('premsOnePageCheckoutSaveAgbStatus') && Shopware()->Session()->agbChecked) {
            $view->sAGBChecked = 1;
        }

        // Kommentar innerhalb einer Session immer ausgefüllt wenn einmal ausgefüllt
        if(Shopware()->Config()->get('premsOnePageCheckoutSaveComment') && Shopware()->Session()->comment) {
            $view->sComment = Shopware()->Session()->comment;
        }

        // Mögliche Fehlermeldung Registrierung ab Shopware 5.2 aus Session auslesen
        if ($this->bootstrap->isShopware52() && Shopware()->Session()->errors) {
            //$view->register = Shopware()->Session()->register;
            $view->errors = Shopware()->Session()->errors;
            Shopware()->Session()->errors = false;
        }

        if (Shopware()->Session()->sUserId) {
            $view->assign('sUserLoggedIn', true);
        } else {
            $view->assign('sUserLoggedIn', false);
        }
        $view->sPaymentMeans = $admin->sGetPaymentMeans();

        // PayOne Anpassung: Wenn der Wert gesetzt wird, dann kann man nicht Kreditkarte auswählen
        if ($action == 'shippingPayment' && $view->sFormData['payment'] == 'mopt_payone_creditcard') {
        } else {
            $view->sFormData = array('payment' => $view->sUserData['additional']['user']['paymentID']);
        }

        $view->sTarget = $request->getParam('sTarget', $request->getControllerName());
        $view->sTargetAction = $request->getParam('sTargetAction', 'index');

        $getPaymentDetails = $admin->sGetPaymentMeanById($view->sFormData['payment']);

        $paymentClass = $admin->sInitiatePaymentClass($getPaymentDetails);
        if ($paymentClass instanceof \ShopwarePlugin\PaymentMethods\Components\BasePaymentMethod) {
            $data = $paymentClass->getCurrentPaymentDataAsArray(Shopware()->Session()->sUserId);
            if (!empty($data)) {
                $view->sFormData += $data;
            }
        }

        // PayOne Anpassung: Wenn der Wert gesetzt wird, dann kann man nicht Kreditkarte auswählen
        if ($action == 'shippingPayment' && $view->sFormData['payment'] == 'mopt_payone_creditcard') {
        } else {
            if ($request->isPost()) {
                $values = $request->getPost();
                $values['payment'] = $request->getPost('register');
                $values['payment'] = $values['payment']['payment'];
                $values['isPost'] = true;
                $view->sFormData = $values;
            }

            $this->loadAndAssignShippingPaymentData($args);
        }

        // Nachladen von ShippingPayment aus Shopware Core, zur Unterstützung von "speziellen" Zahlplugins
        // wie PayPal Plus
        if ($action == 'shippingPayment') {
            if ($request->getPost('isXHR')) {
                /**if ($this->bootstrap->isShopware52()) {
                $this->bootstrap->Application()->Template()->addTemplateDir(
                $this->bootstrap->Path() . 'Views/shopware52/'
                );
                } else {
                $this->bootstrap->Application()->Template()->addTemplateDir(
                $this->bootstrap->Path() . 'Views/shopware5/'
                );
                }*/

                $view->extendsTemplate(
                    'frontend/checkout/shipping_payment_core.tpl'
                );
                $view->assign('useOnePageCheckout', 1);
            }
        }

        // Wenn Option gesetzt und gültig dann wird geprüft ob eine Zahlart mit der entsprechenden ID existiert. Falls ja so wird bei dieser
        // der Schlüssel redirectToPaymentPage gesetzt. Hierdurch kann man im Frontend ab SW 5.2. erzwingen das eine Weiterleitung
        // zur ShippingPayment Seite im OPC erfolgt. Ist sinnvoll um manche nicht kompatible Zahlartenplugins zu unterstützen.
        if (Shopware()->Config()->get('premsOpcPaymentsRedirectToPaymentPage')) {
            $paymentRedirects = explode(',', str_replace(' ', '', Shopware()->Config()->get('premsOpcPaymentsRedirectToPaymentPage')));
            if (!is_array($paymentRedirects) || count($paymentRedirects) == 0) {
                return;
            }
            $sPayments = $view->sPayments;
            foreach($sPayments as &$payment) {
                if (in_array($payment['id'], $paymentRedirects)) {
                    $payment['redirectToPaymentPage'] = 1;
                }
            }
            $view->sPayments = $sPayments;
        }

        if ($this->assertPluginsPresent(array('CwbBraintreeCwSw'))) {
            $view->assign('useBraintree', 1);
        }
        if ($this->assertPluginsPresent(array('CwbStripeCwSw'))) {
            $view->assign('useCwbStripe', 1);
        }

        // Prämien Produktauswahl anzeigen/verstecken
        $view->assign('premsShowPremiumProductArea', Shopware()->Config()->get('premsShowPremiumProductArea'));
        // Seperate Lieferadresse hinzufügen aktivieren/deaktivieren
        $view->assign('premsAdditionalShippingDisable', Shopware()->Config()->get('premsAdditionalShippingDisable'));

        $view->assign('useOnePageCheckout', Shopware()->Config()->get('useOnePageCheckout'));
        $view->assign('useStepsOnlyVertical', Shopware()->Config()->get('useStepsOnlyVertical'));
        $view->assign('premsAgbOnTop', Shopware()->Config()->get('premsAgbOnTop'));
        $view->assign('premsShowNoConfirmFooterBeforeLogin', Shopware()->Config()->get('premsNoConfirmFooterBeforeLogin'));
        $view->assign('premsShowArticleProperties', Shopware()->Config()->get('premsShowArticleProperties'));
        $view->assign('premsShowOrderText', Shopware()->Config()->get('premsShowOrderText'));
        $view->assign('premsOpcPaymentsRedirectToPaymentPage', Shopware()->Config()->get('premsOpcPaymentsRedirectToPaymentPage'));
        $view->assign('premsOpcCompabilityMode', Shopware()->Config()->get('premsOpcCompabilityMode'));
        $view->assign('registerBeforeLogin', Shopware()->Config()->get('registerBeforeLogin'));
        $view->assign('loginInitiallyOpen', Shopware()->Config()->get('loginInitiallyOpen'));
        $view->assign('premsRegisterInitiallyOpen', Shopware()->Config()->get('premsRegisterInitiallyOpen'));
        $view->assign('zipBeforeStreet', Shopware()->Config()->get('zipBeforeStreet'));
        $view->assign('premsRegisterOnlyAsCompany', Shopware()->Config()->get('premsRegisterOnlyAsCompany'));
        $view->assign('premsOpcShowAfterLoginRegistrationAvailableText', Shopware()->Config()->get('premsOpcShowAfterLoginRegistrationAvailableText'));
        $view->assign('premsOpcDefaultRegisterAsGuest', Shopware()->Config()->get('premsOpcDefaultRegisterAsGuest'));
        $view->assign('premsOnePageCheckoutEmailPassPosition', Shopware()->Config()->get('premsOnePageCheckoutEmailPassPosition'));
        $view->assign('premsOnePageCheckoutShowCountryDisabledDefault', Shopware()->Config()->get('premsOnePageCheckoutShowCountryDisabledDefault'));
        $view->assign('premsOnePageCheckoutVoucherOnTop', Shopware()->Config()->get('premsOnePageCheckoutVoucherOnTop'));
        $view->assign('premsOnePageCheckoutNoCommentArea', Shopware()->Config()->get('premsOnePageCheckoutNoCommentArea'));
        $view->assign('premsOnePageCheckoutReloadBuyboy', Shopware()->Config()->get('premsOnePageCheckoutReloadBuyboy'));
        // Markieren das wir uns in Schritt 3 befinden. Wird in der shipping_payment.tpl überschrieben auf isStep3 = 0 um zu erkennen, das Schritt 2 /shippingPayment aufgerufen wurde.
        $view->assign('isStep3', 1);
        // Im Vertikalen Modus automatisch nach Login/ Registrierung zu Schritt 2 springen.
        $view->assign('premsOnePageCheckoutScrollToStep2', Shopware()->Config()->get('premsOnePageCheckoutScrollToStep2'));

        // Zusätzliche Checkbox im Checkout
        $view->assign('premsOnePageCheckoutShowAdditionalCheckbox', Shopware()->Config()->get('premsOnePageCheckoutShowAdditionalCheckbox'));
        $view->assign('premsOnePageCheckoutAdditionalCheckboxIsRequired', Shopware()->Config()->get('premsOnePageCheckoutAdditionalCheckboxIsRequired'));
        $view->assign('premsOnePageCheckoutAdditionalCheckboxIsChecked', Shopware()->Config()->get('premsOnePageCheckoutAdditionalCheckboxIsChecked'));
        $view->assign('premsOnePageCheckoutAdditionalCheckboxAfterAgb', Shopware()->Config()->get('premsOnePageCheckoutAdditionalCheckboxAfterAgb'));

        if ($this->bootstrap->isShopware53()) {
            $view->assign('isMinShopware53', true);
        } else {
            $view->assign('isMinShopware53', false);
        }
    }

    /**
     * Zusätzliche Checkbox OPC bei als Bestellung Attribut speichern
     * @param \Enlight_Event_EventArgs $args
     */
    public function onSaveOrderFilterParams(\Enlight_Event_EventArgs $args)
    {
        /** @var \sOrder $subject */
        $subject = $args->getSubject();

        $sOpcAdditionalCheckbox = Shopware()->Session()->get('sOpcAdditionalCheckbox');

        if ($sOpcAdditionalCheckbox) {
            $subject->orderAttributes['prems_opc_additional_checkbox'] = $sOpcAdditionalCheckbox;
        }
    }
}
