<?php

namespace Shopware\PremsOnePageCheckout\Subscriber;

use Shopware_Plugins_Frontend_PremsOnePageCheckout_Bootstrap as Bootstrap;

class ControllerPath implements \Enlight\Event\SubscriberInterface {
  /**
   * @var Bootstrap $bootstrap
   */
  protected $bootstrap;

  /**
   * @param Bootstrap $bootstrap
   */
  public function __construct(Bootstrap $bootstrap) {
    $this->bootstrap = $bootstrap;
  }

  public static function getSubscribedEvents() {
    return array(
      'Enlight_Controller_Dispatcher_ControllerPath_Frontend_PremsOnePageCheckout' => 'onGetFrontendController',
    );
  }

  /**
   * Register frontend controller
   * @param \Enlight_Event_EventArgs $args
   * @return string
   */
  public function onGetFrontendController(\Enlight_Event_EventArgs $args) {
    if (!Shopware()->Config()->get('useOnePageCheckout')) {
      return;
    }

    $this->bootstrap->Application()->Snippets()->addConfigDir($this->bootstrap->Path() . 'Snippets/');

    if ($this->bootstrap->isShopware52()) {
      //die($this->bootstrap->Path() . 'Views/frontend/shopware52/');
      /**$this->bootstrap->Application()->Template()->addTemplateDir(
        $this->bootstrap->Path() . 'Views/shopware52/'
      );*/

      if ($this->bootstrap->isShopware53()) {
        $this->bootstrap->Application()->Template()->assign('isMinShopware53', true);
      } else {
        $this->bootstrap->Application()->Template()->assign('isMinShopware53', false);
      }
      return $this->bootstrap->Path() . '/Controllers/Frontend/Shopware52/PremsOnePageCheckout.php';
    } else {
      /**$this->bootstrap->Application()->Template()->addTemplateDir(
        $this->bootstrap->Path() . 'Views/shopware5/'
      );*/
      return $this->bootstrap->Path() . '/Controllers/Frontend/Shopware5/PremsOnePageCheckout.php';
    }
  }
}