<?php

namespace Shopware\PremsOnePageCheckout\Subscriber;

use Shopware_Plugins_Frontend_PremsOnePageCheckout_Bootstrap as Bootstrap;

class Register implements \Enlight\Event\SubscriberInterface {
  /**
   * @var Bootstrap $bootstrap
   */
  protected $bootstrap;

  /**
   * @param \Shopware_Plugins_Frontend_PremsOnePageCheckout_Bootstrap $bootstrap
   */
  public function __construct(Bootstrap $bootstrap) {
    $this->bootstrap = $bootstrap;
  }


  public static function getSubscribedEvents() {
    return array(
      'Enlight_Controller_Action_PostDispatchSecure_Frontend_Register' => 'onPostDispatch',
      'Shopware_Modules_Admin_SaveRegister_DoubleOptIn_Waiting' => 'onDoubleOptInWaiting',
    );
  }

  /**
   * @param \Enlight_Event_EventArgs $args
   */
  public function onDoubleOptInWaiting(\Enlight_Event_EventArgs $args)
  {
    if (!Shopware()->Config()->get('useOnePageCheckout')) {
      return;
    }
    Shopware()->Session()->optinsuccess = true;
  }

  /**
   * @param \Enlight_Event_EventArgs $args
   */
  public function onPostDispatch(\Enlight_Event_EventArgs $args) {
    if (!Shopware()->Config()->get('useOnePageCheckout')) {
      return;
    }

    $this->bootstrap->Application()->Snippets()->addConfigDir($this->bootstrap->Path() . 'Snippets/');

    /** @var \Enlight_Controller_Action $controller */
    $controller = $args->getSubject();
    $request = $controller->Request();
    $action = $request->getActionName();
    $view = $controller->View();

    $view->assign('useOnePageCheckout', Shopware()->Config()->get('useOnePageCheckout'));

    $view->assign('premsRegisterOnlyAsCompany', Shopware()->Config()->get('premsRegisterOnlyAsCompany'));

    if (($action == 'index' || $action == 'saveRegister')
      && ($request->getParam('sTargetAction') == 'confirm' || $request->getParam('sTargetAction') == 'index')
      && $request->getParam('sTarget') == 'checkout') {
      if ($this->bootstrap->isShopware52()) {
        Shopware()->Session()->errors = $view->errors;
      }

      Shopware()->Session()->register = $view->register;

        if (Shopware()->Config()->get('always_select_payment')) {
            return $controller->redirect(array(
                'action' => 'shippingPayment',
                'controller' => 'checkout',
            ));
        } else {
            return $controller->redirect(array(
                'action' => 'confirm',
                'controller' => 'checkout',
            ));
        }
    }

    return;
  }
}