<?php
/**
 * premsoft
 * Copyright © 2018 Premsoft - Sven Mittreiter
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License, supplemented by an additional
 * permission, and of our proprietary license can be found
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, titles and interests in the
 * above trademarks remain entirely with the trademark owners.
 *
 * @copyright  Copyright (c) 2018, premsoft - Sven Mittreiter (http://www.premsoft.de)
 * @author     Sven Mittreiter <info@premsoft.de>
 */
namespace Shopware\PremsOnePageCheckout\Subscriber;

use Enlight\Event\SubscriberInterface;

use Symfony\Component\DependencyInjection\Container;
use Shopware_Plugins_Frontend_PremsOnePageCheckout_Bootstrap as Bootstrap;

class Resource implements SubscriberInterface {
  /** @var  \Enlight_Config */
  protected $config;

  /**
   * @var Bootstrap $bootstrap
   */
  protected $bootstrap;

  public static function getSubscribedEvents() {
    return array(
      'Enlight_Controller_Action_PreDispatch' => 'onPreDispatch',
    );
  }

  public function __construct($bootstrap) {
    $this->bootstrap = $bootstrap;
  }

  public function onPreDispatch(\Enlight_Event_EventArgs $arguments) {
    if ($this->bootstrap->isShopware57()) {
      $this->bootstrap->Application()->Template()->addTemplateDir(
        $this->bootstrap->Path() . 'Views/shopware57/'
      );
    } elseif ($this->bootstrap->isShopware56()) {
        $this->bootstrap->Application()->Template()->addTemplateDir(
            $this->bootstrap->Path() . 'Views/shopware56/'
        );
    } elseif ($this->bootstrap->isShopware55()) {
      $this->bootstrap->Application()->Template()->addTemplateDir(
        $this->bootstrap->Path() . 'Views/shopware55/'
      );
    } elseif ($this->bootstrap->isShopware53()) {
      $this->bootstrap->Application()->Template()->addTemplateDir(
        $this->bootstrap->Path() . 'Views/shopware52/'
      );
    } elseif ($this->bootstrap->isShopware52()) {
      $this->bootstrap->Application()->Template()->addTemplateDir(
        $this->bootstrap->Path() . 'Views/shopware52/'
      );
    } else {
      $this->bootstrap->Application()->Template()->addTemplateDir(
        $this->bootstrap->Path() . 'Views/shopware5/'
      );
    }
  }
}
