;
(function ($) {
    "use strict";

    $.plugin('premsOnePageCheckout', {
        /**
         * Plugin default options.
         * Get merged automatically with the user configuration.
         */
        defaults: {

            /**
             * Class to indicate an element to be hidden.
             *
             * @property hiddenClass
             * @type {String}
             */
            hiddenClass: 'is--hidden',

            /**
             * Class to indicate that an element has an error.
             *
             * @property errorClass
             * @type {String}
             */
            errorClass: 'has--error',

            /**
             * Selector for the form.
             *
             * @property formSelector
             * @type {String}
             */
            registerFormSelector: '#opc-register',

            /**
             * Selector for the forms submit button.
             *
             * @property submitBtnSelector
             * @type {String}
             */
            submitBtnSelector: '.register--submit',

            /**
             * Selector for the type selection field.
             *
             * @property typeFieldSelector
             * @type {String}
             */
            typeFieldSelector: '.register--customertype select',

            /**
             * Type name for a company selection.
             * Used for comparison on the type selection field.
             *
             * @property companyType
             * @type {String}
             */
            companyType: 'business',

            /**
             * Selector for the skip account creation checkbox.
             * Toggles specific field sets when checked.
             *
             * @property skipAccountSelector
             * @type {String}
             */
            skipAccountSelector: '#one-page-checkout #register_personal_skipLogin',

            /**
             * Selector for the alternative shipping checkbox.
             * Toggles specific field sets when checked.
             *
             * @property altShippingSelector
             * @type {String}
             */
            altShippingSelector: '.register--alt-shipping input',

            /**
             * Selector for the company field set.
             *
             * @property companyFieldSelector
             * @type {String}
             */
            companyFieldSelector: '.register--company',

            /**
             * Selector for the account field set.
             *
             * @property accountFieldSelector
             * @type {String}
             */
            accountFieldSelector: '.register--account-information',

            /**
             * Selector for the shipping field set.
             *
             * @property shippingFieldSelector
             * @type {String}
             */
            shippingFieldSelector: '#one-page-checkout .register--shipping',

            /**
             * Selector for the payment field set.
             *
             * @property paymentFieldSelector
             * @type {String}
             */
            paymentFieldSelector: '.payment--content',

            /**
             * Selector for the payment selection radio button.
             *
             * @property paymentInputSelector
             * @type {String}
             */
            paymentInputSelector: '.payment--selection-input input',

            /**
             * Selector for the country select field.
             *
             * @property countryFieldSelector
             * @type {String}
             */
            countryFieldSelector: '.select--country',

            /**
             * Selector for the state field set.
             * This corresponding field set will be toggled
             * when a country was selected.
             *
             * @property stateContainerSelector
             * @type {String}
             */
            stateContainerSelector: '.register--state-selection, .address--state-selection',

            /**
             * Selector for the payment method select fields.
             *
             * @property paymentMethodSelector
             * @type {String}
             */
            paymentMethodSelector: '.payment--method',

            /**
             * Selector for a input field.
             *
             * @property inputSelector
             * @type {String}
             */
            inputSelector: '.is--required',

            /**
             * Class that will be added to a error message.
             *
             * @property errorMessageClass
             * @type {String}
             */
            errorMessageClass: 'register--error-msg',

            /**
             * Selector for the email field.
             *
             * @property personalEmailSelector
             * @type {String}
             */
            personalEmailSelector: '#register_personal_email',

            /**
             * Selector for the password field.
             *
             * @property personalPasswordSelector
             * @type {String}
             */
            personalPasswordSelector: '#register_personal_password',

            /**
             * Selector for the email confirmation field.
             *
             * @property personalEmailConfirmationSelector
             * @type {String}
             */
            personalEmailConfirmationSelector: '#register_personal_emailConfirmation',

            /**
             * Selector for the password confirmation field.
             *
             * @property personalPasswordConfirmationSelector
             * @type {String}
             */
            personalPasswordConfirmationSelector: '#register_personal_passwordConfirmation',

            /**
             * Selector for the guest checkbox.
             *
             * @property personalPasswordConfirmationSelector
             * @type {String}
             */
            personalGuestSelector: '#register_personal_skipLogin',

            /**
             * Radio Selector for Shipping/Payment
             */
            shippingPaymentRadioSelector: '#one-page-checkout .register--shipment-and-payment input.auto_submit[type=radio]',

            /**
             * Form Selector for Shipping/Payment
             */
            shippingPaymentformSelector: '#one-page-checkout .register--shipment-and-payment #shippingPaymentForm',

            changePaymentArea: '#one-page-checkout #opc-change-payment-area',

            checkoutBtn: '#one-page-checkout button[form=confirm--form]',

            ammountSummarySelector: '#one-page-checkout .basket--footer',

            agbCheckbox: '#one-page-checkout #sAGB',

            commentInput: '#one-page-checkout .user-comment--field',

            buyPanel: '#one-page-checkout .basket--footer',
        },

        /**
         * Initializes the plugin, sets up event listeners and adds the necessary
         * classes to get the plugin up and running.
         *
         * @public
         * @method init
         */
        init: function () {
            var me = this,
                opts = me.opts,
                $el = me.$el;

            me.$personalEmail = $el.find(opts.personalEmailSelector);
            me.$personalPassword = $el.find(opts.personalPasswordSelector);
            me.$personalEmailConfirmation = $el.find(opts.personalEmailConfirmationSelector);
            me.$personalPasswordConfirmation = $el.find(opts.personalPasswordConfirmationSelector);
            me.$personalGuest = $el.find(opts.personalGuestSelector);

            me.$registerFormSelector = $el.find(opts.registerFormSelector);

            me.$submitBtn = $el.find(opts.submitBtnSelector);
            me.$checkoutBtn = $el.find(opts.checkoutBtn);

            me.$typeSelection = $el.find(opts.typeFieldSelector);
            me.$skipAccount = $el.find(opts.skipAccountSelector);
            me.$alternativeShipping = $el.find(opts.altShippingSelector);

            me.$companyFieldset = $el.find(opts.companyFieldSelector);
            me.$accountFieldset = $el.find(opts.accountFieldSelector);
            me.$shippingFieldset = $el.find(opts.shippingFieldSelector);

            me.$countySelectFields = $el.find(opts.countryFieldSelector);
            me.$stateContainers = $el.find(opts.stateContainerSelector);

            me.$paymentMethods = $el.find(opts.paymentMethodSelector);

            me.$inputs = $el.find(opts.inputSelector);

            me.$agbCheckbox = $el.find(opts.agbCheckbox);

            me.$commentInput = $el.find(opts.commentInput);

            me.checkType();
            me.checkSkipAccount();
            me.checkChangeShipping();

            me.registerEvents();

            // Wenn Option zum Speichern des AGB Status gesetzt ist, dann AGB Checkbox setzen, falls in der Session.
            // Der Wert steht im Data-Tag, da das SW PayPal Plugin nicht erlaubt, das zur Ladezeit die Checkbox
            // standardmäßig aktiviert ist.
            window.setTimeout(function() {
                if (me.$agbCheckbox.data('checked') == 'checked') {
                    //me.$agbCheckbox.prop('checked', true);
                    me.$agbCheckbox.trigger('click');
                    window.setTimeout(function() {
                        me.$agbCheckbox.trigger('click');
                    }, 100);
                }
            }, 3000);

            window.setTimeout(function() {
                if ($('.register--shipment-and-payment .js--loading-indicator').length) {
                    me.loadChangePaymentArea();
                } else {

                    if($('*[data-paypalPaymentWallShippingPayment="true"]').length) {
                        $.overridePlugin('swagPayPalUnifiedPaymentWallShippingPayment', {
                            triggerPaymentMethodChange: function ($selectedPaymentRadio) {
                                $selectedPaymentRadio.prop('checked', true).trigger('change');
                            },
                        });

                        var defaults = {
                                activeCls: 'js--is-active',
                                staticActiveCls: 'is--active',
                                paymentSelectionSelector: '.paypal--payment-selection',
                                paymentMethodSelector: '.unified--payment',
                                restylePaymentSelectionAttribute: 'data-restylePaymentSelection'
                            },
                            restylePaymentSelection = $(defaults.paymentSelectionSelector).attr(defaults.restylePaymentSelectionAttribute);

                        if (restylePaymentSelection === 'true') {
                            //me.$el.on('click', defaults.paymentMethodSelector, $.proxy(me.onShippingPaymentInputChanged, me));
                            //me.$el.on('change', me.opts.shippingPaymentRadioSelector, $.proxy(me.onShippingPaymentInputChanged, me));

                            $(defaults.paymentMethodSelector).click(function(event) {
                                var $target = $(event.currentTarget),
                                    $radio = $target.find('input[name="payment"]');

                                if ($target.hasClass(defaults.activeCls) || $target.hasClass(defaults.staticActiveCls)) {
                                    return;
                                }

                                me.$el.find(defaults.paymentMethodSelector).removeClass(defaults.activeCls).removeClass(defaults.staticActiveCls);

                                $target.addClass(defaults.activeCls);
                                $radio.prop('checked', true).trigger('change');
                            });
                        }
                    }
                }
            }, 500);
        },

        /**
         * Registers all necessary event listeners for the plugin to proper operate.
         *
         * @public
         * @method registerEvents
         */
        registerEvents: function () {
            var me = this;

            me._on(me.$typeSelection, 'change', $.proxy(me.checkType, me));
            me._on(me.$skipAccount, 'change', $.proxy(me.checkSkipAccount, me));
            me._on(me.$alternativeShipping, 'change', $.proxy(me.checkChangeShipping, me));
            me._on(me.$countySelectFields, 'change', $.proxy(me.onCountryChanged, me));
            me._on(me.$paymentMethods, 'change', $.proxy(me.onPaymentChanged, me));
            me._on(me.$registerFormSelector, 'focusout', $.proxy(me.onValidateInput, me));
            me._on(me.$submitBtn, 'click', $.proxy(me.onSubmitBtn, me));
            me._on(me.$checkoutBtn, 'click', $.proxy(me.onCheckoutBtn, me));
            me._on(me.$agbCheckbox, 'click', $.proxy(me.onAgbCheckbox, me));
            me._on(me.$commentInput, 'change', $.proxy(me.onCommentInput, me));

            me.wunschpaketPlugin();

            /**$.subscribe('plugin/swAddressEditor/onAfterSave', function (event, me) {
               window.location.reload();
            });*/

            me.$countySelectFields.change();

            me.$el.on('change', me.opts.shippingPaymentRadioSelector, $.proxy(me.onShippingPaymentInputChanged, me));

            StateManager.addPlugin('#one-page-checkout #opc-register-link', 'swCollapsePanel');
            StateManager.addPlugin('#one-page-checkout #opc-login-link', 'swCollapsePanel');

            if ($('*[data-scroll-to-step2="true"]').length) {
                me.scrollToStep2();
            }

            $.publish('plugin/opcRegister/onRegisterEvents', me);
        },

        scrollToStep2: function() {
            var me = this;

            // Zu Schritt 2 scrollen wenn eingeloggt
            if (!$('#opc-step2').hasClass('not-logged-in')) {
                var scrollDiv  = $('#opc-step2');
                if (scrollDiv.length) {
                    $('html,body').animate({scrollTop: scrollDiv.offset().top}, 'fast');
                }
            }
        },

        onCommentInput: function() {
            var me = this;

            $.ajax({
                type: 'post',
                url: me.$commentInput.data('save-comment'),
                data: {
                    comment: me.$commentInput.val()
                },
                success: function(response) {
                }
            });
        },

        onAgbCheckbox: function() {
            var me = this,
                agb = 0;

            if (me.$agbCheckbox.is(':checked')) {
                agb = 1;
            }

            me.$agbCheckbox.data('save-status');

            $.ajax({
                type: 'post',
                url: me.$agbCheckbox.data('save-status'),
                data: {
                    agb: agb
                },
                success: function(response) {
                }
            });
        },

        onCheckoutBtn: function(event) {
            var me = this,
                error = false,
                $input;

            if ($('#sAGB').length && !$('#sAGB').is(':checked')) {
                error = true;
            }

            if ($('#esdAgreementChecked').length && !$('#esdAgreementChecked').is(':checked')) {
                error = true;
            }

            if ($('#klarnaCheckbox').length && !$('#klarnaCheckbox').is(':checked')) {
                error = true;
            }

            if ($('#netzp-dsgvo-checkbox').length && !$('#netzp-dsgvo-checkbox').is(':checked')) {
                error = true;
            }

            if (error == false) {
                $.loadingIndicator.open({closeOnClick: false});
            }
        },

        reloadAmountSummary: function() {
            var me = this;
            var checkoutUrl = $('#opc--checkout-url').val();

            $.ajax({
                type: 'post',
                url: checkoutUrl,
                success: function(response) {
                    var $response = $($.parseHTML(response, document, true)),
                        $summary;

                    $summary = $response.find(me.opts.ammountSummarySelector);
                    $(me.opts.ammountSummarySelector).html($summary.html());
                }
            });
        },

        wunschpaketPlugin: function() {
            var me = this;

            $.subscribe('plugin/moptWunschpaketDhlBox/onInputChanged', function () {
                me.reloadAmountSummary();
            });

            if ($('#mopt-wunschpaket-address-type-select').length) {
                //var addDhlPlugin = function (window) {
                    window.StateManager
                        .addPlugin('#opc-register', 'moptWunschpaketAddress',
                            ['xs', 's', 'm', 'l', 'xl']);
                //};
                //addDhlPlugin(window);
            }

            if ($('#moptEmpfaengerservicesWunschpaket').length) {
                var addDhlPlugin = function (window) {
                    StateManager
                        .addPlugin('#moptEmpfaengerservicesWunschpaket', 'moptWunschpaketBox')
                        .addPlugin('*[data-address-selection="true"]', 'swAddressSelection');
                    ;
                };

                addDhlPlugin(window);

                $.subscribe('plugin/swShippingPayment/onInputChanged', function () {
                    addDhlPlugin(window);
                });
                $.subscribe('plugin/moptWunschpaketDhlBox/onInputChanged', function () {
                    addDhlPlugin(window);
                });

                StateManager
                    .addPlugin('form[name="frmAddresses"], #registration form.register--form', 'moptWunschpaketAddress',
                        ['xs', 's', 'm', 'l', 'xl'])
                ;
                $.overridePlugin('swAddressEditor', {
                    _registerPlugins: function () {
                        var me = this;
                        StateManager
                            .addPlugin('form[name="frmAddresses"], #registration form.register--form', 'moptWunschpaketAddress',
                                ['xs', 's', 'm', 'l', 'xl'])
                        ;

                        me.superclass._registerPlugins.apply(this, arguments);
                    }
                });
            }
        },

        postNLPlugin: function() {
            var me = this;
            if ($('#sitionPostNLServicesDesiredPackage').length) {
                var addPostNLPlugin = function (window) {
                    StateManager
                        .addPlugin('#sitionPostNLServicesDesiredPackage', 'sitionPostnlPackageBox')
                        .addPlugin('*[data-address-editor="true"]', 'swAddressEditor');
                    ;
                };

                addPostNLPlugin(window);

                $.subscribe('plugin/swShippingPayment/onInputChanged', function () {
                    addPostNLPlugin(window);
                });
                $.subscribe('plugin/sitionPostNLPackagePostNLBox/onInputChanged', function () {
                    addPostNLPlugin(window);
                });

                StateManager
                    .addPlugin('form[name="frmAddresses"], #registration form.register--form', 'sitionPostnlPackageAddress',
                        ['xs', 's', 'm', 'l', 'xl'])
                ;
                $.overridePlugin('swAddressEditor', {
                    _registerPlugins: function () {
                        var me = this;
                        StateManager
                            .addPlugin('form[name="frmAddresses"], #registration form.register--form', 'sitionPostnlPackageAddress',
                                ['xs', 's', 'm', 'l', 'xl'])
                        ;

                        me.superclass._registerPlugins.apply(this, arguments);
                    }
                });
            }
        },

        reloadBuyBox: function() {
            var me = this;
            $(me.opts.buyPanel).hide();
            $.ajax({
                type: 'post',
                url: document.location.href,
                success: function (response) {
                    var $response = $($.parseHTML(response, document, true)),
                        $buyPanel;

                    // Replace the buy panel
                    $buyPanel = $response.find(me.opts.buyPanel);
                    $(me.opts.buyPanel).html($buyPanel.html());
                    $(me.opts.buyPanel).show(1000);
                }
            });
        },

        loadChangePaymentArea: function() {
            var me = this,
                $el = me.$el,
                paymentArea = $el.find(me.opts.changePaymentArea);

            if (!paymentArea.length) {
                return;
            }

            var data = $('#shippingPaymentForm').serializeArray();
            data.push({name: 'isXHR', value: 1});
            data.push({name: 'payment', value: paymentArea.data('payment')});

            $.ajax({
                type: "POST",
                url: paymentArea.data('url'),
                data: data,
                /**data: {
                    'isXHR': 1,
                    'payment': paymentArea.data('payment')
                },*/
                success: function(res) {
                    paymentArea.empty().html(res);
                    $.loadingIndicator.close();
                    window.picturefill();

                    if (!$('.is--act-shippingpayment').length) {
                        $('.payment--method .method--input input:checked').each(function() {
                            if ($(this).parent().parent().find('.method--bankdata').length &&
                                me.hasVisibleBankdata($(this).parent().parent().find('.method--bankdata'))) {
                                $(this).parent().parent().find('.method--label .method--name .more--shipping-payment-link').show();
                            }
                        });
                    }

                    $('.method--bankdata').addClass('is--hidden');

                    me.wunschpaketPlugin();
                    me.postNLPlugin();
                    if ($('*[data-reload-buybox="true"]').length) {
                        me.reloadBuyBox();
                    }

                    if($('*[data-paypalPaymentWallShippingPayment="true"]').length) {
                        $.overridePlugin('swagPayPalUnifiedPaymentWallShippingPayment', {
                            triggerPaymentMethodChange: function ($selectedPaymentRadio) {
                                $selectedPaymentRadio.prop('checked', true).trigger('change');
                            },
                        });
                    }

                    if ($('*[data-crefopay-plugin="true"]').length) {
                        if ($('.is--ctl-checkout.is--act-confirm #one-page-checkout').length) {
                            $.overridePlugin('crefoPay', {
                                onSubmit: function(e) {
                                    if (!this.isCrefoPayPaymentMethodSelected() || this.crefoPayPaymentRegistered) {
                                        return true;
                                    }
                                    if ($('input[data-crefopay="paymentMethod"]:checked').val() == "CC3D") {
                                        return true;
                                    }
                                    if ($('input[data-crefopay="paymentMethod"]:checked').val() !== "PAYPAL"){
                                        this.setLoading(true);
                                    }

                                    this.crefoPaySubmitForm = e.target;

                                    this.getSecureFieldsClient().registerPayment();

                                    return false;
                                },
                            });
                        }

                        window.StateManager.addPlugin('[data-crefopay-plugin="true"]', 'crefoPay');
                    }

                    // JS für neues PayPalUnified Plugin
                    window.setTimeout(function() {
                        me.paypalUnifiedLoadPaymentWall();
                    }, 1000);

                    $.publish('plugin/opcPayment/onPaymentLoad', me);
                }
            });
        },

        paypalUnifiedLoadPaymentWall: function() {
            var me = this,
                $el = me.$el;

            if($('*[data-paypalPaymentWallShippingPayment="true"]').length) {

                window.StateManager.addPlugin('*[data-paypalPaymentWallShippingPayment="true"]', 'swagPayPalUnifiedPaymentWallShippingPayment');
                window.StateManager.addPlugin('*[data-paypalPaymentWall="true"]', 'swagPayPalUnifiedPaymentWall');

                var defaults = {
                        activeCls: 'js--is-active',
                        staticActiveCls: 'is--active',
                        paymentSelectionSelector: '.paypal--payment-selection',
                        paymentMethodSelector: '.unified--payment',
                        restylePaymentSelectionAttribute: 'data-restylePaymentSelection'
                    },
                    restylePaymentSelection = $(defaults.paymentSelectionSelector).attr(defaults.restylePaymentSelectionAttribute);

                if (restylePaymentSelection === 'true') {
                    //me.$el.on('click', defaults.paymentMethodSelector, $.proxy(me.onShippingPaymentInputChanged, me));
                    //me.$el.on('change', me.opts.shippingPaymentRadioSelector, $.proxy(me.onShippingPaymentInputChanged, me));

                    $(defaults.paymentMethodSelector).click(function(event) {
                        var $target = $(event.currentTarget),
                            $radio = $target.find('input[name="payment"]');

                        if ($target.hasClass(defaults.activeCls) || $target.hasClass(defaults.staticActiveCls)) {
                            return;
                        }

                        me.$el.find(defaults.paymentMethodSelector).removeClass(defaults.activeCls).removeClass(defaults.staticActiveCls);

                        $target.addClass(defaults.activeCls);
                        $radio.prop('checked', true).trigger('change');
                    });
                }
            }
        },

        // Prüft ob Bankdata vorhanden sind bzw. mind. eine hiervon sichtbar oder ob eine spezielle Plugin
        // Regel zutrifft
        hasVisibleBankdata: function(bankdata) {
            var visibleBankdata = false;

            if ($(bankdata).find('#payengineCreditCardContent').length || $(bankdata).find('*[data-crefopay-plugin-creditcard="true"]').length) {
                visibleBankdata = true;
            }

            $(bankdata).find('input').each(function() {
                if ($(this).attr('type') != 'hidden') {
                    visibleBankdata = true;
                }
            });
            $(bankdata).find('iframe').each(function() {
               visibleBankdata = true;
            });
            return visibleBankdata;
        },

        /**
         * Called on change event of the radio fields.
         */
        onShippingPaymentInputChanged: function (event) {
            var me = this,
                $target = $(event.target),
                form = me.$el.find(me.opts.shippingPaymentformSelector),
                url = form.attr('action'),
                data = form.serialize() + '&isXHR=1';
            $.publish('plugin/opcShippingPayment/onInputChangedBefore', me);

            if (!$('.is--act-shippingpayment').length) {
                // Bankdaten mit Pflichtfeldern vorhanden oder Klasse redirect--to-payment-page gesetzt?
                // Dann redirect zu Payment Seite des OPC
                if (
                    ($target.parent().parent().find('.method--bankdata').length &&
                    me.hasVisibleBankdata($target.parent().parent().find('.method--bankdata'))) ||
                    $target.hasClass('redirect--to-payment-page')) {
                    //redirect to change shipping/payment page
                    form.attr('action', $('#opc--more-payments-url').val());

                    //form.submit();

                    $.loadingIndicator.open();
                    $.ajax({
                        type: "POST",
                        url: url,
                        data: data,
                        success: function(res) {
                            window.location.href = url;
                        }
                    });
                } else {
                    // Ladeanzeige nötig, da sonst ohne Validierung bestellt werden kann.
                    $.loadingIndicator.open({closeOnClick: false});
                    form.submit();
                }
                /**

                // reload für amazon pay und PayPal Plus
                } else if ($target.parent().parent().find('#ppplus').length || $target.parent().parent().find('.payment_logo_amazon_pay')) {
                    form.submit();
                    // Display Change Payment Button
                // Nur die Zahlart im Hintergrund ändern
                } else {
                    $.ajax({
                        type: "POST",
                        url: url,
                        data: data,
                        success: function(res) {
                        }
                    });
                }
                 */
                // ShippingPayment Seite: Wenn eine Methode ohne Formularfelder aufgerufen wird dann Rückführung in
                // Standard OPC
            } else {
                if (
                    ($target.parent().parent().find('.method--bankdata').length &&
                        me.hasVisibleBankdata($target.parent().parent().find('.method--bankdata'))) ||
                    $target.hasClass('redirect--to-payment-page')) {
                } else {
                    window.setTimeout(function() {
                        form.submit();
                    }, 1000);
                }
            }
        },

        /**
         * Checks the type selection field.
         * If the value is equal to the configured companyType,
         * the company field set will be shown.
         *
         * @public
         * @method checkType
         */
        checkType: function () {
            var me = this,
                opts = me.opts,
                $fieldSet = me.$companyFieldset,
                hideCompanyFields = (me.$typeSelection.length && me.$typeSelection.val() !== opts.companyType),
                requiredFields = $fieldSet.find(opts.inputSelector),
                requiredMethod = (!hideCompanyFields) ? me.setHtmlRequired : me.removeHtmlRequired,
                classMethod = (!hideCompanyFields) ? 'removeClass' : 'addClass';

            requiredMethod(requiredFields);

            $fieldSet[classMethod](opts.hiddenClass);

            $.publish('plugin/opcRegister/onCheckType', [me, hideCompanyFields]);
        },

        /**
         * Checks the skip account checkbox.
         * The account field set will be shown/hidden depending
         * on the check state of the checkbox.
         *
         * @public
         * @method checkSkipAccount
         */
        checkSkipAccount: function () {
            var me = this,
                opts = me.opts,
                $fieldSet = me.$accountFieldset,
                isChecked = me.$skipAccount.is(':checked'),
                requiredFields = $fieldSet.find(opts.inputSelector),
                requiredMethod = (!isChecked) ? me.setHtmlRequired : me.removeHtmlRequired,
                classMethod = (isChecked) ? 'addClass' : 'removeClass';

            requiredMethod(requiredFields);

            $fieldSet[classMethod](opts.hiddenClass);

            $.publish('plugin/opcRegister/onCheckSkipAccount', [me, isChecked]);
        },

        /**
         * Checks the alternative shipping checkbox.
         * The shipping field set will be shown/hidden depending
         * on the check state of the checkbox.
         *
         * @public
         * @method checkChangeShipping
         */
        checkChangeShipping: function () {
            var me = this,
                opts = me.opts,
                $fieldSet = me.$shippingFieldset,
                isChecked = me.$alternativeShipping.is(':checked'),
                requiredFields = $fieldSet.find(opts.inputSelector),
                requiredMethod = (isChecked) ? me.setHtmlRequired : me.removeHtmlRequired,
                classMethod = (isChecked) ? 'removeClass' : 'addClass';

            requiredMethod(requiredFields);

            $fieldSet[classMethod](opts.hiddenClass);

            $.publish('plugin/opcRegister/onCheckChangeShipping', [me, isChecked]);
        },

        /**
         * Called when another country was selected in the country selection.
         * Triggers additional classes depending on the selection.
         *
         * @public
         * @method onCountryChanged
         * @param {jQuery.Event} event
         */
        onCountryChanged: function (event) {
            var me = this,
                $select = $(event.currentTarget),
                countryId = $select.val(),
                addressType = $select.attr('data-address-type'),
                $stateContainers;

            $.publish('plugin/swRegisterOpc/onCountryChangedBefore', [ me, event, countryId, addressType ]);

            me.resetStateSelections(addressType);
            $stateContainers = me.$stateContainers.filter('[data-address-type="' + addressType + '"]');

            // if there is no address type defined or no targets are found, fall back to all state containers
            if ($stateContainers.length === 0) {
                $stateContainers = me.$stateContainers;
            }

            $stateContainers = $stateContainers.filter('[data-country-id="' + countryId + '"]');

            if ($stateContainers.length) {
                $stateContainers.removeClass(me.opts.hiddenClass);
                $select = $stateContainers.find('select');
                $select.removeAttr('disabled');
            }

            $.publish('plugin/swRegisterOpc/onCountryChanged', [ me, event, countryId, addressType ]);
        },

        /**
         * Called every time the country selection changes. This method disables and hides all state selections
         * to prevent sending invalid data. The caller method needs to make sure, that the correct
         * state selection gets activated and shown again.
         *
         * @public
         * @method resetStateSelections
         * @param {String} addressType
         */
        resetStateSelections: function (addressType) {
            var me = this,
                $select,
                $stateContainers,
                $stateContainer;

            $stateContainers = me.$stateContainers.filter('[data-address-type="' + addressType + '"]');
            if ($stateContainers.length === 0) {
                $stateContainers = me.$stateContainers;
            }

            $.each($stateContainers, function(index, stateContainer) {
                $stateContainer = $(stateContainer);
                $select = $stateContainer.find('select');
                $select.attr('disabled', 'disabled');

                $stateContainer.addClass(me.opts.hiddenClass);
            });
        },

        /**
         * Called when another payment method was selected.
         * Depending on the selection, the payment field set will be toggled.
         *
         * @public
         * @method onPaymentChanged
         */
        onPaymentChanged: function () {
            var me = this,
                opts = me.opts,
                inputClass = opts.inputSelector,
                hiddenClass = opts.hiddenClass,
                inputSelector = opts.paymentInputSelector,
                paymentSelector = opts.paymentFieldSelector,
                requiredMethod,
                $fieldSet,
                isChecked,
                radio,
                $el;

            // Nicht ausführen auf ShippingPayment Seite
            if ($('.is--act-shippingpayment').length) {
                return;
            }

            $.each(me.$paymentMethods, function (index, el) {
                $el = $(el);

                radio = $el.find(inputSelector);
                if (radio == undefined || radio[0] == undefined) {
                    return;
                }
                isChecked = radio[0].checked;

                requiredMethod = (isChecked) ? me.setHtmlRequired : me.removeHtmlRequired;

                requiredMethod($el.find(inputClass));

                $fieldSet = $el.find(paymentSelector);
                $fieldSet[((isChecked) ? 'removeClass' : 'addClass')](hiddenClass);
            });

            $.publish('plugin/opcRegister/onPaymentChanged', me);
        },

        /**
         * Will be called when the submit button was clicked.
         * Loops through all input fields and checks if they have a value.
         * When no value is available, the field will be marked with an error.
         *
         * @public
         * @method onSubmitBtn
         */
        onSubmitBtn: function () {
            var me = this,
                $input;
            me.$inputs.each(function () {
                $input = $(this);

                if (!$input.val()) {
                    me.setFieldAsError($input);
                }
            });

            $.publish('plugin/opcRegister/onSubmitButton', me);
        },

        /**
         * Called when a input field lost its focus.
         * Depending on the elements id, the corresponding method will be called.
         * billing ust id, emails and passwords will be validated via AJAX.
         *
         * @public
         * @method onValidateInput
         * @param {jQuery.Event} event
         */
        onValidateInput: function (event) {
            var me = this,
                $el = $(event.target),
                id = $el.attr('id'),
                action,
                relatedTarget = event.relatedTarget || document.activeElement;

            me.$targetElement = $(relatedTarget);

            switch (id) {
                case 'register_personal_email':
                case 'register_personal_emailConfirmation':
                    action = 'ajax_validate_email';
                    break;
                case 'register_billing_ustid':
                    action = 'ajax_validate_billing';
                    break;
                case 'register_personal_password':
                case 'register_personal_passwordConfirmation':
                    action = 'ajax_validate_password';
                    break;
                default:
                    break;
            }

            if (!$el.val() && $el.attr('required')) {
                me.setFieldAsError($el);
            } else if ($el.attr('type') === 'checkbox' && !$el.is(':checked')) {
                me.setFieldAsError($el);
            } else if (action) {
                me.validateUsingAjax($el, action);
            } else {
                me.setFieldAsSuccess($el);
            }

            $.publish('plugin/swRegister/onValidateInput', [ me, event, action ]);
        },

        /**
         * Adds additional attributes to the given elements to indicate
         * the elements to be required.
         *
         * @private
         * @method setHtmlRequired
         * @param {jQuery} $elements
         */
        setHtmlRequired: function ($elements) {
            $elements.attr({
                'required': 'required',
                'aria-required': 'true'
            });

            $.publish('plugin/opcRegister/onSetHtmlRequired', [this, $elements]);
        },

        /**
         * Removes addition attributes that indicate the input as required.
         *
         * @public
         * @method removeHtmlRequired
         * @param {jQuery} $inputs
         */
        removeHtmlRequired: function ($inputs) {
            $inputs.removeAttr('required aria-required');

            $.publish('plugin/opcRegister/onRemoveHtmlRequired', [this, $inputs]);
        },

        /**
         * Adds the defined error class to the given field or calls the
         * setError() method of the selectboxReplacement plugin if its
         * registered on the element.
         *
         * @public
         * @method setFieldAsError
         * @param {jQuery} $el
         */
        setFieldAsError: function ($el) {
            var me = this,
                plugin;

            if ($el.data('plugin_swSelectboxReplacement') && $el.data('plugin_swSelectboxReplacement').length && (plugin = $el.data('plugin_swSelectboxReplacement'))) {
                plugin.setError();
            } else {
                $el.addClass(me.opts.errorClass);
            }

            $.publish('plugin/opcRegister/onSetFieldAsError', [me, $el]);
        },

        /**
         * Removes the defined error class from the given field.
         *
         * @public
         * @method setFieldAsSuccess
         * @param {jQuery} $el
         */
        setFieldAsSuccess: function ($el) {
            var me = this;

            $el.removeClass(me.opts.errorClass);

            $.publish('plugin/swRegister/onSetFieldAsSuccess', [ me, $el ]);
        },

        /**
         * Sends an ajax request to validate a given field server side.
         *
         * @public
         * @method validateUsingAjax
         * @param {jQuery} $input
         * @param {String} action
         */
        validateUsingAjax: function ($input, action) {
            var me = this,
                data = 'action=' + action + '&' + me.$el.find('form').serialize(),
                URL = window.controller.ajax_validate + '/' + action;

            if (!URL) {
                return;
            }

            $.publish('plugin/opcRegister/onValidateBefore', [me, data, URL]);

            $.ajax({
                'data': data,
                'type': 'post',
                'dataType': 'json',
                'url': URL,
                'success': $.proxy(me.onValidateSuccess, me, action, $input)
            });
        },

        /**
         * This method gets called when the server side validation request
         * was successfully called. Updates the corresponding fields
         * and adds/removes error messages.
         *
         * @public
         * @method onValidateSuccess
         * @param {String} action
         * @param {jQuery} $input
         * @param {Object} result
         */
        onValidateSuccess: function (action, $input, result) {
            var me = this,
                isError,
                errorMessages = [],
                skipEmailConfirmationError = me.$targetElement.attr('name') == me.$personalEmailConfirmation.attr('name') && typeof me.$personalEmailConfirmation.val() === 'undefined',
                skipPasswordConfirmationError = me.$targetElement.attr('name') == me.$personalPasswordConfirmation.attr('name') && typeof me.$personalPasswordConfirmation.val() === 'undefined';

            $('#' + action + '--message').remove();

            if (!result) {
                return;
            }

            if (skipEmailConfirmationError) {
                result['emailConfirmation'] = false;
            } else if (skipPasswordConfirmationError) {
                result['passwordConfirmation'] = false;
            }

            for (var key in result) {
                //fields with `false` are now valid
                isError = result[key] ? true : false;

                if (!isError) {
                    continue;
                }

                if (key == 'emailConfirmation' && skipEmailConfirmationError) {
                    result[key] = false;
                    continue;
                } else if (key == 'passwordConfirmation' && skipPasswordConfirmationError) {
                    result[key] = false;
                    continue;
                }

                if ($input.attr('name') == me.$personalEmailConfirmation.attr('name') || $input.attr('name') == me.$personalGuest.attr('name')) {
                    $input = me.$personalEmail;
                } else if ($input.attr('name') == me.$personalPasswordConfirmation.attr('name')) {
                    $input = me.$personalPassword;
                }

                errorMessages.push(result[key]);
            }

            if (result) {
                me.updateFieldFlags(result);
            }

            if (errorMessages && errorMessages.length) {
                $('<div>', {
                    'html': '<p>' + errorMessages.join('<br/>') + '</p>',
                    'id': action + '--message',
                    'class': me.opts.errorMessageClass
                }).insertAfter($input);

                me.setFieldAsError($input);
            }

            $.publish('plugin/opcRegister/onValidateSuccess', [ me, $input ]);
        },

        /**
         * Loops through all flags and updates the error/success status
         * of the corresponding elements.
         *
         * @public
         * @method updateFieldFlags
         * @param {Object} flags
         */
        updateFieldFlags: function (flags) {
            var me = this,
                $el = me.$el,
                keys = Object.keys(flags),
                len = keys.length,
                i = 0,
                flag,
                $input;

            for (; i < len; i++) {
                flag = keys[i];
                $input = $el.find('.' + flag);

                if (flags[flag]) {
                    me.setFieldAsError($input);
                    continue;
                }

                me.setFieldAsSuccess($input);
            }

            $.publish('plugin/opcRegister/onUpdateFields', [me, flags]);
        },

        /**
         * Destroys the initialized plugin completely, so all event listeners will
         * be removed and the plugin data, which is stored in-memory referenced to
         * the DOM node.
         *
         * @public
         * @method destroy
         */
        destroy: function () {
            me.$el.off('change', me.opts.shippingPaymentRadioSelector);
            this._destroy();
        }
    });

    $(document).ready(function () {
        if ($('.is--ctl-premsonepagecheckout').length || $('.is--ctl-checkout').length) {
           $(document).premsOnePageCheckout();
        }
    })
}(jQuery));
