{block name='frontend_checkout_confirm_product_table'}
  <div class="product--table">
    <div class="panel has--border">
      {* Basket items *}
      {block name='frontend_checkout_confirm_item_outer'}
        {foreach $sBasket.content as $sBasketItem}
          {block name='frontend_checkout_confirm_item'}
            {include file='frontend/checkout/includes/confirm_item.tpl' isLast=$sBasketItem@last}
          {/block}
        {/foreach}
      {/block}

      {block name='frontend_checkout_confirm_item_after'}{/block}

      {if !$premsOnePageCheckoutVoucherOnTop}
        {block name='frontend_opc_articles_and_order_voucher_on_top'}
          {include file='frontend/checkout/includes/additional_features.tpl'}
        {/block}
      {/if}

      {if $useBraintree}
        {block name='frontend_opc_articles_and_order_use_braintree'}
          <form method="post" action="" class="cwbbraintreecwsw-payment-form" id="cwbbraintreecwsw-payment-form" style="display: none;">
            {include file="frontend/checkout/cwbbraintreecwsw/authorization/formContent.tpl"}
          </form>
        {/block}
      {/if}
      {if $useCwbStripe}
        {block name='frontend_opc_articles_and_order_use_stripe'}
          <form method="post" action="" class="cwbstripecwsw-payment-form" id="cwbstripecwsw-payment-form" style="display: none;">
            <div id="cwbstripecwsw-agb-error-message" data-error-message=" {$agbErrorMessage} "style="display: none;"></div>
            {include file="frontend/checkout/cwbstripecwsw/authorization/formContent.tpl"}
          </form>
        {/block}
      {/if}

      {block name='frontend_opc_customweb_payengine3cw'}
            {* Customweb Payengine3Cw *}
            {if $visibleFieldsUrl && strstr($visibleFieldsUrl, 'CwbPayEngine3CwCheckout')}
                <form method="post" action="" class="cwbpayengine3cw-payment-form" id="cwbpayengine3cw-payment-form" style="display: none;">
                    {include file="frontend/checkout/cwbpayengine3cw/authorization/formContent.tpl"}
                </form>
            {/if}
      {/block}

      {* Table footer *}
      {block name='frontend_checkout_confirm_confirm_footer'}
        {if $sUserLoggedIn || !$premsShowNoConfirmFooterBeforeLogin}
          {include file="frontend/checkout/confirm_footer.tpl"}
        {/if}
      {/block}

      {if !$premsAgbOnTop}
        {block name='frontend_opc_articles_and_order_agb_bottom'}
            {include file='frontend/checkout/includes/agb_and_revocation.tpl'}
        {/block}
      {else}
        <div class="opc--spacer"></div>
      {/if}
    </div>

    {* Table actions *}
    {block name='frontend_checkout_confirm_confirm_table_actions'}
      {if $unzerPaymentFrame}
        {block name='frontend_opc_articles_and_order_use_unzer_payment_frame'}
          {include file="frontend/unzer_payment/checkout/confirm.tpl"}
        {/block}
      {/if}

      {if $hasHeidelpayFrame || $heidelpayFrame}
        {block name='frontend_opc_articles_and_order_use_heidelpay_frame'}
          {include file="frontend/heidelpay/checkout/confirm.tpl"}
        {/block}
      {/if}

      {block name='frontend_opc_articles_and_order_actions_bottom'}
        <div class="table--actions actions--bottom">
          <div class="main--actions">
            {if $sLaststock.hideBasket}
              {block name='frontend_checkout_confirm_stockinfo'}
                {s namespace='frontend/checkout/confirm' name="ConfirmErrorStock" assign="snippetConfirmErrorStock"}{/s}
                {include file="frontend/_includes/messages.tpl" type="error" content=$snippetConfirmErrorStock}
              {/block}
            {elseif ($invalidBillingAddress || $invalidShippingAddress)}
              {block name='frontend_checkout_confirm_addressinfo'}
                {s namespace='frontend/checkout/confirm' name="ConfirmErrorInvalidAddress" assign="snippetConfirmErrorInvalidAddress"}{/s}
                {include file="frontend/_includes/messages.tpl" type="error" content=$snippetConfirmErrorInvalidAddress}
              {/block}
            {else}
              {* Only load this area after user login, because otherwise new PayPalUnified V.6.0.0 plugin will try to load his button and destroy login/register at checkout *}
              {if $sUserLoggedIn}
                  {block name='frontend_checkout_confirm_submit'}
                    {* Submit order button *}
                    {if $sPayment.embediframe || $sPayment.action}
                      <button type="submit" class="btn is--primary is--large right is--icon-right" form="confirm--form" data-preloader-button="true">
                        {s namespace='frontend/checkout/confirm' name='ConfirmDoPayment'}{/s}<i class="icon--arrow-right"></i>
                      </button>
                    {else}
                      <button type="submit" class="btn is--primary is--large right is--icon-right" form="confirm--form" data-preloader-button="true">
                        {s namespace='frontend/checkout/confirm' name='ConfirmActionSubmit'}{/s}<i class="icon--arrow-right"></i>
                      </button>
                    {/if}
                  {/block}
              {/if}
            {/if}
          </div>
        </div>
      {/block}
    {/block}
  </div>
{/block}

