<?php
/**
 * Shopware 4
 * Copyright © shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 */
class Shopware_Controllers_Frontend_SwagETracker extends Enlight_Controller_Action
{

	/**
	 * Disable front plugins
	 */
	public function init()
	{
		Shopware()->Plugins()->Controller()->ViewRenderer()->setNoRender();
	}

	/**
	 * Method to read out needed article-information on the checkout-cart when the user wants to remove a product from the basket.
	 */
	public function getArticleInfoAction()
	{
		$basketId = $this->Request()->getParam('basketId');
		if(intval($basketId) == 0) {
		    return;
        }

        $useArticleNumber = false;
        $useArticleNumberParam = $this->Request()->getParam('useArticleNumber');
        if($useArticleNumberParam === 'true') {
            $useArticleNumber = true;
        }

        /** @var \Shopware\Models\Order\Basket $repo */
        $repo = Shopware()->Models()->getRepository('Shopware\Models\Order\Basket')->find($basketId);
        if($repo !== null && $repo->getMode() == 0) {
            // "normaler" Artikel
            $sArticle = Shopware()->Modules()->Articles()->sGetArticleById($repo->getArticleId());
            $article['id'] = $useArticleNumber ? $repo->getOrderNumber() : strval($sArticle['articleID']);
            $article['name'] = $sArticle['articleName'];
            $path = Shopware()->Models()->getRepository('Shopware\Models\Category\Category')->getPathById($sArticle['categoryID'], 'name', '$$');
            if(is_string($path)) {
                $categoryPath = $path;
            } else if (is_array($path)) {
                $categoryPath = implode('$$', array_chunk($path, 4)[0]);
            }
            $article['category'] = explode('$$', $categoryPath);
            $article['price'] = str_replace(',', '.', $repo->getPrice());
            $article['currency'] = Shopware()->Shop()->getCurrency()->getCurrency();
            // Equals supplier
            $article['pro_name'] = $sArticle['supplierName'];

            $this->Response()->setHeader('Content-type', 'application/json', true);
            echo json_encode($article);
        }
	}
}