<?php
/**
 * Shopware 4
 * Copyright © shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 */
namespace Shopware\CustomModels\etracker;

use Shopware\Components\Model\ModelEntity;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="s_etracker_areas")
 */
class Area extends ModelEntity
{
	/**
	 * @var integer $id
	 *
	 * @ORM\Id
	 * @ORM\Column(type="integer")
	 * @ORM\GeneratedValue(strategy="IDENTITY")
	 */
	private $id;

	/**
	 * @var integer $storeId
	 *
	 * @ORM\Column(name="store_id", type="integer", nullable=false)
	 */
	private $storeId;

	/**
	 * @var string $name
	 *
	 * @ORM\Column(name="name", type="string", nullable=false)
	 */
	private $name;

	/**
	 * @var integer $divisionId
	 *
	 * @ORM\Column(name="division_id", type="integer", nullable=false)
	 */
	private $divisionId;

	/**
	 *
	 * @var \Shopware\CustomModels\etracker\Division $division
	 * @ORM\OneToOne(targetEntity="Shopware\CustomModels\etracker\Division")
	 * @ORM\JoinColumn(name="division_id", referencedColumnName="id")
	 */
	private $division;

	/**
	 * @var ArrayCollection
	 *
	 * @ORM\ManyToMany(targetEntity="Shopware\Models\Category\Category")
	 * @ORM\JoinTable(name="s_etracker_areas_categories",
	 *      joinColumns={
	 *          @ORM\JoinColumn(name="area_id", referencedColumnName="id")
	 *      },
	 *      inverseJoinColumns={
	 *          @ORM\JoinColumn(name="category_id", referencedColumnName="id")
	 *      }
	 * )
	 */
	private $categories;

	/**
	 * @var ArrayCollection
	 *
	 * @ORM\ManyToMany(targetEntity="Shopware\Models\Shop\Shop")
	 * @ORM\JoinTable(name="s_etracker_areas_shops",
	 *      joinColumns={
	 *          @ORM\JoinColumn(name="area_id", referencedColumnName="id")
	 *      },
	 *      inverseJoinColumns={
	 *          @ORM\JoinColumn(name="shop_id", referencedColumnName="id")
	 *      }
	 * )
	 */
	private $shops;

	/**
	 * @var ArrayCollection
	 *
	 * @ORM\ManyToMany(targetEntity="Shopware\CustomModels\etracker\Controller")
	 * @ORM\JoinTable(name="s_etracker_areas_controllers",
	 *      joinColumns={
	 *          @ORM\JoinColumn(name="area_id", referencedColumnName="id")
	 *      },
	 *      inverseJoinColumns={
	 *          @ORM\JoinColumn(name="controller_id", referencedColumnName="id")
	 *      }
	 * )
	 */
	private $controllers;

	public function __construct()
	{
		$this->categories = new ArrayCollection();
		$this->controllers = new ArrayCollection();
		$this->shops = new ArrayCollection();
	}
	/**
	 * @return int
	 */
	public function getId()
	{
		return $this->id;
	}

	/**
	 * @param int $storeId
	 * @return $this
	 */
	public function setStoreId($storeId)
	{
		$this->storeId = $storeId;
		return $this;
	}

	/**
	 * @return int
	 */
	public function getStoreId()
	{
		return $this->storeId;
	}

	/**
	 * @param \Shopware\CustomModels\etracker\Division $division
	 * @return $this
	 */
	public function setDivision($division)
	{
		$this->division = $division;
		return $this;
	}

	/**
	 * @return \Shopware\CustomModels\etracker\Division
	 */
	public function getDivision()
	{
		return $this->division;
	}

	/**
	 * @param string $name
	 * @return $this
	 */
	public function setName($name)
	{
		$this->name = $name;
		return $this;
	}

	/**
	 * @return string
	 */
	public function getName()
	{
		return $this->name;
	}

	/**
	 * @param int $divisionId
	 * @return $this
	 */
	public function setDivisionId($divisionId)
	{
		$this->divisionId = $divisionId;
		return $this;
	}

	/**
	 * @return int
	 */
	public function getDivisionId()
	{
		return $this->divisionId;
	}


	/**
	 * @param \Doctrine\Common\Collections\ArrayCollection $categories
	 * @return $this
	 */
	public function setCategories($categories)
	{
		$this->categories = $categories;
		return $this;
	}

	/**
	 * @return \Doctrine\Common\Collections\ArrayCollection
	 */
	public function getCategories()
	{
		return $this->categories;
	}

	/**
	 * @param \Shopware\Models\Category\Category $category
	 */
	public function addCategory(\Shopware\Models\Category\Category $category)
	{
		$this->categories->add($category);
	}

	/**
	 * @param \Doctrine\Common\Collections\ArrayCollection $controllers
	 * @return $this
	 */
	public function setControllers($controllers)
	{
		$this->controllers = $controllers;
		return $this;
	}

	/**
	 * @return \Doctrine\Common\Collections\ArrayCollection
	 */
	public function getControllers()
	{
		return $this->controllers;
	}

	/**
	 * @param Controller $controller
	 */
	public function addController(Controller $controller)
	{
		$this->controllers->add($controller);
	}

	/**
	 * @param \Doctrine\Common\Collections\ArrayCollection $shops
	 * @return $this
	 */
	public function setShops($shops)
	{
		$this->shops = $shops;
		return $this;
	}

	/**
	 * @return \Doctrine\Common\Collections\ArrayCollection
	 */
	public function getShops()
	{
		return $this->shops;
	}

	/**
	 * @param \Shopware\Models\Shop\Shop $shop
	 */
	public function addShop(\Shopware\Models\Shop\Shop $shop)
	{
		$this->shops->add($shop);
	}

}