<?php
/**
 * Shopware 4
 * Copyright © shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 */
namespace Shopware\CustomModels\etracker;

use Shopware\Components\Model\ModelEntity;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="s_etracker_configs")
 */
class Config extends ModelEntity
{
	/**
	 * @var integer $id
	 *
	 * @ORM\Id
	 * @ORM\Column(type="integer")
	 * @ORM\GeneratedValue(strategy="IDENTITY")
	 */
	private $id;

	/**
	 * @var integer $storeId
	 *
	 * @ORM\Column(name="store_id", type="integer", nullable=false)
	 */
	private $storeId;

	/**
	 * @var string $accountKey
	 *
	 * @ORM\Column(name="account_key", type="string", nullable=false)
	 */
	private $accountKey;

	/**
	 * @var string $customAttributes
	 *
	 * @ORM\Column(name="custom_attributes", type="string", nullable=false)
	 */
	private $customAttributes;

    /**
     * @var string $customTrackingDomain
     *
     * @ORM\Column(name="custom_tracking_domain", type="string", nullable=false)
     */
    private $customTrackingDomain;

	/**
	 * @var integer $useNetPrice
	 *
	 * @ORM\Column(name="net_price", type="integer", nullable=false)
	 */
	private $useNetPrice;

    /**
     * @var boolean $useArticleNumber
     *
     * @ORM\Column(name="use_article_number", type="boolean", nullable=false)
     */
    private $useArticleNumber;

	/**
	 * @var boolean $ownPageNames
	 *
	 * @ORM\Column(name="own_page_names", type="boolean", nullable=false)
	 */
	private $ownPageNames = true;

    /**
     * @var boolean $hasSignalizeEnabled
     *
     * @ORM\Column(name="has_signalize_enabled", type="boolean", nullable=false)
     */
    private $hasSignalizeEnabled;

    /**
	 * @var integer $shopwareDefault
	 *
	 * @ORM\Column(name="shopware_default", type="integer", nullable=false)
	 */
	private $shopwareDefault;

	/**
	 * @var string $ownSchema
	 *
	 * @ORM\Column(name="own_schema", type="string", nullable=false)
	 */
	private $ownSchema = false;

	/**
	 * @var integer $divideAreas
	 *
	 * @ORM\Column(name="divide_areas", type="integer", nullable=false)
	 */
	private $divideAreas;

	/**
	 * @return int
	 */
	public function getId()
	{
		return $this->id;
	}

	/**
	 * @param int $storeId
	 * @return $this
	 */
	public function setStoreId($storeId)
	{
		$this->storeId = $storeId;
		return $this;
	}

	/**
	 * @return int
	 */
	public function getStoreId()
	{
		return $this->storeId;
	}


	/**
	 * @param string $accountKey
	 * @return $this
	 */
	public function setAccountKey($accountKey)
	{
		$this->accountKey = $accountKey;
		return $this;
	}

	/**
	 * @return string
	 */
	public function getAccountKey()
	{
		return $this->accountKey;
	}

	/**
	 * @param string $customAttributes
	 * @return $this
	 */
	public function setCustomAttributes($customAttributes)
	{
		$this->customAttributes = $customAttributes;
		return $this;
	}

	/**
	 * @return string
	 */
	public function getCustomAttributes()
	{
		return $this->customAttributes;
	}

    /**
     * @param string $customTrackingDomain
     * @return $this
     */
    public function setCustomTrackingDomain($customTrackingDomain)
    {
        $this->customTrackingDomain = $customTrackingDomain;
        return $this;
    }

    /**
     * @return string
     */
    public function getCustomTrackingDomain()
    {
        $domain = $this->customTrackingDomain;
        if(strpos($domain, '//')  !== false)
        {
            return $domain;
        }
        return $domain ? '//' . $domain : null;
    }

	/**
	 * @param int $useNetPrice
	 * @return $this
	 */
	public function setUseNetPrice($useNetPrice)
	{
		$this->useNetPrice = $useNetPrice;
		return $this;
	}

	/**
	 * @return int
	 */
	public function getUseNetPrice()
	{
		return $this->useNetPrice;
	}

    /**
     * @param boolean $useArticleNumber
     * @return $this
     */
    public function setUseArticleNumber($useArticleNumber)
    {
        $this->useArticleNumber = $useArticleNumber;
        return $this;
    }

    /**
     * @return boolean
     */
    public function getUseArticleNumber()
    {
        return $this->useArticleNumber;
    }

	/**
	 * @param boolean $ownPageNames
	 * @return $this
	 */
	public function setOwnPageNames($ownPageNames)
	{
		$this->ownPageNames = $ownPageNames;
		return $this;
	}

    /**
	 * @return boolean
	 */
	public function getOwnPageNames()
	{
		return $this->ownPageNames;
	}

    /**
     * @param boolean $hasSignalizeEnabled
     * @return $this
     */
    public function setHasSignalizeEnabled($hasSignalizeEnabled)
    {
        $this->hasSignalizeEnabled = $hasSignalizeEnabled;
        return $this;
    }

    /**
     * @return boolean
     */
    public function hasSignalizeEnabled()
    {
        return $this->hasSignalizeEnabled;
    }

    /**
	 * @param string $ownSchema
	 * @return $this
	 */
	public function setOwnSchema($ownSchema)
	{
		$this->ownSchema = $ownSchema;
		return $this;
	}

	/**
	 * @return string
	 */
	public function getOwnSchema()
	{
		return $this->ownSchema;
	}

	/**
	 * @param int $divideAreas
	 * @return $this
	 */
	public function setDivideAreas($divideAreas)
	{
		$this->divideAreas = $divideAreas;
		return $this;
	}

	/**
	 * @return int
	 */
	public function getDivideAreas()
	{
		return $this->divideAreas;
	}

	/**
	 * @param integer $shopwareDefault
	 * @return $this
	 */
	public function setShopwareDefault($shopwareDefault)
	{
		$this->shopwareDefault = $shopwareDefault;
		return $this;
	}

	/**
	 * @return integer
	 */
	public function getShopwareDefault()
	{
		return $this->shopwareDefault;
	}
}