# SwagETracker

Dieses Plugin bietet die Möglichkeit das Tracking System "etracker" (www.etracker.com) an Shopware anzubinden.

# 1 Konfiguration
## 1.1 Account-Schlüssel
Zur Konfiguration wird lediglich ein Account-Key von etracker selbst benötigt.
Diesen findet man in der Account-Übersicht unter Einstellungen > Setup/Tracking Code.

## 1.2 Eigene Seitennamen nutzen
Sofern man diesen Haken nicht setzt, listet etracker alle Seiten lediglich anhand der URL auf.
Zur besseren Unterscheidung der Seiten kann daher ein eigener Seitenname vergeben werden.

### 1.2.1 Shopware-Standard benutzen
Die erste Wahl "Shopware-Standard benutzen" lässt automatisch die Seitennamen anhand des Schemas "controller_action_custom_(Id: id)"
erstellen.

"Controller" wird durch den derzeitigen Controller ersetzt, "Action" durch die derzeitig ausgeführte Action.
"Custom" beinhaltet einen individuellen Namen, so bspw. auf der Artikelseite der Name des Artikels, in einer Kategorie wäre dies der Kategorie-Name oder ggf. die Blog-Überschrift.
Der Wert "id" beinhaltet, sofern vorhanden, die ID des Artikels, der Kategorie, des Blogs usw.
Sofern keine ID vorhanden ist, beispielsweise auf der Account-Seite, wird nichts zurückgegeben.

### 1.2.2 Eigenes Schema benutzen
Die zweite Option "Eigenes Schema benutzen" aktiviert das Feld "Schema".
Dort kann man selbst definieren nach welchem Muster die Seiten unterschieden werden sollen.
Hier kann also bspw. das Muster "name_%custom%;id_%Id%" benutzt werden, sodass die Seitennamen in diesem Beispiel
so unterschieden werden: "name_Strandtuch Blau;id_133".
Mögliche Werte bisher sind %controller%, %action%, %custom% und %id%.

## 1.3 Bereiche einteilen
etracker bietet die Möglichkeit die Seiten nach Bereichen einzuteilen.
Es gibt keine genaue Definition, was ein Bereich ist.
So kann ein Bereich ein ganzer Subshop sein, aber auch jede einzelne Detailseite kann ein eigener Bereich sein.
Die Definition soll dem Benutzer überlassen werden.

### 1.3.1 Controller
Hier werden die Bereiche simpel nach Controller eingeteilt.
Dies bedeutet, dass alle Artikel-Detailseiten als ein Bereich zählen, alle Kategorien zählen als ein Bereich, die Account-Seite, die Index-Seite, ... und so weiter.

### 1.3.2 Kategorien
Bei dieser Option wird die Seite lediglich zwischen den Kategorien entschieden.
Jede Kategorie stellt somit einen eigenen Bereich da.
Alle anderen Seiten, wie bspw. die Account-Seite, sind somit keinem Bereich zugeordnet.

### 1.3.3 Shops
Es ist so simpel wie es scheint. In diesem Fall zählt jeder (Sub-)Shop als eigener Bereich.

### 1.3.4 Eigene Bereiche
Um dem Benutzer noch mehr Möglichkeiten an die Hand zu reichen die Bereiche selbst und individuell zu gestalten, bieten wir diese Option an.
Beim Klick auf diese Option wird der Tab "Bereiche" aktiviert.
Dort kann man nun beliebig viele Bereiche erstellen und gestalten.

Bei einem Klick auf "Hinzufügen" öffnet sich ein neues Fenster zur Erstellung eines neuen Bereichs.
Zunächst vergeben wir hier einen Namen für den Bereich, der später in etracker auftauchen soll.
Als Beispiel wählen wir hier "Artikel-Detailseite", um alle Artikel-Detailseiten einem Bereich zu zuordnen.
In dem Feld "Einteilung in" wählen wir nun "Controller" aus, da die Detailseite dem Controller "detail" angehört.
Ein kleiner Klick auf "Speichern" und der Bereich wird gespeichert, jedoch noch ohne eine Zuweisung ein
Dem Bereich sind nun aber noch keine Controller zugewiesen, daher klicken wir noch einmal auf den Stift zum Bearbeiten des Bereichs.
Nun ist auch der untere Teil des Fensters verfügbar.
Wir können uns nun alle Controller auflisten lassen, indem wir simpel auf den Pfeil des Dropdowns klicken.
Alternativ bietet das Dropdown auch eine Suche an.
Bereits bei der Eingabe von "Det" bekommen wir den gewünschen Controller angezeigt.
Wir wählen "Detail" aus und klicken anschließend auf "Hinzufügen", um diesen Controller dem Bereich "Artikel-Detailseite" zu zuweisen.
Wir können jetzt noch beliebig viele Controller diesem Bereich zuweisen, bspw. alle Blog-Artikel sollen ebenfalls in diesen Bereich fallen.
In diesem Fall würden wir noch den Controller "Blog" hinzufügen.
Sofern wir dem Bereich keinen einzigen Controller zuweisen, zählen alle Controller zu diesem Bereich.

Wir können nun noch beliebig viele andere Bereiche erstellen, die bspw. die verschiedenen Kategorien einem Bereich zuweisen.
Auch hier gilt: Ist keine Kategorie zugewiesen zählen alle Kategorien zu dem Bereich.

Bei der Auswahl "Einteilung nach Shops" werden lediglich Subshops angezeigt, da Hauptshops bereits über eine eigene Konfiguration verfügen und komplette eigene Bereiche besitzen können.

## 1.4 Landing-Page ID
In etracker lassen sich sogenannte Kampagnen erstellen.
Dabei erhält der Benutzer eine ID für diese Kampagne von etracker, die er auf seiner Landingpage, die der Kampagne zugeordnet werden soll, einbauen muss.
Dazu gibt es in dem Einkaufswelten-Modul ein neues Feld "etracker Landingpage ID".
Dort muss entsprechend lediglich die ID, die wir von etracker erhalten, eingetragen werden.

# 2 Weitere nicht einstellbare Funktionen
Alle hier genannten Funktionen laufen versteckt im Hintergrund ab.
In zukünftigen Updates werden diese ggf. voll konfigurierbar sein.

## 2.1 Warenkorbanalyse
Zur Analyse der Warenkörbe wird jedes Mal auf der Bestellbestätigungs-Seite der Warenkorb an etracker übergeben.

## 2.2 Sonstiges
etracker bietet von sich aus Funktionen an, die nur auf der etracker-Seite selbst eingestellt werden können.
So beispielsweise die Umfragen, die natürlich auch nicht unterbunden werden.

# 3 Hinweise

## 3.1 Alle relevanten Controller
Folgende relevante Frontend-Controller existieren derzeit in Shopware:
Account - Der Account-Bereich
Blog - Alle Blog-Artikel
Campaign - Alle Einkaufswelten-Landingpages gehören zu diesem Controller
Checkout - Der Bestellprozess wird über diesen Controller abgedeckt, vom Warenkorb bis zur eigentlichen Bestellung
Compare - Der Artikel-Vergleich
Custom - Alle Seiten, die im Backend unter "Shopseiten" eingestellt worden sind laufen unter diesem Controller
Detail - Die Artikel-Detailseite
Forms - Alle Formulare, die im Backend unter "Formulare" existieren
Index - Die Startseite
Listing - Die Kategorien werden von diesem Controller abgedeckt
Newsletter - Die Newsletter-Anmeldung
Note - Der Merkzettel
Register - Die Registrierung
Search - Die eigentliche Artikelsuche im Frontend
Sitemap - Die Sitemap
Tellafriend - Die Weitersagen-Seite eines Artikels
Ticket - Wird für das Ticket-System genutzt

## 3.2 Events
In etracker gibt es sogenannte Events, die man an bestimmte Aktionen hängen kann.
Die Einbindung der Events, die sehr individuell sein können, ist dabei jedem Kunden selbst überlassen und läuft über eine simple Template-Anpassung.

## 3.3 etracker-Parameter
Folgende etracker-Parameter werden verwendet:
et_pagename = Der Seitenname. Je nach Einstellung soll hier der Seitenname nach dem eigenen Schema angezeigt werden bzw. eben nach dem Muster "controller_action_custom_id". Leer, sofern keine eigenen Seitennamen benutzt werden sollen.
et_areas = Alle betroffenen Bereiche müssten hier anhand eines "," aufgelistet werden.