/**
 * Shopware 4
 * Copyright © shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 *
 * @category   Shopware
 * @package    SwagETracker
 * @subpackage Model
 * @copyright  Copyright © shopware AG (http://www.shopware.de)
 * @version    $Id$
 * @author shopware AG
 */

//{block name="backend/swag_e_tracker/model/area"}
Ext.define('Shopware.apps.SwagETracker.model.Area', {

    extend:'Ext.data.Model',

    fields: [
        //{block name="backend/swag_e_tracker/model/area/fields"}{/block}
        { name : 'id', type: 'int', useNull: true },
        { name : 'storeId', type: 'int', useNull: true },
        { name : 'name', type: 'string' },
        { name : 'divisionId', type: 'int' },
        { name : 'divisionName', type: 'string' },
        { name : 'assigned', type: 'string' }
    ],

    associations: [
        { type: 'hasMany', model: 'Shopware.apps.SwagETracker.model.Division', name: 'getDivision', associationKey: 'division' },
        { type: 'hasMany', model: 'Shopware.apps.SwagETracker.model.Category', name: 'getCategories', associationKey: 'categories' },
        { type: 'hasMany', model: 'Shopware.apps.SwagETracker.model.Shop', name: 'getShops', associationKey: 'shops' },
        { type: 'hasMany', model: 'Shopware.apps.SwagETracker.model.Controller', name: 'getControllers', associationKey: 'controllers' }
    ],

    /**
     * Configure the data communication
     * @object
     */
    proxy: {
        type: 'ajax',
        api: {
            //read out all configs
            read: '{url action="getAreas"}',
            create: '{url action="createArea"}',
            update: '{url action="updateArea"}',
            destroy: '{url action="deleteArea"}'
        },
        /**
         * Configure the data reader
         * @object
         */
        reader: {
            type: 'json',
            root: 'data',
            total: 'total'
        }
    }
});
//{/block}