/**
 * Shopware 4
 * Copyright © shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 *
 * @category   Shopware
 * @package    SwagETracker
 * @subpackage Model
 * @copyright  Copyright © shopware AG (http://www.shopware.de)
 * @version    $Id$
 * @author shopware AG
 */

//{block name="backend/swag_e_tracker/model/config"}
Ext.define('Shopware.apps.SwagETracker.model.Config', {

    extend:'Ext.data.Model',

    fields: [
        //{block name="backend/swag_e_tracker/model/config/fields"}{/block}
        { name : 'id', type: 'int', useNull: true },
        { name : 'storeId', type: 'int', useNull: true },
        { name : 'accountKey', type: 'string' },
        { name : 'customAttributes', type: 'string' },
        { name : 'customTrackingDomain', type: 'string' },
        { name : 'useNetPrice', type: 'int' },
        { name : 'useArticleNumber', type: 'boolean' },
        { name : 'ownPageNames', type: 'boolean' },
        { name : 'hasSignalizeEnabled', type: 'boolean' },
        { name : 'shopwareDefault', type: 'int' },
        { name : 'ownSchema', type: 'string' },
        { name : 'divideAreas', type: 'int' }
    ],

    associations: [
    ],

    /**
     * Configure the data communication
     * @object
     */
    proxy: {
        type: 'ajax',
        api: {
            //read out all configs
            read: '{url action="getConfig"}',
            create: '{url action="saveConfig"}',
            update: '{url action="saveConfig"}'
        },
        /**
         * Configure the data reader
         * @object
         */
        reader: {
            type: 'json',
            root: 'data'
        }
    }
});
//{/block}