/**
 * Shopware 4
 * Copyright © shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 *
 * @category   Shopware
 * @package    SwagETracker
 * @subpackage View
 * @copyright  Copyright © shopware AG (http://www.shopware.de)
 * @version    $Id$
 * @author shopware AG
 */

//{namespace name=backend/etracker/view/main}
//{block name="backend/swag_e_tracker/view/main/window"}
Ext.define('Shopware.apps.SwagETracker.view.main.Window', {
    extend: 'Enlight.app.Window',
    alias: 'widget.swagetracker-main-window',

    autoShow: true,
    height: '95%',
    title : '{s name="window_title"}etracker{/s}',
    width: 600,
    layout: 'fit',

    stateId:'etracker-main-window',

    snippets: {
        settingsTab: '{s name="view/settingsTab/title"}Settings{/s}',
        areaTab: '{s name="view/areaTab/title"}Areas{/s}'
    },

    /**
     * Initializes the component and builds up the main interface
     *
     * @return void
     */
    initComponent: function() {
        var me = this;
        var tabPanel = me.createTabPanel();

        me.items = [tabPanel];
        me.callParent(arguments);
    },

    /**
     * Creates the tabPanel
     *
     * @return [Ext.tab.Panel]
     */
    createTabPanel: function(){
        var me = this,
            tabPanel = Ext.create('Ext.tab.Panel'),
            shopStore = Ext.create('Shopware.apps.Base.store.Shop').load({
                callback: function(data, operation){
                    if(operation.success){
                        var configStore = Ext.create('Shopware.apps.SwagETracker.store.Configs').load({
                            callback: function(){
                                shopStore.each(function(shop){
                                    var storeId = shop.get('id'),
                                        configRecord = configStore.findRecord('storeId',storeId),
                                        areaStore = Ext.create('Shopware.apps.SwagETracker.store.Areas');

                                    areaStore.filter("storeId", storeId);
                                    var tab = Ext.create('Ext.container.Container', {
                                        xtype: 'container',
                                        title: shop.get('name'),
                                        shopId: storeId,
                                        layout: 'fit',
                                        items: Ext.create('Ext.tab.Panel', {
                                            items: [
                                                {
                                                    xtype: 'container',
                                                    title: me.snippets.settingsTab,
                                                    layout: 'fit',
                                                    items: {
                                                        xtype: 'swagetracker-tracker-settings',
                                                        configRecord: configRecord
                                                    }
                                                },{
                                                    xtype: 'container',
                                                    title: me.snippets.areaTab,
                                                    name: 'areaTab',
                                                    layout: 'fit',
                                                    disabled: true,
                                                    items: {
                                                        xtype: 'swagetracker-tracker-areas',
                                                        areaStore: areaStore.load()
                                                    }
                                                }
                                            ]
                                        })
                                    });
                                    tabPanel.add(tab);
                                    tabPanel.setActiveTab(0);
                                });
                            }
                        });
                    }
                }
            }
        );

        return tabPanel;
    }
});
//{/block}