/**
 * Shopware 4
 * Copyright © shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 *
 * @category   Shopware
 * @package    SwagETracker
 * @subpackage View
 * @copyright  Copyright © shopware AG (http://www.shopware.de)
 * @version    $Id$
 * @author shopware AG
 */

//{namespace name=backend/etracker/view/main}
//{block name="backend/swag_e_tracker/view/tracker/areas"}
Ext.define('Shopware.apps.SwagETracker.view.tracker.Areas', {

    /**
     * Extend from the standard ExtJS 4
     * @string
     */
    extend: 'Ext.grid.Panel',
    height: '100%',
    border: 0,

    /**
     * Alias name for the view. Could be used to get an instance
     * of the view through Ext.widget('swagetracker-tracker-areas')
     * @string
     */
    alias: 'widget.swagetracker-tracker-areas',

    snippets: {
        searchEmptyText: '{s name="view/search/emptyText"}Search{/s}',
        buttons: {
            add: '{s name="view/areaGrid/addButton"}Add area{/s}',
            remove:'{s name="view/areaGrid/removeButton"}Remove areas{/s}'
        },
        columns: {
            name: '{s name="view/areaGrid/columns/name"}Name{/s}',
            assigned: '{s name="view/areaGrid/columns/assigned"}Assigned{/s}',
            division: '{s name="view/areaGrid/columns/division"}Division into{/s}'
        },
        toolTips: {
            edit: '{s name="view/toolTips/edit"}Edit entry{/s}',
            delete: '{s name="view/toolTips/delete"}Delete entry{/s}'
        }
    },

    /**
     * This method is called when this view is initiated.
     * It handles the creation of all the important components.
     */
    initComponent: function(){
        var me = this;

        me.registerEvents();

        me.dockedItems = [];
        me.store = me.areaStore;
        me.selModel = me.getGridSelModel();
        me.columns = me.getColumns();
        me.toolbar = me.getToolbar();
        me.dockedItems.push(me.toolbar);

        // Add paging toolbar to the bottom of the grid panel
        me.dockedItems.push({
            dock: 'bottom',
            xtype: 'pagingtoolbar',
            displayInfo: true,
            store: me.store
        });

        this.callParent(arguments);
    },

    /**
     * Creates the toolbar with a save-button, a delete-button and a textfield to search for articles
     */
    getToolbar: function(){
        var me = this;
        var searchField = Ext.create('Ext.form.field.Text',{
            name : 'searchfield',
            cls : 'searchfield',
            action : 'searchArea',
            width : 170,
            enableKeyEvents : true,
            emptyText : me.snippets.searchEmptyText,
            listeners: {
                buffer: 500,
                keyup: function() {
                    if(this.getValue().length >= 3 || this.getValue().length<1) {
                        /**
                         * @param this Contains the searchfield
                         */
                        me.fireEvent('fieldChange', this, me);
                    }
                }
            }
        });
        searchField.addEvents('fieldChange');
        var items = [];

        items.push(Ext.create('Ext.button.Button',{
            iconCls: 'sprite-plus-circle',
            text: me.snippets.buttons.add,
            action: 'add'
        }));

        items.push(Ext.create('Ext.button.Button',{
            iconCls: 'sprite-minus-circle',
            text: me.snippets.buttons.remove,
            disabled: true,
            action: 'deleteMultipleAreas'
        }));

        items.push('->');
        items.push(searchField);
        items.push({
            xtype: 'tbspacer',
            width: 6
        });

        var toolbar = Ext.create('Ext.toolbar.Toolbar', {
            dock: 'top',
            ui: 'shopware-ui',
            items: items
        });
        return toolbar;
    },

    /**
     * Creates the selectionModel of the grid with a listener to enable the delete-button
     */
    getGridSelModel: function(){
        var selModel = Ext.create('Ext.selection.CheckboxModel',{
            listeners: {
                selectionchange: function(sm, selections){
                    var owner = this.view.ownerCt,
                        btn = owner.down('button[action=deleteMultipleAreas]');

                    //If no article is marked
                    if(btn){
                        btn.setDisabled(selections.length == 0);
                    }
                }
            }
        });

        return selModel;
    },

    /**
     * Defines additional events which will be
     * fired from the component
     *
     * @return void
     */
    registerEvents:function () {
        this.addEvents(

                /**
                 * Event will be fired when the user clicks the delete icon in the
                 * action column
                 *
                 * @event deleteColumn
                 * @param [object] View - Associated Ext.view.Table
                 * @param [integer] rowIndex - Row index
                 * @param [integer] colIndex - Column index
                 * @param [object] item - Associated HTML DOM node
                 */
                'deleteColumn',

                /**
                 * Event will be fired when the user clicks the edit icon in the
                 * action column
                 *
                 * @event editColumn
                 * @param [object] View - Associated Ext.view.Table
                 * @param [object] item - Associated HTML DOM node
                 * @param [integer] rowIndex - Row index
                 * @param [integer] colIndex - Column index
                 */
                'editColumn'
        );

        return true;
    },

    /**
     *  Creates the columns
     */
    getColumns: function(){
        var me = this;
        var buttons = [];

        buttons.push(Ext.create('Ext.button.Button', {
            iconCls: 'sprite-minus-circle',
            action: 'delete',
            cls: 'delete',
            tooltip: me.snippets.toolTips.delete,
            handler:function (view, rowIndex, colIndex, item) {
                me.fireEvent('deleteColumn', view, rowIndex,  item, colIndex);
            }
        }));

        buttons.push(Ext.create('Ext.button.Button', {
            iconCls: 'sprite-pencil',
            cls: 'editBtn',
            tooltip: me.snippets.toolTips.edit,
            handler:function (view, rowIndex, colIndex, item) {
                me.fireEvent('editColumn', view, item, rowIndex, colIndex);
            }
        }));

        var columns = [
            {
                header: me.snippets.columns.name,
                dataIndex: 'name',
                flex: 1
            },{
                header: me.snippets.columns.assigned,
                dataIndex: 'assigned',
                flex: 2.5
            }, {
                header: me.snippets.columns.division,
                dataIndex: 'divisionName',
                flex: 1
            },{
                xtype: 'actioncolumn',
                width: 60,
                items: buttons
            }
        ];

        return columns;
    }
});
//{/block}