/**
 * Shopware 4
 * Copyright © shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 *
 * @category   Shopware
 * @package    SwagETracker
 * @subpackage View
 * @copyright  Copyright © shopware AG (http://www.shopware.de)
 * @version    $Id$
 * @author shopware AG
 */

//{namespace name=backend/etracker/view/main}
//{block name="backend/swag_e_tracker/view/tracker/settings"}
Ext.define('Shopware.apps.SwagETracker.view.tracker.Settings', {

    /**
     * Extend from the standard ExtJS 4
     * @string
     */
    extend: 'Ext.form.Panel',
    
    cls: 'shopware-form',
    autoScroll: true,

    bodyPadding: 10,

    defaults:{
        labelWidth: 200
    },
    border: 0,

    snippets: {
        buttons: {
            cancel: '{s name="view/buttons/cancel"}Cancel{/s}',
            save: '{s name="view/buttons/save"}Save{/s}'
        },
        form: {
            accountKey: {
                fieldLabel: '{s name="view/settings/accountKey/fieldLabel"}Account-Key{/s}'
            },
            testAccount: {
                html: '{s name="view/settings/testAccount/html"}<div style="text-align: right;">30 Tage <span style="font-weight: bold;">kostenloser</span> Test: <a href="https://www.etracker.com" target="_blank">Account-Schlüssel anfordern</a></div>{/s}'
            },
            customAttributes: {
                fieldLabel: '{s name="view/settings/customAttributes/fieldLabel"}Custom attributes{/s}'
            },
            customTrackingDomain: {
                fieldLabel: '{s name="view/settings/customTrackingDomain/fieldLabel"}Custom tracking domain{/s}'
            },
            useNetPrice: {
                fieldLabel: '{s name="view/settings/useNetPrice/fieldLabel"}Use gross-prices{/s}'
            },
            useArticleNumber: {
                fieldLabel: '{s name="view/settings/useArticleNumber/fieldLabel"}Use article number{/s}'
            },
            hasSignalizeEnabled: {
                fieldLabel: '{s name="view/settings/hasSignalizeEnabled/fieldLabel"}Enable Signalize{/s}'
            },
            ownPageNames: {
                title: '{s name="view/settings/ownPageNames/title"}Use own pagenames{/s}'
            },
            shopwareDefault: {
                fieldLabel: '{s name="view/settings/shopwareDefault/fieldLabel"}Choose{/s}',
                emptyText: '{s name="view/settings/shopwareDefault/emptyText"}Please choose{/s}',
                options: {
                    shopwareDefault: '{s name="view/settings/shopwareDefault/options/shopwareDefault"}Use shopware default{/s}',
                    ownSchema: '{s name="view/settings/shopwareDefault/options/ownSchema"}Use own schema{/s}'
                }
            },
            ownSchema: {
                fieldLabel: '{s name="view/settings/ownSchema/fieldLabel"}Schema{/s}',
                emptyText: '{s name="view/settings/ownSchema/emptyText"}%controller%_%action%{/s}',
                helpText: '{s name="view/settings/ownSchema/helpText"}Possible values: %controller%, %action%, %id%, %custom%{/s}'
            },
            divideAreas: {
                fieldLabel: '{s name="view/settings/divideAreas/fieldLabel"}Divide areas into{/s}',
                emptyText: '{s name="view/settings/divideAreas/fieldLabel"}Please choose{/s}',
                options: {
                    default: '{s name="view/settings/divideAreas/options/default"}Controller{/s}',
                    controller: '{s name="view/settings/divideAreas/options/controller"}Controller{/s}',
                    categories: '{s name="view/settings/divideAreas/options/categories"}Categories{/s}',
                    shops: '{s name="view/settings/divideAreas/options/shops"}Shops{/s}',
                    ownArea: '{s name="view/settings/divideAreas/options/ownArea"}Own areas{/s}'
                }
            }
        }
    },

    /**
     * Alias name for the view. Could be used to get an instance
     * of the view through Ext.widget('swagetracker-tracker-settings')
     * @string
     */
    alias: 'widget.swagetracker-tracker-settings',

    /**
     * This method is called when this view is initiated.
     * It handles the creation of all the important components.
     */
    initComponent: function(){
        var me = this;

        me.registerEvents();

        me.dockedItems = [{
            xtype: 'toolbar',
            ui: 'shopware-ui',
            dock: 'bottom',
            cls: 'shopware-toolbar',
            items: me.createButtons()
        }];

        me.items = me.getItems();
        
        this.callParent(arguments);
    },

    /**
     * Defines additional events which will be
     * fired from the component
     *
     * @return void
     */
    registerEvents: function(){
        var me = this;

        me.addEvents(

                /**
                 * Event will be fired when the user changes the value of the area-dropdown
                 *
                 * @event changeAreaCombo
                 * @param [object] comp - The combobox, which triggered the event
                 */
                'changeAreaCombo',

                /**
                 * Event will be fired when the user changes the value of the schema-dropdown
                 *
                 * @event changeSchemaCombo
                 * @param [object] comp - The combobox, which triggered the event
                 */
                'changeSchemaCombo'
        );

        return true;
    },

    /**
     * This method creates the form-panel with every needed field(set).
     *
     * @returns Array
     */
    getItems: function(){
        var me = this,
            configForm = me.getConfigForm();

        if (me.configRecord) {
            configForm.loadRecord(me.configRecord);
        }

        return [configForm];
    },

    /**
     * Helper method to create the save-/cancel-button
     * @returns Array
     */
    createButtons: function(){
        var me = this;
        var buttons = ['->',
            {
                text: me.snippets.buttons.cancel,
                cls: 'secondary',
                scope: me,
                handler: me.destroy
            },
            {
                text: me.snippets.buttons.save,
                action:'saveConfig',
                cls:'primary'
            }
        ];

        return buttons;
    },

    /**
     * Helper method to get the config form
     * @returns Ext.form.Panel
     */
    getConfigForm: function() {
        var me = this;
        return Ext.create('Ext.form.Panel', {
            border: 0,
            items: [
                {
                    xtype: 'hidden',
                    name: 'id'
                },
                {
                    xtype: 'textfield',
                    name: 'accountKey',
                    fieldLabel: me.snippets.form.accountKey.fieldLabel,
                    labelWidth: 180,
                    anchor:'100%',
                },{
                    xtype: 'panel',
                    html: me.snippets.form.testAccount.html,
                    fieldLabel: '',
                    labelWidth: 180,
                    anchor:'100%',
                    border: 0
                }, {
                    xtype: 'textfield',
                    name: 'customAttributes',
                    fieldLabel: me.snippets.form.customAttributes.fieldLabel,
                    labelWidth: 180,
                    anchor:'100%',
                }, {
                    xtype: 'textfield',
                    name: 'customTrackingDomain',
                    fieldLabel: me.snippets.form.customTrackingDomain.fieldLabel,
                    labelWidth: 180,
                    anchor:'100%',
                },{
                    xtype: 'checkbox',
                    name: 'useNetPrice',
                    inputValue: 1,
                    uncheckedValue: 0,
                    fieldLabel: me.snippets.form.useNetPrice.fieldLabel,
                    labelWidth: 180,
                    anchor:'100%'
                },{
                    xtype: 'checkbox',
                    name: 'useArticleNumber',
                    inputValue: 1,
                    uncheckedValue: 0,
                    fieldLabel: me.snippets.form.useArticleNumber.fieldLabel,
                    labelWidth: 180,
                    anchor:'100%'
                }, {
                    xtype: 'checkbox',
                    name: 'hasSignalizeEnabled',
                    inputValue: 1,
                    uncheckedValue: 0,
                    fieldLabel: me.snippets.form.hasSignalizeEnabled.fieldLabel,
                    labelWidth: 180,
                    anchor:'100%'
                }, {
                    xtype: 'fieldset',
                    name: 'pagesFieldSet',
                    checkboxToggle: true,
                    checkboxName: 'ownPageNames',
                    title: me.snippets.form.ownPageNames.title,
                    items: me.getFieldSetItems()
                }, {
                    xtype: 'combo',
                    fieldLabel: me.snippets.form.divideAreas.fieldLabel,
                    emptyText: me.snippets.form.divideAreas.emptyText,
                    checkChangeBuffer: 1500,
                    displayField: 'name',
                    valueField: 'areaId',
                    name: 'divideAreas',
                    labelWidth: 180,
                    anchor:'100%',
                    store: Ext.create('Ext.data.Store', {
                        fields: ['areaId', 'name', 'eventField'],
                        data : [
                            { areaId: 4, name: me.snippets.form.divideAreas.options.default, eventField: 0 },
                            { areaId: 0, name: me.snippets.form.divideAreas.options.controller, eventField: 0 },
                            { areaId: 1, name: me.snippets.form.divideAreas.options.categories, eventField: 0 },
                            { areaId: 2, name: me.snippets.form.divideAreas.options.shops, eventField: 0 },
                            { areaId: 3, name: me.snippets.form.divideAreas.options.ownArea, eventField: 1 }
                        ]
                    }),
                    listeners: {
                        change: {
                            fn: function(comp){
                                me.fireEvent('changeAreaCombo', comp);
                            }
                        }
                    }
                }
            ]
        });
    },

    /**
     * Helper method to get all the items needed in the fieldset
     * @returns Array
     */
    getFieldSetItems: function(){
        var me = this;
        return [
            {
                xtype: 'combo',
                align: 'right',
                fieldLabel: me.snippets.form.shopwareDefault.fieldLabel,
                displayField: 'display',
                valueField: 'value',
                emptyText: me.snippets.form.shopwareDefault.emptyText,
                labelWidth: 180,
                inputWidth: 200,
                value: 0,
                name: 'shopwareDefault',
                store: Ext.create('Ext.data.Store', {
                    fields: ['value', 'display', 'eventField'],
                    data : [
                        { value: 0, display: me.snippets.form.shopwareDefault.options.shopwareDefault, eventField: 0 },
                        { value: 1, display: me.snippets.form.shopwareDefault.options.ownSchema, eventField: 1 }
                    ]
                }),
                listeners: {
                    change: {
                        fn: function(comp){
                            me.fireEvent('changeSchemaCombo', comp);
                        }
                    }
                }
            },{
            xtype: 'textfield',
            fieldLabel: me.snippets.form.ownSchema.fieldLabel,
            labelWidth: 180,
            emptyText: me.snippets.form.ownSchema.emptyText,
            name: 'ownSchema',
            inputWidth: 200,
            disabled: true,
            helpText: me.snippets.form.ownSchema.helpText
        }
        ]
    }
});
//{/block}