<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHLPremium\Subscribers;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\CompatibilityCheck as CompatibilityCheckSubscriber;
use Shopware\Plugins\ViisonCommon\Structs\PluginCompatibilityConstraint;

class CompatibilityCheck extends CompatibilityCheckSubscriber
{
    /**
     * @inheritdoc
     */
    public function getPluginCompatibilityConstraints()
    {
        $snippets = $this->get('snippets')->getNamespace('backend/viison_dhl_premium/compatibility_check');

        return [
            new PluginCompatibilityConstraint(
                'Backend',
                'ViisonDHL',
                '4.0.0',
                $snippets->get('viison_dhl/message'),
                true
            )
        ];
    }
}
