<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes;

/**
 * A streaming writer for CSV files.
 *
 * Calling close() on an instance of this class at some point is mandatory, if the
 * output stream has been opened, which in turn is the case when at least one chunk of data
 * has been written to the output stream.
 */
class CsvWriter extends FileResponseStream
{
    /**
     * @param \Enlight_Controller_Response_ResponseHttp $response the response to write to
     * @param string $fileName the name of the download attachment as presented to the user
     * @param bool $forceDownload if true the file should be sent as attachment, that is downloaded and
     *        saved locally by the browser; if false the file is expected to be displayed inline
     *        by the browser
     */
    public function __construct(\Enlight_Controller_Response_ResponseHttp $response, $fileName, $forceDownload = true)
    {
        parent::__construct($response, $fileName, 'text/csv', $forceDownload);
    }

    /**
     * Writes a new CSV line given by a list of CSV values to the output stream.
     *
     * @param array $rowData the column values to write
     * @throws \Exception
     *
     * @deprecated 2.131.2 Please use write instead
     */
    public function writeCsv(array $rowData)
    {
        $this->write($rowData);
    }

    /**
     * Writes a new CSV line given by a list of CSV values to the output stream.
     *
     * @param array $rowData the column values to write
     * @throws \Exception
     */
    public function write($rowData)
    {
        $this->ensureStreamIsWritable();
        fputcsv($this->handle, $rowData, ';');
    }
}
