<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Exceptions;

use Enlight_Components_Snippet_Manager;
use Exception;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;

class CurrencyException extends Exception implements LocalizableThrowable
{
    /**
     * @var string[]
     */
    protected $snippetArguments;

    /**
     * @var string
     */
    protected $snippetName;

    /**
     * @param string $message
     * @param string $snippetName
     * @param array $snippetArguments
     */
    public function __construct($message, $snippetName, array $snippetArguments = [])
    {
        $this->snippetName = $snippetName;
        $this->snippetArguments = $snippetArguments;
        parent::__construct($message);
    }

    /**
     * @inheritdoc
     */
    public function getLocalizedMessage(Enlight_Components_Snippet_Manager $snippetManager)
    {
        $snippet = $snippetManager->getNamespace('exceptions/viison_common/currency_exception')->get(
            $this->snippetName
        );

        return $snippet ? vsprintf($snippet, $this->snippetArguments) : $this->getMessage();
    }

    /**
     * Use this exception when you encounter a currency with no valid factor (i.e. 0.00).
     *
     * @param string $currencyCode
     * @return CurrencyException
     */
    public static function currencyFactorInvalid($currencyCode)
    {
        return new CurrencyException(
            sprintf(
                'The factor of the currency %s is invalid. Please check the currency configuration in the settings.',
                $currencyCode
            ),
            'currency_factor_invalid'
        );
    }
}
