<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Installation\AttributeColumn;

class AttributeColumnDescription
{
    /**
     * @var string
     */
    private $tableName;

    /**
     * @var string
     */
    private $columnName;

    /**
     * @var string
     */
    private $columnType;

    /**
     * @var mixed
     */
    private $defaultValue;

    /**
     * @var bool
     */
    private $nullable;

    /**
     * @param string $tableName
     * @param string $columnName
     * @param string $columnType
     * @param mixed $defaultValue
     * @param bool $nullable
     */
    public function __construct($tableName, $columnName, $columnType = null, $defaultValue = null, $nullable = true)
    {
        $this->tableName = $tableName;
        $this->columnName = $columnName;
        $this->columnType = $columnType;
        $this->defaultValue = $defaultValue;
        $this->nullable = $nullable;
    }

    /**
     * @return string
     */
    public function getTableName()
    {
        return $this->tableName;
    }

    /**
     * @return string
     */
    public function getColumnName()
    {
        return $this->columnName;
    }

    /**
     * @return string
     */
    public function getColumnType()
    {
        return $this->columnType;
    }

    /**
     * @return mixed
     */
    public function getDefaultValue()
    {
        return $this->defaultValue;
    }

    /**
     * @return bool
     */
    public function isNullable()
    {
        return $this->nullable;
    }
}
