<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Subscribers;

use Enlight\Event\SubscriberInterface;
use Shopware\Components\DependencyInjection\Container;
use Shopware\Components\DependencyInjection\ContainerAwareInterface;

/**
 * @deprecated use AbstractBaseSubscriber instead.
 */
// phpcs:ignore VIISON.Classes.AbstractClassName
abstract class Base implements SubscriberInterface, ContainerAwareInterface
{
    /**
     * @var \Shopware_Components_Plugin_Bootstrap $pluginBootstrap
     */
    private $pluginBootstrap;

    /**
     * @var \Shopware\Components\DependencyInjection\Container $container
     */
    private $container;

    /**
     * @param \Shopware_Components_Plugin_Bootstrap $pluginBootstrap
     */
    public function __construct(\Shopware_Components_Plugin_Bootstrap $pluginBootstrap)
    {
        $this->pluginBootstrap = $pluginBootstrap;
        $this->container = $pluginBootstrap->Application()->Container();
    }

    /**
     * Overwrite this method to return the subscribed events and respective method names.
     *
     * @return array
     */
    public static function getSubscribedEvents()
    {
        return [];
    }

    /**
     * @return string
     */
    public function getPluginPath()
    {
        return $this->pluginBootstrap->Path();
    }

    /**
     * @return \Enlight_Config
     */
    public function getPluginConfig()
    {
        return $this->pluginBootstrap->Config();
    }

    /**
     * @return \Shopware_Components_Plugin_Bootstrap $pluginBootstrap
     */
    public function getPluginBootstrap()
    {
        return $this->pluginBootstrap;
    }

    /**
     * @return \Shopware\Components\DependencyInjection\Container
     */
    public function getContainer()
    {
        return $this->container;
    }

    /**
     * @see \Shopware\Components\DependencyInjection\ContainerAwareInterface::setContainer
     */
    public function setContainer(Container $container = null)
    {
        $this->container = $container;
    }

    /**
     * Get service from the DI container.
     *
     * @param string $name
     * @return mixed
     */
    public function get($name)
    {
        return $this->container->get($name);
    }
}
